//+------------------------------------------------------------------+
//|                                             a-SimpleTrailing.mqh |
//|                                             . aka KimIV |
//|                                              http://www.kimiv.ru |
//|                                                                  |
//|    17.11.2005     .              |
//|                                                                  |
//|        start:              |
//|  if (UseTrailing) TrailingPositions();                           |
//+------------------------------------------------------------------+

//-------    -----------------------------------
extern string _Parameters_Trailing = "-----  ";
extern bool UseTrailing    = True;   //  
extern bool ProfitTrailing = True;   //   
extern int  TrailingStop   = 60;     //   
extern int  TrailingStep   = 5;      //  

//+------------------------------------------------------------------+
//|                                 |
//+------------------------------------------------------------------+
void TrailingPositions() {
  for (int i=0; i<OrdersTotal(); i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderSymbol()==Symbol() && OrderMagicNumber()==MAGIC) {
        if (OrderType()==OP_BUY) {
          if (!ProfitTrailing || (Bid-OrderOpenPrice())>TrailingStop*Point) {
            if (OrderStopLoss()<Bid-(TrailingStop+TrailingStep-1)*Point) {
              ModifyStopLoss(Bid-TrailingStop*Point, clModifyBuy);
            }
          }
        }
        if (OrderType()==OP_SELL) {
          if (!ProfitTrailing || OrderOpenPrice()-Ask>TrailingStop*Point) {
            if (OrderStopLoss()>Ask+(TrailingStop+TrailingStep-1)*Point || OrderStopLoss()==0) {
              ModifyStopLoss(Ask+TrailingStop*Point, clModifySell);
            }
          }
        }
      }
    }
  }
}

//+------------------------------------------------------------------+
//|   StopLoss                                          |
//| :                                                       |
//|   ldStopLoss -  StopLoss                                  |
//|   clModify   -                                    |
//+------------------------------------------------------------------+
void ModifyStopLoss(double ldStop, color clModify) {
  bool   fm;
  double ldOpen=OrderOpenPrice();
  double ldTake=OrderTakeProfit();
  int    err;

  if (IsTradeAllowed()) {
    fm=OrderModify(OrderTicket(), ldOpen, ldStop, ldTake, 0, clModify);
    if (!fm) {
      err=GetLastError();
      Print("Error(",err,") modifying: ",ErrorDescription(err));
    }
    if (fm && UseSound) PlaySound(NameFileSound);
  }
}
//+------------------------------------------------------------------+

