//+------------------------------------------------------------------+
//|                                           StepMAExpert_v1.45.mq4 |
//|                           Copyright  2006, TrendLaboratory Ltd. |
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |
//|                                       E-mail: igorad2004@list.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, TrendLaboratory Ltd."
#property link      "http://finance.groups.yahoo.com/group/TrendLaboratory"

#include <stdlib.mqh>
//#include <Tracert.mqh>

//---- input parameters
extern string     Expert_Name =     "---- StepMAExpert_v1.45 ----";

extern int        Magic             = 1007;
extern int        Slippage          = 6;
extern bool       Trace             = false; // Trace Switch

extern string     Main_Parameters = " Trade Volume & Trade Method";
extern double     Lots              = 0.1;
extern int        TrailingStopMode  = 0;     // Trailing Stop Mode Switch (0-without TS, 1-with TS) 
extern double     TrailingStop      = 0;     // Classic Trailing Stop Value  
extern bool       SwingTrade        = false; // Swing or Reverse Trade Switch
extern bool       PendingOrder      = false; // PendingOrder/InstantExecution Switch
extern double     PendOrdGap        = 10;    // Gap from High/Low for Pending Orders
extern int        SessionStart      = 0;     // Start Hour of Trade Session 
extern int        SessionEnd        = 24;    // End Hour of Trade Session
extern int        FilterPeriod      = 50;    // Period of filter (EMA)

extern string     Long_Trade = " Input data for Long Positions";

extern double     StepSizeLong      = 0;     // Step Size (in points)
extern bool       HighLowLong       = false; // High/Low Mode Switch (if true than more sensitive)
extern int        MomPeriodLong     = 1;
extern double     DeltaLong         = 0;     // StepMA Momentum Level(in points)
extern double     DeltaLongExit     = 0;     // StepMA Momentum Level for Exit (in points)
extern double     StopSizeLong      = 1.0;   // Step Size for Trailing Stop (in points) 
extern double     ProfitSizeLong    = 1.0;   // Step Size for Trailing Profit (in points)
extern double     InitialStopLong   = 0;     // Initial Stop Value (in points)
extern double     TakeProfitLong    = 0;     // Take Profit Value (in points)
extern double     BreakEvenLong     = 0;     // BreakEven Level (in points)
extern double     BreakEvenGapLong  = 0;     // BreakEven Gap (in points)

extern string     Short_Trade = " Input data for Short Positions ";

extern double     StepSizeShort     = 0;     // Step Size (in points)
extern bool       HighLowShort      = false; // High/Low Mode Switch (if true than more sensitive)
extern int        MomPeriodShort    = 1;
extern double     DeltaShort        = 0;     // StepMA Momentum Level (in points)
extern double     DeltaShortExit    = 0;     // StepMA Momentum Level for Exit (in points)
extern double     StopSizeShort     = 1.0;   // Step Size for Trailing Stop (in points)
extern double     ProfitSizeShort   = 1.0;   // Step Size for Trailing Profit (in points)
extern double     InitialStopShort  = 0;     // Initial Stop Value (in points)
extern double     TakeProfitShort   = 0;     // Take Profit Value (in points)
extern double     BreakEvenShort    = 0;     // BreakEven Level (in points)
extern double     BreakEvenGapShort = 0;     // BreakEven Gap (in points)

extern string     MM_Parameters = " MoneyManagement by L.Williams ";
extern bool       MM                = false; //  Switch
extern double     Risk              = 0.15;  // Risk Factor
extern double     LossMax           = 1000;  // Maximum Loss by 1 Lot

int      Length=10;
double   Kv=1.0;     
int      trend=0,TradeSignal=0,ExitSignal=0,prevtrendlong=0,matrendlong=0,
         matrendshort=0,prevtrendshort=0,Kz=0,mode=0,Type=0, numords;
double   Smin1=0,Smax1=0,Price=0,PriceStop=0, BuyProfit=0, SellProfit=0;
double   line0long=0,line1long=0,bsmin1long=0,bsmax1long=0, StepLong=0,Smin1long=0,Smax1long=0, 
         line0short=0,line1short=0,bsmin1short=0,bsmax1short=0,StepShort=0,Smin1short=0,Smax1short=0, 
         point=0, spread=0;
double   BuyStop=0,SellStop=0,ATRmin=10000,ATRmax=0,bsmax2=0,bsmin2=0;
int      b=0,cnt=0, digit=0;
bool     FirstTime = false;
//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
//---- 
FirstTime = true;   
//----
   return(0);
  }
  
// ---- Scan Trades
int ScanTrades()
{   
   int total = OrdersTotal();
   int numords = 0;
      
   for(int cnt=0; cnt<total; cnt++) 
   {        
   OrderSelect(cnt, SELECT_BY_POS);            
   if(OrderSymbol() == Symbol() && OrderType()<=OP_SELLSTOP && OrderMagicNumber() == Magic) 
   numords++;
   }
   return(numords);
}      

void TrailProfit()
{        
    int total=OrdersTotal();
    for (cnt=0;cnt<total;cnt++)
    { 
     OrderSelect(cnt, SELECT_BY_POS);   
     mode=OrderType();    
        if ( OrderSymbol()==Symbol() && OrderMagicNumber()==Magic ) 
        {
            if ( mode==OP_BUY )
            {
            if (ProfitSizeLong > 0) 
            //BuyProfit = line0 + Kp*Step/Kv; 
            BuyProfit = bsmax1long;
            else BuyProfit = OrderTakeProfit();
            //Print("BuyProfit=",BuyProfit," lin0=",line0," Step=",Step," Kp,Kv=", Kp,",",Kv);  
              if( BuyProfit > OrderTakeProfit())
              { 
              OrderModify(OrderTicket(),OrderOpenPrice(),
                          OrderStopLoss(),
                          NormalizeDouble(BuyProfit,digit),0,LightGreen);
			     return(0);
			     }
            }
            if ( mode==OP_SELL )
            {
            if (ProfitSizeShort > 0) 
            //SellProfit = line0 - Kp*Step/Kv;
            SellProfit = bsmin1short; 
            else SellProfit = OrderTakeProfit();
            //Print("SellProfit=",SellProfit," lin0=",line0," Step=",Step," Kp,Kv=", Kp,",",Kv); 
              if( SellProfit < OrderTakeProfit())
              {  
   		     OrderModify(OrderTicket(),OrderOpenPrice(),
   		                 OrderStopLoss(),
   		                 NormalizeDouble(SellProfit, digit),0,Yellow);	    
              return(0);
              }
            }    
        }
    }   
}   
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
  {
   int total,ticket;
//---- 
   
   //if ( Trace ) SetTrace();
   if (Bars>b)
   {      
   b=Bars;
   digit  = MarketInfo(Symbol(),MODE_DIGITS);
   point  = MarketInfo(Symbol(),MODE_POINT);  
   //spread = MarketInfo(Symbol(),MODE_SPREAD);
   
   double Lotsi=Lots;     
      
   if ( MM ) Lotsi=NormalizeDouble(Lots*Lots*AccountFreeMargin()*Risk/LossMax,1);   
   if (Lotsi<0.1) Lotsi=0.1;
   
   double line1longexit = line0long;
   if (MomPeriodLong == 1 ) prevtrendlong = matrendlong;
   else prevtrendlong = iCustom(NULL,0,"StepMA_v7EA",Length,Kv,StepSizeLong,0,0,0,HighLowLong,0,0,5,MomPeriodLong+1);
   line1long= iCustom(NULL,0,"StepMA_v7EA",Length,Kv,StepSizeLong,0,0,0,HighLowLong,0,0,0,MomPeriodLong+1);
   line0long = iCustom(NULL,0,"StepMA_v7EA",Length,Kv,StepSizeLong,0,0,0,HighLowLong,0,0,0,1); 
   matrendlong = iCustom(NULL,0,"StepMA_v7EA",Length,Kv,StepSizeLong,0,0,0,HighLowLong,0,0,5,1);   
   
   double line1shortexit = line0short;
   if (MomPeriodShort == 1 ) prevtrendshort = matrendshort;
   else prevtrendshort = iCustom(NULL,0,"StepMA_v7EA",Length,Kv,StepSizeShort,0,0,0,HighLowShort,0,0,5,MomPeriodShort+1);
   line1short= iCustom(NULL,0,"StepMA_v7EA",Length,Kv,StepSizeShort,0,0,0,HighLowShort,0,0,0,MomPeriodShort+1); 
   line0short = iCustom(NULL,0,"StepMA_v7EA",Length,Kv,StepSizeShort,0,0,0,HighLowShort,0,0,0,1); 
   matrendshort = iCustom(NULL,0,"StepMA_v7EA",Length,Kv,StepSizeShort,0,0,0,HighLowShort,0,0,5,1);
   
   
   if(StepSizeLong>0) StepLong=Kv*StepSizeLong*point; 
   if(StepSizeShort>0) StepShort=Kv*StepSizeShort*point;
	
	bsmin1long = line0long - ProfitSizeLong*point;
   bsmax1long = line0long + ProfitSizeLong*point;
	  
	double slinelong = line0long;
	Smin1long= slinelong - StopSizeLong*point;
	Smax1long= slinelong + StopSizeLong*point; 
    
   bsmin1short = line0short - ProfitSizeShort*point;
   bsmax1short = line0short + ProfitSizeShort*point;
	  
	double slineshort = line0short;
	Smin1short= slineshort - StopSizeShort*point;
	Smax1short= slineshort + StopSizeShort*point; 
	
	   
   //if ( i==1 ){ FirstTime = false; 
   //Print (" i=",i," line0=",line0," line1=",line1," matrend=", matrend, " Step=", Step); }
   //else
   //if ( i == NBars )
   //Print ("Smin=",Smin1," Smax=",Smax1," matrend=", matrend, " Step=", Step); 
     
   //}
// -----------
      bool TimeCondition = false;
      TimeCondition = (TimeHour(CurTime()) >= SessionStart && TimeHour(CurTime()) <=SessionEnd);

// ------------
      if ( FilterPeriod > 0 )
      {
      bool BuyFilter = false;
      BuyFilter = ( Close[1]>iMA(NULL,0,FilterPeriod,0,MODE_EMA,0,1));
      
      bool SellFilter = false; 
      SellFilter =( Close[1]<iMA(NULL,0,FilterPeriod,0,MODE_EMA,0,1));
      }
      else
      { BuyFilter = true; SellFilter = true; }
// ------------
// Trade Signal area	
      if(!SwingTrade) TradeSignal=0; 	
// - BUY      
      if 
      (
      BuyFilter
      &&
      line0long-line1long>DeltaLong*point
      &&
      line1long>0
      && 
      prevtrendlong < 0 
      //|| prevtrend2 < 0) 
      )  TradeSignal= 1;
// - SELL      
      if 
      (
      SellFilter
      &&
      line1short-line0short>DeltaShort*point
      &&
      line1short>0
      && 
      prevtrendshort > 0 
      //|| prevtrend2 > 0)
      )  TradeSignal= -1;
//Print (" line0=",line0," line1=",line1," matrend=", matrend, " signal=", TradeSignal); 
// Exit Signal area	
       	
// - BUY Orders      
      if 
      (
      //Close[1]<iMA(NULL,0,50,0,MODE_EMA,0,1)
      //||
      line1longexit-line0long>DeltaLongExit*point
      //line1long-line0long>0
      )  ExitSignal= -1;
// - SELL Orders      
      if 
      (
      //Close[1]>iMA(NULL,0,50,0,MODE_EMA,0,1)
      //||
      line0short-line1shortexit>DeltaShortExit*point
      //line0short-line1short>0
      )  ExitSignal= 1;
      
      //if(SwingTrade) ExitSignal=TradeSignal;
         
      TrailProfit();       
//-----------------------------
      total=OrdersTotal();
	   for (cnt=0;cnt<total;cnt++)
      { 
       OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);   
       mode=OrderType();
       if ( OrderSymbol()==Symbol() && OrderMagicNumber()==Magic)
       { 
// Orders Close area  : 
// - BUY Orders         
         if ( ExitSignal<0 )
         {
            if (mode==OP_BUY)
                  {
			         OrderClose(OrderTicket(),OrderLots(),Bid,Slippage,Yellow);
			         }
         }
// - SELL Orders          
         if ( ExitSignal>0 )
	      {
            if (mode==OP_SELL)
			         {
   			      OrderClose(OrderTicket(),OrderLots(),Ask,Slippage,White);
                  }
         }    
      
          //if (BreakEvenShort > 0 || BreakEvenLong > 0)
          //{
             if (mode==OP_BUY && BreakEvenLong > 0)
                  {
			         BuyStop = OrderStopLoss();
			         if (Bid-OrderOpenPrice() > Kz*BreakEvenLong*point) 
			            {
			            BuyStop=OrderOpenPrice()+((Kz-1)*BreakEvenLong+BreakEvenGapLong)*point;
			            OrderModify(OrderTicket(),OrderOpenPrice(),
			                        NormalizeDouble(BuyStop, digit),
			                        OrderTakeProfit(),0,LightBlue);
			            Kz=Kz+1;
			            return(0);
			            }
			         }
               if (mode==OP_SELL && BreakEvenShort > 0)
                  {
                  SellStop = OrderStopLoss();
                  if (OrderOpenPrice()-Ask > Kz*BreakEvenShort*point) 
			            {
			            SellStop=OrderOpenPrice()-((Kz-1)*BreakEvenShort+BreakEvenGapShort)*point;
			            OrderModify(OrderTicket(),OrderOpenPrice(),
			                        NormalizeDouble(SellStop, digit),
			                        OrderTakeProfit(),0,Orange);
			            Kz=Kz+1;
			            return(0);
			            }
			         }
           //}
    
// Orders Modify Area 
           if (TrailingStopMode > 0) 
           {
              if (mode==OP_BUY) 
              {
			     if (TrailingStop > 0)
			     BuyStop = Bid - TrailingStop*point;
			     else 
			     if ( StopSizeLong > 0) 
			     //BuyStop = line0 - Ks*Step/Kv - spread;
			     BuyStop = Smin1long; 
			     else BuyStop = OrderStopLoss();
			        if ( BuyStop > OrderStopLoss() || OrderStopLoss()==0) 
			        {
			        OrderModify(OrderTicket(),OrderOpenPrice(),
			                    NormalizeDouble(BuyStop, digit),
			                    OrderTakeProfit(),0,LightGreen);
			        return(0);
                 }
              }
// - SELL Orders          
              if (mode==OP_SELL)
              {
              if (TrailingStop > 0)
			     BuyStop = Ask + TrailingStop*point;
			     else 
              if ( StopSizeShort > 0) 
              //SellStop = line0 + Ks*Step/Kv + spread; 
              SellStop = Smax1short; 
              else SellStop = OrderStopLoss(); 
                 if( SellStop < OrderStopLoss() || OrderStopLoss()==0) 
                 {
                 OrderModify(OrderTicket(),OrderOpenPrice(),
   			                 NormalizeDouble(SellStop, digit),
   			                 OrderTakeProfit(),0,Yellow);	    
                 return(0);
                 }
              }
           }    
      }
            
// Closing of Pending Orders      
      if(Close[1]<MathMin(iMA(NULL,0,FilterPeriod,0,MODE_EMA,0,1),line0long))int PendClose=1; 
      if(Close[1]>MathMax(iMA(NULL,0,FilterPeriod,0,MODE_EMA,0,1),line0short))    PendClose=-1;  
      
      if (mode==OP_BUYSTOP && PendClose>0 && OrderSymbol()==Symbol() && OrderMagicNumber()==Magic)
      {
	 	OrderDelete(OrderTicket());
	   return(0);
	   }
	    
      if (mode==OP_SELLSTOP && PendClose<0 && OrderSymbol()==Symbol() && OrderMagicNumber()==Magic) 
	 	{
	 	OrderDelete(OrderTicket());
	   return(0);
	   }      
      }//for (cnt=0;cnt<total;cnt++)
// Orders open area :
// - SELL Orders  		     
		
		
		if (ScanTrades()<1)
      {     
		   if ( trend>=0 && TradeSignal<0 && TimeCondition) 
         {  
            if(PendingOrder)
		  	   {
		    	   Type=OP_SELLSTOP;
		    	   Price=Low[1]-PendOrdGap*point;
		 	      PriceStop=Price;  
		 	   }
		 	   else
		  	   {
		   	   Type=OP_SELL;
		    	   Price=Bid;
		  	      PriceStop=Ask; 
		  	   }
		  	   
		  	   if (InitialStopShort > 0)
            SellStop = PriceStop + InitialStopShort*point; 
            else
            if( StopSizeShort > 0) 
            //SellStop= line0 + Ks*Step/Kv + spread; 
            SellStop= Smax1short; 
            else SellStop=0;
            
            if (TakeProfitShort > 0)
            SellProfit = Price - TakeProfitShort*point;
            else 
            if (ProfitSizeShort > 0) 
            //SellProfit = line0 - Kp*Step/Kv; 
            SellProfit = bsmin1short; 
            else SellProfit=0;
            
            ticket=OrderSend(Symbol(),Type,Lotsi,
		                       NormalizeDouble(Price, digit),
		                       Slippage,
		                       NormalizeDouble(SellStop, digit),
		                       NormalizeDouble(SellProfit, digit),
		                       "sell",Magic,0,Red);
            Kz=1;
            if(SwingTrade) trend=-1; else {trend=0;}
            if(ticket<0)
            {
            Print("OrderSend failed with error #",GetLastError());
            return(0);
            }
		      return(0);
		   }
// - BUY Orders         
	      if (trend <=0 &&  TradeSignal>0 && TimeCondition)
	      {
            if(PendingOrder)
		    	{
		    	   Type=OP_BUYSTOP;
		    	   Price=High[1]+PendOrdGap*point;
		    	   PriceStop = Price;  
		    	}
		    	else
		    	{
		    	   Type=OP_BUY;
		    	   Price=Ask;
		    	   PriceStop = Bid;
		    	}
		    	
		    	if (InitialStopLong > 0)
            BuyStop = PriceStop - InitialStopLong*point; 
            else
            if ( StopSizeLong > 0) 
            //BuyStop = line0-Ks*Step/Kv-spread; 
            BuyStop = Smin1long;
            else BuyStop=0;
            
            if (TakeProfitLong > 0)
            BuyProfit = Price + TakeProfitLong*point;
            else 
            if (ProfitSizeLong > 0) 
            //BuyProfit = line0 + Kp*Step/Kv;
            BuyProfit = bsmax1long; 
            else BuyProfit=0;
            
		    	ticket=OrderSend(Symbol(),Type,Lotsi,
		    	                 NormalizeDouble(Price, digit),
		    	                 Slippage,
		    	                 NormalizeDouble(BuyStop, digit),
		    	                 NormalizeDouble(BuyProfit, digit),
		    	                 "buy",Magic,0,Blue);
                  
            Kz=1;
            if(SwingTrade) trend=1; else {trend=0;}
            if(ticket<0)
            {
            Print("OrderSend failed with error #",GetLastError());
            return(0);
            }
			   return(0);
         }
      }
      

      
      
      
      
      }//if (Bars>b)
//----                          
 

//----
   return(0);
  }
//+------------------------------------------------------------------+