//+------------------------------------------------------------------+
//|                                                  Straddle_EA.mq4 |
//|                                                           branac |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "branac"
#property link      "http://www.metaquotes.net"

//---- input parameters
extern double    Lots=0.1;
extern double    Pips=10;
extern double    TP=10;
extern double    SL=10;
extern bool      Buy=true;
extern bool      Sell=true;
extern datetime  _Date=D'2006.08.01 15:30';
//extern datetime expiration=D'2006.08.02 03:25';
  int    buy_orders=0;
  int    sell_orders=0;

//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
//----
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
  {
//----
  int ticket;
  // The spread is included in the sl and tp calculations
  double buy_price = Ask + Pips*Point;
  double sell_price = Bid - Pips*Point;
  double stoploss_buy;
  double takeprofit_buy;
  double stoploss_sell;
  double takeprofit_sell;
    
  
  if (SL == 0)
  {
   stoploss_buy = 0;
  }
  else
  {
   stoploss_buy = Bid+(Pips-SL)*Point;
  }
  
  if (TP == 0)
  {
   takeprofit_buy = 0;
  }
  else
  {
   takeprofit_buy = Ask+(Pips+TP)*Point;
  }

  if (SL == 0)
  {
   stoploss_sell = 0;
  }
  else
  {
   stoploss_sell = Ask-(Pips-SL)*Point;
  }
  
  if (TP == 0)
  {
   takeprofit_sell = 0;
  }
  else
  {
   takeprofit_sell = Bid-(Pips+TP)*Point;
  }

  
  if(LocalTime()>=_Date)
       {
         // Buy order
         if ( (Buy == true) && (buy_orders == 0) )
         {
            ticket=OrderSend(Symbol(),OP_BUYSTOP,Lots,buy_price,2,stoploss_buy,takeprofit_buy,"Buy order ",00001,0,CLR_NONE);
            buy_orders = buy_orders + 1;
            if(ticket<0)
            {
               Print("OrderSend failed with error #",GetLastError());
               return(0);
            }
         }
         // Sell order
         if ( (Sell == true) && (sell_orders == 0) )
         {
            ticket=OrderSend(Symbol(),OP_SELLSTOP,Lots,sell_price,2,stoploss_sell,takeprofit_sell,"Buy order ",00002,0,CLR_NONE);
            sell_orders++;
            if(ticket<0)
            {
               Print("OrderSend failed with error #",GetLastError());
               return(0);
            }
         }
         }
  

//----
   return(0);
  }
//+------------------------------------------------------------------+