//+------------------------------------------------------------------+
//|                                                    Hans123MMBESL |
//|                                     Copyright  2005, Ji Kovcs|
//+------------------------------------------------------------------+
  
//---- input parameters
extern string    data="/CPI/";
extern int       Start1=12;
extern int       min=28;
extern double    Length=0.1; // range pedchozho High a Low z cel hodiny
extern int       EOD=17; // ukonen v ase EOD
extern int       Pips=5; // entry nad / pod aktuln cenou
extern int       StopLoss=25; 
extern int       BreakEven=15; // pi dosaen BE,BE1,BE2,BE3 pesun SL na BEpips,BEpips1,BEpips2,BEpips3
extern int       BreakEven1=35; 
extern int       BreakEven2=55;
extern int       BreakEven3=75;
extern int       BreakEvenSL=85; // po dosaen BreakEvenSL aktivace Trailing SL
extern int       BEpips=5; 
extern int       BEpips1=15;
extern int       BEpips2=35;
extern int       BEpips3=55;
extern int       TrailingSL=8;
extern int       TrailingStopStep=0;
extern int       TakeProfit=200;
extern double    Lots=0.1;
extern bool      AccountIsMicro=false; // mini et nebo standart
extern bool      MM=false; // Fixed Risk,ano nebo ne
extern double    Risk=0.02; // Risk na jeden obchod 2% z tu 
extern bool      UpTrend=true;
extern bool      DownTrend=true;
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+

int start()
  {
   //---- 
     
   int i,Ticket,EODTime,MN;
   double StartTime,LastOrderTime,Lots; 
    

   //Nastaven asu
   if(CurTime()>=StrToTime(Start1+":00")-60){
    datetime StartTime1=StrToTime(StringConcatenate(Start1, ":", min));
      if(DayOfWeek()==5)   EODTime=MathMin(StrToTime("22:55"),StrToTime(EOD+":00"));
      else if (EOD==24)    EODTime=StrToTime("23:59");
      else                 EODTime=StrToTime(EOD+":00")-60;
      
   }
 
   if(CurTime()>=StartTime1 && CurTime()<StartTime1+300){
      MN=555;
      StartTime=StartTime1;
      SetOrders(MN,StartTime);
   
   }
      
   //kontrola objednvky
   for (i=0;i<OrdersTotal();i++){
      OrderSelect(i,SELECT_BY_POS,MODE_TRADES);
      if(OrderComment()=="Hans123MMBESL"+data+Symbol()){
      if(CurTime()<=GlobalVariableGet("LastOrderTime")+10) Sleep(10000);
      if(CurTime()>=EODTime) {     //uzaven pozice v ase EOD
         if(OrderSymbol()==Symbol() && OrderType()==OP_BUY  ) OrderClose(OrderTicket(),OrderLots(),Bid,3,Red);
         if(OrderSymbol()==Symbol() && OrderType()==OP_SELL ) OrderClose(OrderTicket(),OrderLots(),Ask,3,Red);
         if(OrderSymbol()==Symbol() && OrderType()==OP_BUYSTOP  ) OrderDelete(OrderTicket());
         if(OrderSymbol()==Symbol() && OrderType()==OP_SELLSTOP) OrderDelete(OrderTicket());
         
      }
      else {   
         if(TrailingStopStep==0){    //pesun SL do BE + profit
            if(OrderSymbol()==Symbol() && OrderType()==OP_BUY){
               if(High[0]-OrderOpenPrice()>=BreakEven*Point && OrderStopLoss()<OrderOpenPrice()){
                  OrderModify(OrderTicket(),OrderOpenPrice(),OrderOpenPrice()+BEpips*Point,OrderTakeProfit(),0,Green);
                  GlobalVariableSet("LastOrderTime",CurTime());
               }   
               if(High[0]-OrderOpenPrice()>=BreakEven1*Point && (OrderStopLoss()==OrderOpenPrice()+BEpips*Point)){
                  OrderModify(OrderTicket(),OrderOpenPrice(),OrderOpenPrice()+BEpips1*Point,OrderTakeProfit(),0,Green);
                  GlobalVariableSet("LastOrderTime",CurTime());
               } 
               if(High[0]-OrderOpenPrice()>=BreakEven2*Point && (OrderStopLoss()==OrderOpenPrice()+BEpips1*Point)){
                  OrderModify(OrderTicket(),OrderOpenPrice(),OrderOpenPrice()+BEpips2*Point,OrderTakeProfit(),0,Green);
                  GlobalVariableSet("LastOrderTime",CurTime());
               }
               if(High[0]-OrderOpenPrice()>=BreakEven3*Point && (OrderStopLoss()==OrderOpenPrice()+BEpips2*Point)){
                  OrderModify(OrderTicket(),OrderOpenPrice(),OrderOpenPrice()+BEpips3*Point,OrderTakeProfit(),0,Green);
                  GlobalVariableSet("LastOrderTime",CurTime());
               }
               if(High[0]-OrderOpenPrice()>BreakEvenSL*Point && (OrderStopLoss()>=OrderOpenPrice()+BEpips3*Point)){
                  if(High[0] > OrderStopLoss() + TrailingSL*Point){
                  OrderModify(OrderTicket(),OrderOpenPrice(),High[0]-TrailingSL*Point,OrderTakeProfit(),0,Green);
                  return(0);
               }
             }    
           } //BUY       
            if(OrderSymbol()==Symbol() && OrderType()==OP_SELL){
               if(OrderOpenPrice()-Low[0]>=BreakEven*Point && OrderStopLoss()>OrderOpenPrice()){
                  OrderModify(OrderTicket(),OrderOpenPrice(),OrderOpenPrice()-BEpips*Point,OrderTakeProfit(),0,Green);
                  GlobalVariableSet("LastOrderTime",CurTime());
               }
               if(OrderOpenPrice()-Low[0]>=BreakEven1*Point && (OrderStopLoss()==OrderOpenPrice()-BEpips*Point)){
                  OrderModify(OrderTicket(),OrderOpenPrice(),OrderOpenPrice()-BEpips1*Point,OrderTakeProfit(),0,Green);
                  GlobalVariableSet("LastOrderTime",CurTime());
               }
               if(OrderOpenPrice()-Low[0]>=BreakEven2*Point && (OrderStopLoss()==OrderOpenPrice()-BEpips1*Point)){
                  OrderModify(OrderTicket(),OrderOpenPrice(),OrderOpenPrice()-BEpips2*Point,OrderTakeProfit(),0,Green);
                  GlobalVariableSet("LastOrderTime",CurTime());
               }
               if(OrderOpenPrice()-Low[0]>=BreakEven3*Point && (OrderStopLoss()==OrderOpenPrice()-BEpips2*Point)){
                  OrderModify(OrderTicket(),OrderOpenPrice(),OrderOpenPrice()-BEpips3*Point,OrderTakeProfit(),0,Green);
                  GlobalVariableSet("LastOrderTime",CurTime());
               }
               if(OrderOpenPrice()-Low[0]>=BreakEvenSL*Point && (OrderStopLoss()<=OrderOpenPrice()-BEpips3*Point)){
                  if(OrderStopLoss()-Low[0]>TrailingSL*Point){
                  OrderModify(OrderTicket(),OrderOpenPrice(),Low[0]+TrailingSL*Point,OrderTakeProfit(),0,Green);
                  return(0) ;
               }
             } 
           } //SELL
              
         }
         else {                  //use trailing stop
            if(OrderSymbol()==Symbol() && OrderType()==OP_BUY){
               if(High[0]-OrderStopLoss()>=(StopLoss+TrailingStopStep)*Point){
                  OrderModify(OrderTicket(),OrderOpenPrice(),OrderStopLoss()+TrailingStopStep*Point,OrderTakeProfit(),0,Green);
                  GlobalVariableSet("LastOrderTime",CurTime());
               }   
            }   
            if(OrderSymbol()==Symbol() && OrderType()==OP_SELL){
               if(OrderStopLoss()-Low[0]>=(StopLoss+TrailingStopStep)*Point){
                  OrderModify(OrderTicket(),OrderOpenPrice(),OrderStopLoss()-TrailingStopStep*Point,OrderTakeProfit(),0,Green);
                  GlobalVariableSet("LastOrderTime",CurTime());
                  }
                }
              } //else
              
           }
        }
     }

   if(CurTime()>=EODTime) GlobalVariablesDeleteAll();
   
   return(0);
  }
//+------------------------------------------------------------------+

int SetOrders(int MN,double StartTime){
   int i,Ticket,LastOrderTime,Bought=0,Sold=0,ShiftToBeginOfRange;
   double EntryLong,EntryShort,SLLong,SLShort,TPLong,ShiftToStart,TPShort,LotsFR;
 
//------------------------------- MM Fixed Risk ------------------------------------ 
   if(MM==true){ 
   
      
   if(AccountIsMicro==true){ //micro et
   
   LotsFR=NormalizeDouble( (AccountFreeMargin()*Risk) /StopLoss,1);
   if(LotsFR<0.1) Lots=Lots; 
   if(LotsFR>50) Lots=50;
   if((LotsFR>=0.1) && (LotsFR<50)) Lots=LotsFR;
    }
   if(AccountIsMicro==false){ //bn et 
   
   LotsFR=MathCeil( (AccountFreeMargin()*Risk) /StopLoss) /10;
   if(LotsFR<0.1) Lots=Lots; 
   if(LotsFR>50) Lots=50;
   if((LotsFR>=0.1) && (LotsFR<50)) Lots=LotsFR;
    }
   
   }
   else{
   if(MM==false) Lots=Lots;
   }
//----------------------------------------------------------------------------------      
   //Uren psma
   ShiftToStart=iBarShift(NULL,0,StartTime)+1;
   ShiftToBeginOfRange=MathCeil(iBarShift(NULL,0,StartTime-Length*3600));
   EntryLong   =High[Highest(NULL,0,MODE_HIGH,ShiftToBeginOfRange,ShiftToStart)]+Pips*Point;
   EntryShort  =Low [Lowest (NULL,0,MODE_LOW, ShiftToBeginOfRange,ShiftToStart)]-Pips*Point;
   SLLong      =MathMax(EntryLong-StopLoss*Point,EntryShort);
   SLShort     =MathMin(EntryShort+StopLoss*Point,EntryLong);
   TPLong      =EntryLong+TakeProfit*Point;
   TPShort     =EntryShort-TakeProfit*Point;
   
   
   //Check Orders
   for (i=0;i<OrdersTotal();i++){
      OrderSelect(i,SELECT_BY_POS,MODE_TRADES);
      if(OrderSymbol()==Symbol()  && (OrderType()==OP_BUYSTOP || OrderType()==OP_BUY) && OrderMagicNumber()==MN) Bought++;
      if(Bought>1){ //more than 1 buy order
         if(CurTime()<=GlobalVariableGet("LastOrderTime")+10) Sleep(10000);
         if(OrderSymbol()==Symbol() && OrderType()==OP_BUY && OrderMagicNumber()==MN)      OrderClose(OrderTicket(),OrderLots(),Bid,3,Orange);
         if(OrderSymbol()==Symbol() && OrderType()==OP_BUYSTOP && OrderMagicNumber()==MN)  OrderDelete(OrderTicket());
      }
      if(OrderSymbol()==Symbol() && (OrderType()==OP_SELLSTOP || OrderType()==OP_SELL) && OrderMagicNumber()==MN) Sold++;
      if(Sold>1){ //more than 1 sell order
         if(CurTime()<=GlobalVariableGet("LastOrderTime")+10) Sleep(10000);
         if(OrderSymbol()==Symbol() && OrderType()==OP_SELL && OrderMagicNumber()==MN)     OrderClose(OrderTicket(),OrderLots(),Ask,3,Orange);
         if(OrderSymbol()==Symbol() && OrderType()==OP_SELLSTOP && OrderMagicNumber()==MN) OrderDelete(OrderTicket());
      }
   }
   if(Bought==0 && UpTrend==true){ //no buy order
      if(CurTime()<=GlobalVariableGet("LastOrderTime")+10) Sleep(10000);
      Ticket=OrderSend(Symbol(),OP_BUYSTOP,Lots,EntryLong,3,SLLong,TPLong,"Hans123MMBESL"+data+Symbol(),MN,0,Orange);
      if(Ticket<0 &&  High[0]>=EntryLong)
         Ticket=OrderSend(Symbol(),OP_BUY,Lots,Ask,3,SLLong,TPLong,"Hans123MMBESL"+data+Symbol(),MN,0,Orange);
      GlobalVariableSet("LastOrderTime",OrderOpenTime()); 
   }
   if(Sold==0 && DownTrend==true){ //no sell order
      if(CurTime()<=GlobalVariableGet("LastOrderTime")+10) Sleep(10000);
      Ticket=OrderSend(Symbol(),OP_SELLSTOP,Lots,EntryShort,3,SLShort,TPShort,"Hans123MMBESL"+data+Symbol(),MN,0,Orange);
      if(Ticket<0 && Low[0]<=EntryShort)
         Ticket=OrderSend(Symbol(),OP_SELL,Lots,Bid,3,SLShort,TPShort,"Hans123MMBESL"+data+Symbol(),MN,0,Orange);
     GlobalVariableSet("LastOrderTime",OrderOpenTime()); 
   }
}

