//+------------------------------------------------------------------+
//|                                                  DayBrekaout.mq4 |
//|                                                          DarkMan |
//|                                                  CMFX Forex Team |
//+------------------------------------------------------------------+
#property copyright "DarkMan"
#property link      "CMFX Forex Team"

extern double Lots = 0.1;
extern int    EOD = 18;

#define CNT        2
#define OPEN_TIME  0
#define AVG        1


int LastBar[CNT];
int MagicNumber = 11001;
string OrderText = "DayBreak";
double BarOpenPrice = 0;

int start(){
   if (DayOfWeek()==0 || DayOfWeek()==6) return(0); //v nedeli a v sobotu nic nedelam
   
   bool Nastavit = false;
   int BUY  = 0;
   int SELL = 0; 
   int EODTime=StrToTime(EOD+":00");
   if ( StrToTime("00:00:01")>=CurTime()-30 ){ //30s kontroluju novy bar a zadavam objednavky
      if (LastBar[OPEN_TIME]!=iTime(NULL,PERIOD_D1,0)){
         LastBar[OPEN_TIME] = iTime(NULL,PERIOD_D1,0);
         LastBar[AVG] = GetAvgOfDay();
         BarOpenPrice = iOpen(NULL,PERIOD_D1,0);
      }
      Nastavit = true;      
   }

   //+-------------------------Rizeni objednavek-----------------------------------------+
   for (int x=0;x<OrdersTotal();x++){         
         OrderSelect(x,SELECT_BY_POS,MODE_TRADES);      
         if(OrderMagicNumber() == MagicNumber && OrderSymbol()==Symbol()){
         
            if(CurTime()>=EODTime){     //zavru vse v urcitou hodinu
               if(OrderType()==OP_BUY)      OrderClose(OrderTicket(),OrderLots(),Bid,3,Red);
               if(OrderType()==OP_SELL)     OrderClose(OrderTicket(),OrderLots(),Ask,3,Red);
               if(OrderType()==OP_BUYSTOP)  OrderDelete(OrderTicket());
               if(OrderType()==OP_SELLSTOP) OrderDelete(OrderTicket());
            }      

            //===========================================
            //Pusunu Proti pozice na SL exekuovane pozice
            if(OrderType()==OP_BUY){          
               if (OrderOpenPrice()>OrderStopLoss()){                                   
                  if(High[0]-OrderOpenPrice()>=(LastBar[AVG]/2)*Point){
                     OrderModify(OrderTicket(),OrderOpenPrice(),OrderOpenPrice(),OrderTakeProfit(),0,Green);
                     //Soupnu SL na BE a SELL STOP na otviraci cenu                     
                     ModifyOrder(false,OrderOpenPrice());
                  }  
                  //Pokud jsem exekuovanej soupnu SELL STOP na SL
                  ModifyOrder(false,OrderStopLoss()); 
               }
            }   
            if(OrderType()==OP_SELL){
               if (OrderOpenPrice()<OrderStopLoss()){
                  if(OrderOpenPrice()-Low[0]>=(LastBar[AVG]/2)*Point ){
                     OrderModify(OrderTicket(),OrderOpenPrice(),OrderOpenPrice(),OrderTakeProfit(),0,Green);    
                     //Soupnu SL na BE a BUY STOP na otviraci cenu
                     ModifyOrder(true,OrderOpenPrice());              
                  }
                  //Pokud jsem exekuovanej soupnu BUY STOP na SL
                  ModifyOrder(true,OrderStopLoss());              
               }
            }        
            //===================================    
            //Trailing SL
            if(OrderType()==OP_BUY){
               if(High[0]-OrderStopLoss()>=(LastBar[AVG]/2)*Point && OrderOpenPrice()<=OrderStopLoss()){
                  OrderModify(OrderTicket(),OrderOpenPrice(),High[0]-(LastBar[AVG]/2)*Point,OrderTakeProfit(),0,Green);
                  ModifyOrder(false,High[0]-(LastBar[AVG]/2)*Point);
               }   
            }   
            if(OrderType()==OP_SELL){
               if(OrderStopLoss()-Low[0]>=(LastBar[AVG]/2)*Point && OrderOpenPrice()>=OrderStopLoss()){
                  OrderModify(OrderTicket(),OrderOpenPrice(),Low[0]+(LastBar[AVG]/2)*Point,OrderTakeProfit(),0,Green);    
                  ModifyOrder(true,Low[0]+(LastBar[AVG]/2)*Point);              
               }
            }            
         }
   }//For      
   
   if (Nastavit){      
      if(GetNumOfOrder(true)==0){
         double EntryLong = BarOpenPrice + ((LastBar[AVG]/2) * Point);
         double LongTP = 0; //EntryLong + ((LastBar[AVG]/2) * Point);
         while(!OrderSend(Symbol(),OP_BUYSTOP,Lots,EntryLong,3,BarOpenPrice,LongTP,OrderText,MagicNumber,0,Lime) && GetNumOfOrder(true)==0){
            Sleep(3000);
         }
      }
      
      if (GetNumOfOrder(false)==0){
         double EntryShort = BarOpenPrice - ((LastBar[AVG]/2) * Point);         
         double ShortTP = 0; //EntryShort - ((LastBar[AVG]/2) * Point);
         while(!OrderSend(Symbol(),OP_SELLSTOP,Lots,EntryShort,3,BarOpenPrice,ShortTP,OrderText,MagicNumber,0,Red) && GetNumOfOrder(false)==0){
            Sleep(3000);
         }
      }
   }
        
   return(0);
}
//+------------------------------------------------------------------+
void ModifyOrder(bool Long, double Price){
   double LongSL, LongTP, ShortSL, ShortTP;
   LongSL  = Price - ((LastBar[AVG]/2) * Point);
   LongTP  = 0; //Price + ((LastBar[AVG]/2) * Point);
   ShortSL = Price + ((LastBar[AVG]/2) * Point);
   ShortTP = 0; //Price - ((LastBar[AVG]/2) * Point);
   for (int x=0;x<OrdersTotal();x++){         
      OrderSelect(x,SELECT_BY_POS,MODE_TRADES);      
      if(OrderMagicNumber() == MagicNumber && OrderSymbol()==Symbol()){ 
         if (Long  && OrderType()==OP_BUYSTOP && Price<OrderOpenPrice() ) OrderModify(OrderTicket(),Price, LongSL, LongTP,0,OrangeRed);
         if (!Long && OrderType()==OP_SELLSTOP && Price>OrderOpenPrice()) OrderModify(OrderTicket(),Price,ShortSL,ShortTP,0,OrangeRed);
      }      
   }
}

//Vraci prumerny range dne
int GetAvgOfDay(){
   int R1=0,R5=0,R10=0,R20=0,RAvg=0;
     
   for(int i=1;i<=20;i++){
      if (i<=5)  R5  =  R5 + (iHigh(NULL,PERIOD_D1,i)-iLow(NULL,PERIOD_D1,i))/Point;
      if (i<=10) R10 = R10 + (iHigh(NULL,PERIOD_D1,i)-iLow(NULL,PERIOD_D1,i))/Point;
      if (i<=20) R20 = R20 + (iHigh(NULL,PERIOD_D1,i)-iLow(NULL,PERIOD_D1,i))/Point;
   }
   
   R1 = (iHigh(NULL,PERIOD_D1,1)-iLow(NULL,PERIOD_D1,1))/Point;
   R5 = R5/5;
   R10 = R10/10;
   R20 = R20/20;
   RAvg  =  (R1+R5+R10+R20)/4;   
   return(RAvg);
}

//Vraci pocet vystavenych objednavek 
int GetNumOfOrder(bool Long){
   int Buy, Sell;
   for (int x=0;x<OrdersTotal();x++){         
      OrderSelect(x,SELECT_BY_POS,MODE_TRADES);      
      if(OrderMagicNumber() == MagicNumber && OrderSymbol()==Symbol()){
         if (OrderType()==OP_BUY  || OrderType()==OP_BUYSTOP) Buy++;
         if (OrderType()==OP_SELL || OrderType()==OP_SELLSTOP) Sell++;
      }
   }
   
   if (Long)  return(Buy);
   if (!Long) return(Sell);
}