//+------------------------------------------------------------------+
//| Floating Pivot idea by SID                                       |
//|                                                           DarkMan|
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "DarkMan"
#property link      ""

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 White
#property indicator_color2 Yellow
#property indicator_color3 Blue
#property indicator_color4 Purple


//---- input parameters
extern int  Pivot1=25;
extern int  Pivot2=50;
extern int  Pivot3=100;
extern int  Pivot4=200;
//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,ExtMapBuffer1);
   
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,ExtMapBuffer2);
   
   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2,ExtMapBuffer3);
   
   SetIndexStyle(3,DRAW_LINE);   
   SetIndexBuffer(3,ExtMapBuffer4);
   
   SetIndexDrawBegin(0,19);
   string short_name="PIVO od SIDa";
   IndicatorShortName(short_name);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
  int    limit,i,x;  
  int    counted_bars=IndicatorCounted();
   
  // Always prepare all of the information for the other indicators
  if(counted_bars<0) return(-1);
  if(counted_bars>0) counted_bars--;
  limit=Bars-counted_bars;
  
  //---- main loop
  for(i=limit; i>=0; i--)
  {
    /*
     ExtMapBuffer1[i] = (iHigh(NULL,0,Highest(NULL,0,MODE_HIGH,Pivot1,i))+iLow(NULL,0,Lowest(NULL,0,MODE_LOW,Pivot1,i))+Close[i])/3;
     ExtMapBuffer2[i] = (iHigh(NULL,0,Highest(NULL,0,MODE_HIGH,Pivot2,i))+iLow(NULL,0,Lowest(NULL,0,MODE_LOW,Pivot2,i))+Close[i])/3;
     ExtMapBuffer3[i] = (iHigh(NULL,0,Highest(NULL,0,MODE_HIGH,Pivot3,i))+iLow(NULL,0,Lowest(NULL,0,MODE_LOW,Pivot3,i))+Close[i])/3;
     ExtMapBuffer4[i] = (iHigh(NULL,0,Highest(NULL,0,MODE_HIGH,Pivot4,i))+iLow(NULL,0,Lowest(NULL,0,MODE_LOW,Pivot4,i))+Close[i])/3;
     */
     ExtMapBuffer1[i] = (High[Highest(NULL,0,MODE_HIGH,Pivot1,i)]+Low[Lowest(NULL,0,MODE_LOW,Pivot1,i)])/2;
     ExtMapBuffer2[i] = (High[Highest(NULL,0,MODE_HIGH,Pivot2,i)]+Low[Lowest(NULL,0,MODE_LOW,Pivot2,i)])/2;
     ExtMapBuffer3[i] = (High[Highest(NULL,0,MODE_HIGH,Pivot3,i)]+Low[Lowest(NULL,0,MODE_LOW,Pivot3,i)])/2;
     ExtMapBuffer4[i] = (High[Highest(NULL,0,MODE_HIGH,Pivot4,i)]+Low[Lowest(NULL,0,MODE_LOW,Pivot4,i)])/2;     

  }       
   return(0);
}
//+------------------------------------------------------------------+