//+------------------------------------------------------------------+
//|                                              ZigZag_new_nen3.mq4 |
//|                      Copyright  2005, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, MetaQuotes Software Corp."
#property link      "http://onix-trade.net/forum/index.php?s=&showtopic=118&view=findpost&p=117369"
#property indicator_chart_window
#property indicator_buffers  1
#property indicator_color1 Red
#property indicator_width1 0
#property indicator_style1 0
//---- 
extern int ExtDepth=21;
extern int ExtDeviation=13;
extern int ExtBackstep=34;
//---- 
//---- 
double ZigZagBuffer[];
int timeFirstBar=0;
//+------------------------------------------------------------------+
//| ZigZag initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
//---- 
   SetIndexBuffer(0,ZigZagBuffer); 
   SetIndexStyle(0,DRAW_SECTION);
   SetIndexEmptyValue(0,0.0);
   IndicatorShortName("ZigZag("+ExtDepth+","+ExtDeviation+","+ExtBackstep+")");
//---- 
   return(0);
  }
//+------------------------------------------------------------------+
//|  ZigZag iteration function                                       |
//+------------------------------------------------------------------+
int start()
  {
   //----+         
   if (Bars-1<ExtDepth)return(0);
   //----+           
   static int time2,time3,time4;  
   //----+            
   static  double ZigZag2,ZigZag3,ZigZag4;
   //----+               
   int MaxBar,limit,supr2_bar,supr3_bar,supr4_bar,counted_bars=IndicatorCounted();
   //----    
   if (counted_bars<0)return(-1);
   //----      
   if (counted_bars>0) counted_bars--;
   //----+      
   int    index, shift, back,lasthighpos,lastlowpos;
   double val,res,TempBuffer[1];
   double curlow,curhigh,lasthigh,lastlow;
   //----     ,         
   MaxBar=Bars-ExtDepth; 
   //----       ,         
   if (counted_bars==0 || Bars-counted_bars>2)
     {
      limit=MaxBar;
     }
   else 
     {
      //----
      supr2_bar=iBarShift(NULL,0,time2,TRUE);
      supr3_bar=iBarShift(NULL,0,time3,TRUE);
      supr4_bar=iBarShift(NULL,0,time4,TRUE);
      //----
      limit=supr3_bar;      
      if ((supr2_bar<0)||(supr3_bar<0)||(supr4_bar<0))
         {
          limit=MaxBar;
         }
     }
     
   //----  
   if (limit>=MaxBar || timeFirstBar!=Time[Bars-1]) 
     {
      timeFirstBar=Time[Bars-1];
      limit=MaxBar; 
     } 
   //----  
   //----    

if (limit==MaxBar) ArrayResize(TempBuffer,Bars); else  ArrayResize(TempBuffer,limit+ExtBackstep+1);
     
   //----+-------------------------------------------------+ 
   
   //----+    
   for(shift=limit; shift>=0; shift--)
     {
      //--- Low
      val=Low[Lowest(NULL,0,MODE_LOW,ExtDepth,shift)];
      if(val==lastlow) val=0.0;
      else 
        { 
         lastlow=val; 
         if((Low[shift]-val)>(ExtDeviation*Point)) val=0.0;
         else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
               res=ZigZagBuffer[shift+back];
               if((res!=0)&&(res>val)) ZigZagBuffer[shift+back]=0.0; 
              }
           }
        }
      if (Low[shift]==val) ZigZagBuffer[shift]=val; else ZigZagBuffer[shift]=0.0;
      //--- High
      val=High[Highest(NULL,0,MODE_HIGH,ExtDepth,shift)];
      if(val==lasthigh) val=0.0;
      else 
        {
         lasthigh=val;
         if((val-High[shift])>(ExtDeviation*Point)) val=0.0;
         else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
               res=TempBuffer[shift+back]; 
               if((res!=0)&&(res<val)) TempBuffer[shift+back]=0.0; 
              } 
           }
        }
      if (High[shift]==val) TempBuffer[shift]=val; else TempBuffer[shift]=0.0;
     }
   //----+     
      
   // final cutting 
      lasthigh=-1; lasthighpos=-1;
      lastlow= -1; lastlowpos= -1;
   //----+-------------------------------------------------+
   
   //----+    

   for(shift=limit; shift>=0; shift--)
     {
      curlow=ZigZagBuffer[shift];
      curhigh=TempBuffer[shift];
      if((curlow==0)&&(curhigh==0)) continue;
      //---
      if(curhigh!=0)
        {
         if(lasthigh>0) 
           {
            if(lasthigh<curhigh) TempBuffer[lasthighpos]=0;
            else TempBuffer[shift]=0;
           }
         //---
         if(lasthigh<curhigh || lasthigh<0)
           {
            lasthigh=curhigh;
            lasthighpos=shift;
           }
         lastlow=-1;
        }
      //----
      if(curlow!=0)
        {
         if(lastlow>0)
           {
            if(lastlow>curlow) ZigZagBuffer[lastlowpos]=0;
            else ZigZagBuffer[shift]=0;
           }
         //---
         if((curlow<lastlow)||(lastlow<0))
           {
            lastlow=curlow;
            lastlowpos=shift;
           } 
         lasthigh=-1;
        }
     }
   //----+    
     
   //----+-------------------------------------------------+
   
   //----+   
   for(shift=limit; shift>=0; shift--)
     {
       res=TempBuffer[shift];
       if(res!=0.0) ZigZagBuffer[shift]=res;
     }
     //----+   
     
   //   
   int i=0,j=0;
   res=0;
   for (shift=0;i<3;shift++)
     {
      if (ZigZagBuffer[shift]>0)
        {
         i++;
         if (i==1 && ZigZagBuffer[shift]==High[shift])
           {
            j=shift;
            res=ZigZagBuffer[shift];
           }
         if (i==2 && res>0 && ZigZagBuffer[shift]==High[shift])
           {
            if (ZigZagBuffer[shift]>=ZigZagBuffer[j]) ZigZagBuffer[j]=0; else ZigZagBuffer[shift]=0;
            res=0;
            i=0;
            j=0;
            shift=0;
           }
        }
     }

   //+---    ,     
   if (limit<MaxBar)
     {
      ZigZagBuffer[supr2_bar]=ZigZag2; 
      ZigZagBuffer[supr3_bar]=ZigZag3; 
      ZigZagBuffer[supr4_bar]=ZigZag4; 
      for(int qqq=supr4_bar-1; qqq>supr3_bar; qqq--)ZigZagBuffer[qqq]=0; 
      for(int ggg=supr3_bar-1; ggg>supr2_bar; ggg--)ZigZagBuffer[ggg]=0;
     }
   //+---+============================================+
  
   //+---    
   double vel1, vel2, vel3, vel4;
   int bar1, bar2, bar3, bar4;
   int count;
   if (limit==MaxBar)supr4_bar=MaxBar;
   for(int bar=supr4_bar; bar>=0; bar--)
    {
     if (ZigZagBuffer[bar]!=0)
      {
       count++;
       vel4=vel3;bar4=bar3;
       vel3=vel2;bar3=bar2;
       vel2=vel1;bar2=bar1;
       vel1=ZigZagBuffer[bar];bar1=bar;
       if (count<3)continue; 
       if ((vel3<vel2)&&(vel2<vel1)){ZigZagBuffer[bar2]=0;bar=bar3+1;}
       if ((vel3>vel2)&&(vel2>vel1)){ZigZagBuffer[bar2]=0;bar=bar3+1;}
       if ((vel2==vel1)&&(vel1!=0 )){ZigZagBuffer[bar1]=0;bar=bar3+1;}
     }
    } 
   //+---             
   time2=Time[bar2];
   time3=Time[bar3];
   time4=Time[bar4];
   ZigZag2=vel2;  
   ZigZag3=vel3; 
   ZigZag4=vel4; 
   //+---          
 //----    
return(0);
}
 //---+ +---------------------------------------------------------------------+