//+------------------------------------------------------------------+
//|                                                        BucTD.mq4 |
//|                                                    Version 1.02  |
//|                                    Copyright  2007, Petr Kouril |
//|                                           http://www.jaktrade.cz |
//+------------------------------------------------------------------+

#property copyright "Copyright  2007, Petr Kouril"
#property link      "http://www.jaktrade.cz"

// Needed Custom Indicator

#property indicator_chart_window
#property indicator_buffers  2
#property indicator_color1 OrangeRed
#property indicator_color2 OrangeRed
#property indicator_color3 OrangeRed

//---- input parameters

extern int			TimeFrame 		      = 0;
extern int        TDStart              = 13;
extern int        TDEnd                = 15;
extern bool       ReverseCandleOnly    = false;           // Long signal only if it is bearish candle and vice versa

extern bool			AlertPossible        = true;
extern bool			SendMailPossible     = false;

int               DrawGap              = 7;


//---- buffers
double EnterShort[];
double EnterLong[];

int init()
{
	IndicatorBuffers(2);
	
	SetIndexStyle (0, DRAW_ARROW, EMPTY);
   SetIndexArrow (0, 234);
   SetIndexBuffer(0, EnterShort);

	SetIndexStyle (1, DRAW_ARROW, EMPTY);
   SetIndexArrow (1, 233);
   SetIndexBuffer(1, EnterLong);

   return(0);
}

int deinit()
{
   return(0);
}

int start()
{
   int Num, i, j, counted_bars = IndicatorCounted();
   if (counted_bars<0) return(-1);
   if (counted_bars>0) counted_bars--;
   int limit = Bars-counted_bars;

	for (i = limit-1; i >= 0; i--)
	{
		EnterShort[i] = EMPTY_VALUE;
		EnterLong[i]  = EMPTY_VALUE;

      if (!ReverseCandleOnly || (Close[i] <= Open[i]))
      {
         Num = 0;
         for (j = 0; j < TDEnd+1; j++)
         {
            if (Close[j+i+1] < Close[j+i+5])
               Num++;
            else
               break;
         }
         if ((Num >= TDStart) && (Num <= TDEnd))
         {
            EnterLong[i]  = iLow  (Symbol(), TimeFrame, i) - (DrawGap * Point);
            MakeAlert(Symbol()+" TDS Long" , i);
         }
      }  

      if (!ReverseCandleOnly || (Close[i] >= Open[i]))
      {
         Num = 0;
         for (j = 0; j < TDEnd+1; j++)
         {
            if (Close[j+i+1] > Close[j+i+5])
               Num++;
            else
               break;
         }
         if ((Num >= TDStart) && (Num <= TDEnd))
         {
            EnterShort[i] = iHigh (Symbol(), TimeFrame, i) + (DrawGap * Point);
            MakeAlert(Symbol()+" TDS Short" , i);
         }
      }
	}

   return(0);
}

datetime	AlertTime;
void MakeAlert(string _Notice, int Index)
{
	if (Index >= 1)            								 return;
	if (AlertTime == iTime(Symbol(), TimeFrame, Index)) return;
	
	AlertTime = iTime(Symbol(), TimeFrame, Index);
	string Notice = StringConcatenate("PB ", Symbol(), " ", GetPeriodString(), " ", _Notice);
	if (AlertPossible)    {PlaySound("alert2.wav"); Alert(Notice);}
	if (SendMailPossible) SendMail(Notice, "");
}

string GetPeriodString()
{
	int CurrentPeriod = TimeFrame;
	if (TimeFrame == 0)
		CurrentPeriod = Period();
		
	switch (CurrentPeriod)
	{
		case PERIOD_M1:  return ("M1");
		case PERIOD_M5:  return ("M5");
		case PERIOD_M15: return ("M15");
		case PERIOD_M30: return ("M30");
		case PERIOD_H1:  return ("H1");
		case PERIOD_H4:  return ("H4");
		case PERIOD_D1:  return ("D1");
		case PERIOD_W1:  return ("W1");
		default:			  return ("???");
	}
}

