//+------------------------------------------------------------------+
//|                                       INDInverse_EMAdirection.mq4 |
//+------------------------------------------------------------------+
#property indicator_separate_window
#property indicator_buffers 4
#property indicator_color1 Silver
#property indicator_color2 Black
#property indicator_color3 DodgerBlue
#property indicator_color4 Magenta
#property indicator_maximum 0.23
#property indicator_minimum -0.23


double Buffer[], hist[];
double up[], dn[];

extern int FastEMA = 20;
extern int SlowEMA = 50;
extern int iPeriod = 1;



//----
//+------------------------------------------------------------------+
//| Init                                                             |
//+------------------------------------------------------------------+
int init()
{
    SetIndexStyle(0,DRAW_HISTOGRAM,0,2);
    SetIndexBuffer(0,hist);    
    SetIndexStyle(1,DRAW_NONE);
    SetIndexBuffer(1,Buffer);


  SetIndexBuffer (2,up);
  SetIndexBuffer (3,dn);
  SetIndexStyle (2,DRAW_ARROW,EMPTY,1);
  SetIndexStyle (3,DRAW_ARROW,EMPTY,1);
  SetIndexArrow (2,225);
  SetIndexArrow (3,226);

//----
    return(0);
}

//+------------------------------------------------------------------+
//| Parabolic Sell And Reverse system                                |
//+------------------------------------------------------------------+
int start()
  {
   int limit, i;
   int counted_bars=IndicatorCounted();

//---- check for possible errors
   if(counted_bars<0) 
   {
      return(-1);
   }
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;

//---- do it
   
  
    for (i=limit-1; i>=0; i--)
    {
        // Easy to read
        double HD = High[Highest(NULL,0,MODE_HIGH,(iPeriod* 20),i)];
        double LD = Low[Lowest(NULL,0,MODE_LOW,(iPeriod* 20),i)];
        double amplitude = HD - LD;                
        Buffer[i]= ((Close[i]-(HD-(amplitude/2)))/amplitude) * iPeriod;
        
    }
   
    for (i=limit-1-SlowEMA; i>=0; i--)
      hist[i] = iMAOnArray (Buffer,0,FastEMA,0,MODE_EMA,i) - iMAOnArray (Buffer,0,SlowEMA,0,MODE_EMA,i);

    for (i=limit-1-SlowEMA-1; i>=0; i--)
    {
      if (hist[i] > 0 && hist[i+1] < 0)
        up[i] = 0;
      if (hist[i] < 0 && hist[i+1] > 0)
        dn[i] = 0;
    }
    
   return(0);
  }
//+------------------------------------------------------------------+