//+------------------------------------------------------------------+
//|                                INDInverse_EMAdirection_color.mq4 |
//+------------------------------------------------------------------+
#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1 DodgerBlue
#property indicator_color2 Tomato
#property indicator_color3 Black
#property indicator_maximum 0.25
#property indicator_minimum -0.25
#property indicator_level1 0.09
#property indicator_level2 -0.09


double Buffer[], up[], dwn[];

extern int FastEMA = 20;
extern int SlowEMA = 50;
extern int iPeriod = 1;



//----
//+------------------------------------------------------------------+
//| Init                                                             |
//+------------------------------------------------------------------+
int init()
{
//---- indicators
    IndicatorBuffers(3);
//    IndicatorDigits(Digits+2);

    SetIndexStyle(0,DRAW_HISTOGRAM,EMPTY,2);
    SetIndexBuffer(0,up);    
    SetIndexStyle(1,DRAW_HISTOGRAM,EMPTY,2);
    SetIndexBuffer(1,dwn);        
    SetIndexStyle(2,DRAW_NONE);
    SetIndexBuffer(2,Buffer);

//----
    return(0);
}

//+------------------------------------------------------------------+
//| Parabolic Sell And Reverse system                                |
//+------------------------------------------------------------------+
int start()
  {
   int limit, i;
   double tmp, tmpold;
   int counted_bars=IndicatorCounted();

//---- check for possible errors
   if(counted_bars<0) 
   {
      return(-1);
   }
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;

//---- do it
   
  
    for (i=limit-1; i>=0; i--)
    {
        // Easy to read
        double HD = High[Highest(NULL,0,MODE_HIGH,(iPeriod* 20),i)];
        double LD = Low[Lowest(NULL,0,MODE_LOW,(iPeriod* 20),i)];
        double amplitude = HD - LD;                
        Buffer[i]= ((Close[i]-(HD-(amplitude/2)))/amplitude) * iPeriod;
        
    }
   
 
    for (i=limit-1-SlowEMA; i>=0; i--){
      tmp = iMAOnArray (Buffer,0,FastEMA,0,MODE_EMA,i) - iMAOnArray (Buffer,0,SlowEMA,0,MODE_EMA,i);
      if (tmp>tmpold){ 
          up[i]=tmp;
          dwn[i]=0.0;
      }          
      if (tmp<tmpold){
          up[i]=0.0;
          dwn[i]=tmp;      
      }
      tmpold=tmp;
    }
   return(0);
  }
//+------------------------------------------------------------------+