//+---------------------------------------------------------------------+
//|                                               IND Inverse Histo.mq4 |
//+---------------------------------------------------------------------+
#property copyright "bartliomiej.gorski@gmail.com"
#property link      "http://www.forex-tsd.com/"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 Green
#property indicator_color2 Red
//#property indicator_maximum 1
//#property indicator_minimum -1
//---- input parameters
//---- buffers
double Buffer1[];
double Buffer2[];

double Buffer[];
double MaBuffer[];

extern int iPeriod = 1;
extern int MaPeriod = 50;
//----
//+------------------------------------------------------------------+
//| Init                                                             |
//+------------------------------------------------------------------+
int init()
{
//---- indicators
    IndicatorBuffers(4);
    IndicatorDigits(Digits+2);
    
    SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,3);
    SetIndexBuffer(0,Buffer1);
    SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID,3);
    SetIndexBuffer(1,Buffer2);
    
    SetIndexBuffer(2,Buffer);
    SetIndexBuffer(3,MaBuffer);
    IndicatorShortName("IND INVERSE HISTOGRAM V1");
    
//----
    return(0);
}

//+------------------------------------------------------------------+
//| Parabolic Sell And Reverse system                                |
//+------------------------------------------------------------------+
int start()
  {
   int limit;
   int counted_bars=IndicatorCounted();

//---- check for possible errors
   if(counted_bars<0) 
   {
      return(-1);
   }
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;

//---- do it
   
  
    for(int i=0; i<limit; i++)
    {
        // Easy to read
        double HD = High[Highest(NULL,0,MODE_HIGH,(iPeriod* 20),i)];
        double LD = Low[Lowest(NULL,0,MODE_LOW,(iPeriod* 20),i)];
        double amplitude = HD - LD;                
        Buffer[i]= ((Close[i]-(HD-(amplitude/2)))/amplitude) * iPeriod;
    }
    
    for(int m=0;m < limit;m++) MaBuffer[m] = iMAOnArray(Buffer,0,MaPeriod,0,MODE_EMA,m);
    
    for(int b = 0;b < limit;b++)
    {
      if(Buffer[b]>MaBuffer[b])
      {
         if(Buffer1[b]>0)
         Buffer1[b] = Buffer[b];
         else 
         Buffer1[b] = -Buffer[b];
         
         Buffer2[b] = 0;
      }
      else if(Buffer[b]<MaBuffer[b])
      {
         Buffer1[b] = 0;
         
         if(Buffer[b]>0)   
         Buffer2[b] = -Buffer[b];
         else
         Buffer2[b] = Buffer[b];
      }
      else 
      {
         Buffer1[b] = 0;
         Buffer2[b] = 0;
      }
    }  
//----
   return(0);
  }
//+------------------------------------------------------------------+