/***************************************************************************
* Name := JR123
* Author := Karci
* Notes := Patern 123. Hladm body paternu a potom nastavm fibo line.
* Link := karol_r@inmail.sk
***************************************************************************/
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Blue
#property indicator_color2 Red
#property indicator_width1 1
#property indicator_width2 1

extern int spr = 5;
extern int Limit_Bar = 100;
extern bool zvuk = true;
extern bool Pozn = true;

#define MAX_POLE 13
#define COLOR_A Coral
#define COLOR_B RoyalBlue
#define COLOR_C C'190,190,0'


int i, j, cnt, x, xp, xm;
double val, res, sup;
double TP1, TP2, TP3, SL, RRR1, RRR2, RRR3, pip, pip1, pip2, pip3;
int patern, limit;
int Pole_zn[MAX_POLE], Pole_poz[MAX_POLE];  //typ, pozcia v grafe
double Pole_hod[MAX_POLE];                  //hodnota
double Pole_ind1[], Pole_ind2[];

int deinit() {
  Comment("");
  ObjectDelete("TL1H");
  ObjectDelete("TL2H");
  ObjectDelete("TL1L");
  ObjectDelete("TL2L");
  ObjectDelete("MyFibo");
}


int init() {
  //indikatory - farebne kolieska
  IndicatorBuffers(2);
  SetIndexStyle(0,DRAW_ARROW);
  SetIndexArrow(0,159);
  SetIndexDrawBegin(0,0);
  SetIndexLabel(0,"Top");
  SetIndexBuffer(0,Pole_ind1);
  SetIndexStyle(1,DRAW_ARROW);
  SetIndexArrow(1,159);
  SetIndexDrawBegin(1,0);
  SetIndexLabel(1,"Bottom");
  SetIndexBuffer(1,Pole_ind2);
  //objekty
  ObjectCreate("MyFibo",OBJ_FIBO,0,0,0,0); ObjectSet("MyFibo",OBJPROP_COLOR,COLOR_A); ObjectSet("MyFibo",OBJPROP_LEVELCOLOR,COLOR_A);
  ObjectSet("MyFibo",OBJPROP_STYLE,STYLE_DOT); ObjectSet("MyFibo",OBJPROP_LEVELSTYLE,STYLE_DOT);
  ObjectCreate("TL1H",OBJ_TREND,0,0,0,0); ObjectSet("TL1H",OBJPROP_COLOR,COLOR_A);
  ObjectCreate("TL2H",OBJ_TREND,0,0,0,0); ObjectSet("TL2H",OBJPROP_COLOR,COLOR_C); ObjectSet("TL2H",OBJPROP_STYLE,STYLE_DOT);
  ObjectCreate("TL1L",OBJ_TREND,0,0,0,0); ObjectSet("TL1L",OBJPROP_COLOR,COLOR_B);
  ObjectCreate("TL2L",OBJ_TREND,0,0,0,0); ObjectSet("TL2L",OBJPROP_COLOR,COLOR_C); ObjectSet("TL2L",OBJPROP_STYLE,STYLE_DOT);
  objekty_skry();
  return(0);
}

int start() {
  if (Limit_Bar > 0 ) {
     limit = Limit_Bar; }
   else
     {
     limit = Bars - 1;
     }
  //podla funkcie Fractals, ktora je standardny indikator v MT4, rozdelim do pola
  //vrchy a spodky (body obratu) a ak vytvoria 1-2-3 patern, tak ich zobrazim v grafe
  x = 1; xp = 0; xm = 0;
  for(cnt = 0; cnt < limit; cnt++) {
    if(x > MAX_POLE) break;
    //Ukladme maxim
    if(iFractals(NULL,0,MODE_UPPER,cnt) > 0) {
      Pole_hod[x] = High[cnt];
      if(xp == 0) res = High[cnt];
      Pole_poz[x] = cnt;
      Pole_zn[x] = +1;
      Pole_ind1[cnt] = Pole_hod[x];
      x++;
      xp++;
      }
    //Ukladme minim
    if(iFractals(NULL,0,MODE_LOWER,cnt) > 0) {
      Pole_hod[x] = Low[cnt];
      if(xm == 0) sup = Low[cnt];
      Pole_poz[x] = cnt;
      Pole_zn[x] = -1;
      Pole_ind2[cnt] = Pole_hod[x];
      x++;
      xm++;
      }
    }

  //**************************************************************************************
  //   Hladme Ross 1-2-3 High, Low, alebo 2B Top, Bottom
  //**************************************************************************************

  patern = '';
  objekty_skry();
  for(i = 1; i < MAX_POLE-2; i++) {
    //1-2-3
    if((Pole_zn[i+2] > 0) && (Pole_zn[i+1] < 0) && (Pole_zn[i] > 0)) {  // && (Low[Pole_poz[i+2]] > High[Pole_poz[i+1]])
      if(Pole_hod[i] < Pole_hod[i+2]) {
        // Ross 1-2-3 High
        if(!objekty_nastav123H(i)) continue;
        if(zvuk) {
          Alert(Symbol(),"    ",Hour(),":",Minute(),"  SELL: ",Pole_hod[i+1]);
          zvuk = False;
          }
        patern = 'H';
        }
      else {
        // 2B Top
        if(((Pole_hod[i]-Pole_hod[i+2])/Point) <= spr) patern = 'T';
        else patern = 'S';
        }
      break;  //koniec, mame hodnotu
      }
    //1-2-3
    if((Pole_zn[i+2] < 0) && (Pole_zn[i+1] > 0) && (Pole_zn[i] < 0)) {  // && (High[Pole_poz[i+2]] < Low[Pole_poz[i+1]])
      if(Pole_hod[i] > Pole_hod[i+2]) {
        // Ross 1-2-3 Low
        if(!objekty_nastav123L(i)) continue;
        if(zvuk) {
          Alert(Symbol(),"    ",Hour(),":",Minute(),"  BUY: ",Pole_hod[i+1]);
          zvuk = False;
          }
        patern = 'L';
        }
      else {
        // 2B Top
        if(((Pole_hod[i+2]-Pole_hod[i])/Point) <= spr) patern = 'B';
        else patern = 'S';
        }
      break;  //koniec, mame hodnotu
      }
    }

  //**************************************************************************************
  //   Komentre v grafe
  //**************************************************************************************
  if(Pozn ) {
    // v tejto casti si zobrazim na grafe vstup, 3 x vstup a stoploss
    switch(patern) {
      //1-2-3 High
      case 'H':
        val = Pole_hod[i+2]-Pole_hod[i+1];
        TP1 = Pole_hod[i+1]-MathFloor((val*0.618)/Point)*Point;
        TP2 = Pole_hod[i+1]-val;
        TP3 = Pole_hod[i+1]-val-MathFloor((val*0.618)/Point)*Point;
        SL = High[Pole_poz[i+1]];
        pip = (SL-Pole_hod[i+1])/Point;
        pip1 = (Pole_hod[i+1]-TP1)/Point;
        pip2 = (Pole_hod[i+1]-TP2)/Point;
        pip3 = (Pole_hod[i+1]-TP3)/Point;
        RRR1 = MathFloor((Pole_hod[i+1]-TP1)/(SL-Pole_hod[i+1])*100)/100;
        RRR2 = MathFloor((Pole_hod[i+1]-TP2)/(SL-Pole_hod[i+1])*100)/100;
        RRR3 = MathFloor((Pole_hod[i+1]-TP3)/(SL-Pole_hod[i+1])*100)/100;
        Comment("Spr = ",(Ask-Bid)/Point,"  H-L = ",(res-sup)/Point,"\n1-2-3 High",
                "\nStopLoss = ",SL," (",pip,")","\nSell Stop = ",Pole_hod[i+1],
                "\n1. TP = ",TP1," (",pip1,")","   R1 =",RRR1,
                "\n2. TP = ",TP2," (",pip2,")","   R2 = ",RRR2,
                "\n3. TP = ",TP3," (",pip3,")","   R3 = ",RRR3);
        break;
      //1-2-3 Low
      case 'L':
        val = Pole_hod[i+1]-Pole_hod[i+2];
        TP1 = Pole_hod[i+1]+MathFloor((val*0.618)/Point)*Point;
        TP2 = Pole_hod[i+1]+val;
        TP3 = Pole_hod[i+1]+val+MathFloor((val*0.618)/Point)*Point;
        SL = Low[Pole_poz[i+1]];
        pip = (Pole_hod[i+1]-SL)/Point;
        pip1 = (TP1-Pole_hod[i+1])/Point;
        pip2 = (TP2-Pole_hod[i+1])/Point;
        pip3 = (TP3-Pole_hod[i+1])/Point;
        RRR1 = MathFloor((TP1-Pole_hod[i+1])/(Pole_hod[i+1]-SL)*100)/100;
        RRR2 = MathFloor((TP2-Pole_hod[i+1])/(Pole_hod[i+1]-SL)*100)/100;
        RRR3 = MathFloor((TP3-Pole_hod[i+1])/(Pole_hod[i+1]-SL)*100)/100;
        Comment("Spr = ",(Ask-Bid)/Point,"  H-L = ",(res-sup)/Point,"\n1-2-3 Low",
                "\n3. TP = ",TP3," (",pip3,")","   R3 = ",RRR3,
                "\n2. TP = ",TP2," (",pip2,")","   R2 = ",RRR2,
                "\n1. TP = ",TP1," (",pip1,")","   R1 = ",RRR1,
                "\nBuy Stop = ",Pole_hod[i+1],"\nStopLoss = ",SL," (",pip,")");
        break;
      // 2B Top (alebo reversal patern)
      case 'T':
        pip=(Pole_hod[i]-Low[Pole_poz[i]])/Point;
        Comment("Spr = ",(Ask-Bid)/Point,"  H-L = ",(res-sup)/Point,"\n2B Top","\nSell Stop = ",Low[Pole_poz[i]],
                "\nStopLoss = ",Pole_hod[i]," (",pip,")");
        break;
      // 2B Bottom
      case 'B':
        pip=(High[Pole_poz[i]]-Pole_hod[i])/Point;
        Comment("Spr = ",(Ask-Bid)/Point,"  H-L = ",(res-sup)/Point,"\n2B Bottom",
                "\nBuy Stop = ",High[Pole_poz[i]],"\nStopLoss = ",Pole_hod[i]," (",pip,")");
        break;
      case 'S':
        i = 1;
        // toto tam nemusi byt, je to len pre informciu ak nie je patern
        Comment("Spr = ",(Ask-Bid)/Point," H-L = ",(res-sup)/Point,"\nres  = ",res,"\nsup = ",sup);
        if(Pole_zn[i] != Pole_zn[i+1]) {
          ObjectMove("MyFibo",0,Time[Pole_poz[i]],Pole_hod[i]); ObjectMove("MyFibo",1,Time[Pole_poz[i+1]],Pole_hod[i+1]);
           ObjectSet("MyFibo",OBJPROP_COLOR,COLOR_C);
           ObjectSet("MyFibo",OBJPROP_LEVELCOLOR,COLOR_C);
           ObjectSet("MyFibo",OBJPROP_TIMEFRAMES,OBJ_ALL_PERIODS);
          }
        break;
      }
    }
  else {
    // toto bola len pomocka pri ladeni indikatora
    Comment("01 = ",Pole_poz[1]," : ",Pole_hod[1]," ",Pole_zn[1],"\n02 = ", Pole_poz[2]," : ",Pole_hod[2]," ",Pole_zn[2],
          "\n03 = ",Pole_poz[3]," : ",Pole_hod[3]," ",Pole_zn[3],"\n04 = ", Pole_poz[4]," : ",Pole_hod[4]," ",Pole_zn[4],
          "\n05 = ",Pole_poz[5]," : ",Pole_hod[5]," ",Pole_zn[5],"\n06 = ", Pole_poz[6]," : ",Pole_hod[6]," ",Pole_zn[6],
          "\n07 = ",Pole_poz[7]," : ",Pole_hod[7]," ",Pole_zn[7],"\n08 = ", Pole_poz[8]," : ",Pole_hod[8]," ",Pole_zn[8],
          "\n09 = ",Pole_poz[9]," : ",Pole_hod[9]," ",Pole_zn[9],"\n10 = ",Pole_poz[10]," : ",Pole_hod[10]," ",Pole_zn[10]);
    }
  return(0);
}

//**********************************
//vypnut zobrazenie objektov v grafe
int objekty_skry() {
  ObjectSet("MyFibo",OBJPROP_TIMEFRAMES,-1);
  ObjectSet("TL1H",OBJPROP_TIMEFRAMES,-1);
  ObjectSet("TL2H",OBJPROP_TIMEFRAMES,-1);
  ObjectSet("TL1L",OBJPROP_TIMEFRAMES,-1);
  ObjectSet("TL2L",OBJPROP_TIMEFRAMES,-1);
}

//**********************************
int objekty_nastav123H(int ai) {
  ObjectMove("TL1H",0,Time[Pole_poz[ai+2]],Pole_hod[ai+2]); ObjectMove("TL1H",1,Time[Pole_poz[ai]],Pole_hod[ai]);
  if(Pole_hod[ai] < Ask) return(false);
  ObjectMove("TL2H",0,Time[Pole_poz[ai]],Pole_hod[ai]); ObjectMove("TL2H",1,Time[Pole_poz[ai]-2],High[Pole_poz[ai]-2]);
  ObjectMove("MyFibo",0,Time[Pole_poz[ai+1]],Pole_hod[ai+1]); ObjectMove("MyFibo",1,Time[Pole_poz[ai+2]],Pole_hod[ai+2]);
   ObjectSet("MyFibo",OBJPROP_COLOR,COLOR_A);
   ObjectSet("MyFibo",OBJPROP_LEVELCOLOR,COLOR_A);
  //zobrazit objekty
  ObjectSet("MyFibo",OBJPROP_TIMEFRAMES,OBJ_ALL_PERIODS);
  ObjectSet("TL1H",OBJPROP_TIMEFRAMES,OBJ_ALL_PERIODS);
  ObjectSet("TL2H",OBJPROP_TIMEFRAMES,OBJ_ALL_PERIODS);
  return(true);
}

//**********************************
int objekty_nastav123L(int ai) {
  ObjectMove("TL1L",0,Time[Pole_poz[ai+2]],Pole_hod[ai+2]); ObjectMove("TL1L",1,Time[Pole_poz[ai]],Pole_hod[ai]);
  if(Pole_hod[ai] > Bid) return(false); 
  ObjectMove("TL2L",0,Time[Pole_poz[ai]],Pole_hod[ai]); ObjectMove("TL2L",1,Time[Pole_poz[ai]-2],Low[Pole_poz[ai]-2]);
  ObjectMove("MyFibo",0,Time[Pole_poz[ai+1]],Pole_hod[ai+1]); ObjectMove("MyFibo",1,Time[Pole_poz[ai+2]],Pole_hod[ai+2]);
   ObjectSet("MyFibo",OBJPROP_COLOR,COLOR_B);
   ObjectSet("MyFibo",OBJPROP_LEVELCOLOR,COLOR_B);
  //zobrazit objekty
  ObjectSet("MyFibo",OBJPROP_TIMEFRAMES,OBJ_ALL_PERIODS);
  ObjectSet("TL1L",OBJPROP_TIMEFRAMES,OBJ_ALL_PERIODS);
  ObjectSet("TL2L",OBJPROP_TIMEFRAMES,OBJ_ALL_PERIODS);
  return(true);
}

