
//+------------------------------------------------------------------+
//|                                                KI_signals_v2.mq4 |
//|                                                          Kalenzo |
//|                                      bartlomiej.gorski@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Kalenzo"
#property link      "bartlomiej.gorski@gmail.com"

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 SteelBlue
#property indicator_color2 Magenta
#property indicator_color3 DodgerBlue
#property indicator_color4 Magenta

extern int Length1 = 3;
extern int Length2 = 10;
extern int Length3 = 16;
extern double NeutralZone = 2;

double Histo[];
 

double up[];
double dn[]; 

double upMode[];
double dnMode[];

int alertBar;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- additional buffers are used for counting
   IndicatorBuffers(6);

   SetIndexStyle(0,DRAW_ARROW,EMPTY,0);
   SetIndexStyle(1,DRAW_ARROW,EMPTY,0);

   SetIndexStyle(2,DRAW_HISTOGRAM,EMPTY,1);
   SetIndexStyle(3,DRAW_HISTOGRAM,EMPTY,1);
   
   SetIndexArrow(0,233);
   SetIndexArrow(1,234);

   IndicatorDigits(6);
   
   SetIndexBuffer(0,up);
   SetIndexBuffer(1,dn);

   SetIndexBuffer(2,upMode);
   SetIndexBuffer(3,dnMode);
   
   SetIndexBuffer(4,Histo);
 
   
   IndicatorShortName("KI signals v3");
   
   SetIndexLabel(0,"UP SIGNAL");
   SetIndexLabel(1,"DN SIGNAL");
   
   return(0);
  }
//+------------------------------------------------------------------+
//| SignalIndicator                                                  |
//+------------------------------------------------------------------+
int start()
  {
   int limit;
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) counted_bars=0;
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
//----

  
     
   for(int i = 0 ;i <= limit ;i++)Histo[i] = iMA(Symbol(),0,Length1,0,MODE_EMA,PRICE_CLOSE,i) - iMA(Symbol(),0,Length2,0,MODE_EMA,PRICE_CLOSE,i);      
   
   for(int m = 0 ;m <= limit ;m++)
   {
      if(Histo[m+2] < (NeutralZone*Point) && Histo[m+1] >= (NeutralZone*Point) && Histo[m]>=(NeutralZone*Point))
      {
         up[m] = Open[m]-(5*Point);
         
         if(Bars > alertBar && m == 0)
         {
            Alert(Symbol()+" "+Period()+" KI LONG ",Ask);  
            alertBar = Bars;
         }
      }
      
      if(Histo[m+2] > (-NeutralZone*Point) && Histo[m+1] <= (-NeutralZone*Point) && Histo[m]<= (-NeutralZone*Point))
      {
         dn[m] = Open[m]+(5*Point);
         
         if(Bars > alertBar && m == 0)
         {
            Alert(Symbol()+" "+Period()+" KI SHORT ",Bid);  
            alertBar = Bars;
         }
      }
      
      
   }
//----
 return(0);
  }
//+------------------------------------------------------------------+