//+------------------------------------------------------------------+
//|                Kairi.mq4                                         |
//|                Copyright  2006  Scorpion@fxfisherman.com        |
//+------------------------------------------------------------------+
#property copyright "FxFisherman.com"
#property link      "http://www.fxfisherman.com"

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 Aqua

extern int MA_Period=10;
extern int Shift_Bars=0;
extern int Bars_Count= 1000;

//---- buffers
double v1[];
double val1;
  
int init()
  {

   IndicatorBuffers(1);
  
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,1);
   SetIndexDrawBegin(0,-1);
   SetIndexBuffer(0, v1);
   SetIndexLabel(0,"Kairi");
   
   watermark();
 
   return(0);
  }

int start()
 {
  int i;
  int shift; 
  double sma;
  int counted_bars = IndicatorCounted();
  if (counted_bars > 0) counted_bars--;
  if (Bars_Count > 0 && Bars_Count <= Bars)
  {
    i = Bars_Count - counted_bars;
  }else{
    i = Bars - counted_bars;
  }
  
  while(i>=0)
   {
    shift = i + Shift_Bars;
    sma = iMA(NULL, 0, MA_Period, Shift_Bars, MODE_SMA, PRICE_CLOSE, i);
    if (sma>0)
    {
      v1[i] = ((Close[shift]-sma)/sma) * 100;
    }
    i--;
   }   
  return(0);
 }
 
//+------------------------------------------------------------------+

void watermark()
  {
   ObjectCreate("fxfisherman", OBJ_LABEL, 0, 0, 0);
   ObjectSetText("fxfisherman", "fxfisherman.com", 11, "Lucida Handwriting", RoyalBlue);
   ObjectSet("fxfisherman", OBJPROP_CORNER, 2);
   ObjectSet("fxfisherman", OBJPROP_XDISTANCE, 5);
   ObjectSet("fxfisherman", OBJPROP_YDISTANCE, 10);
   return(0);
  }