//+------------------------------------------------------------------+

#property indicator_chart_window
#property indicator_buffers 1
#property indicator_color1 Black
#property indicator_width1 2

extern int periodAMA=9;
extern int nfast=2;
extern int nslow=30;
extern int G=2;
extern int Price=0;
extern bool Noise_Price = false;
extern int NBars = 1000;
extern int SmoothMA_Type = -1;
extern int SmoothMA_Period = 4;

double kAMAbuffer[];
int pos=0, pos2=0, i=0;
double AMA0 = 0, curPrice = 0, wlxSSC = 0, noise = 0, signal = 0, bars = 0;

int    counted = 0;
double slowSC,fastSC;


int init()
{
  SetIndexStyle(0, DRAW_LINE);
  if(SmoothMA_Type >= 0) SetIndexDrawBegin(0, 70);
  SetIndexBuffer(0, kAMAbuffer);
  IndicatorDigits(6);
  
  slowSC = (2.0 /(nslow+1));
  fastSC = (2.0 /(nfast+1));

  return(0);
}

int deinit()
  {
   return(0);
  }



int start()
{ 
  counted = IndicatorCounted();
  if(counted < 0) return(-1);
  if(Bars < 230+periodAMA) return(0);
  pos = MathMin(MathMax(NBars-periodAMA-2, 230), Bars-periodAMA-2) - counted;
  if(pos < 230) pos = 230;
  pos2 = pos;
  AMA0 = price(Price, pos+1);
  
  
  while (pos>=0)
  {
    curPrice = price(Price, pos);
    if(pos == Bars-periodAMA-2) AMA0 = price(Price, pos+1);
    signal = MathAbs(curPrice - price(Price, pos+periodAMA));
    noise=0;
    
    for(i=0; i<periodAMA; i++)
      noise = noise + MathAbs(price(Price, pos+i) - price(Price, pos+i+1));
    if(Noise_Price) noise *= Close[pos];
      
    wlxSSC = (signal / noise) * (fastSC - slowSC)  + slowSC;
    i = 1;
    while(i < G){ wlxSSC *= wlxSSC; i++; }
    
    kAMAbuffer[pos] = wlxSSC * (curPrice-AMA0) + AMA0;     
    AMA0 = kAMAbuffer[pos];
    pos--;
  }

  
  pos = 0;
  if(SmoothMA_Type >= 0){
    while(pos <= pos2){
      kAMAbuffer[pos] = iMAOnArray(kAMAbuffer, 0, SmoothMA_Period, 0, SmoothMA_Type, pos);
      pos++;
    }
  }
  
  return(0);
}


double price(int type, int shift){
  if(type == 5) return((High[shift]+Low[shift]+Close[shift])/3);
  else if(type == 1) return(Open[shift]);
  else if(type == 2) return(High[shift]);
  else if(type == 3) return(Low[shift]);
  else if(type == 4) return((High[shift]+Low[shift])/2);  
  else if(type == 6) return((High[shift]+Low[shift]+Close[shift]+Close[shift])/4);
  return(Close[shift]);
}