//+------------------------------------------------------------------+
//|                KeyReversal_KRV.mq4                               |
//|                Copyright  2006  Scorpion@fxfisherman.com        |
//+------------------------------------------------------------------+
#property copyright "FxFisherman.com"
#property link      "http://www.fxfisherman.com"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Blue
#property indicator_color2 White

extern int Shift_Bars=0;
extern int Bars_Count= 1000;

//---- buffers
double v1[];
double v2[];
  
int init()
  {

   IndicatorBuffers(2);
   SetIndexArrow(0,217);
   SetIndexStyle(0,DRAW_ARROW,STYLE_SOLID,1);
   SetIndexDrawBegin(0,-1);
   SetIndexBuffer(0, v1);
   SetIndexLabel(0,"KRV_Buy");
   
   SetIndexArrow(1,218);
   SetIndexStyle(1,DRAW_ARROW,STYLE_SOLID,1);
   SetIndexDrawBegin(1,-1);
   SetIndexBuffer(1, v2);
   SetIndexLabel(1,"KRV_Sell");
   
   watermark();
 
   return(0);
  }

int start()
 {
  int i;
  int shift;
  bool uptrend, downtrend;
  int counted_bars = IndicatorCounted();
  if (counted_bars > 0) counted_bars--;
  if (Bars_Count > 0 && Bars_Count <= Bars)
  {
    i = Bars_Count - counted_bars;
  }else{
    i = Bars - counted_bars;
  }
  
  while(i>=0)
   {
    shift = i + Shift_Bars;
    uptrend = High[shift] > High[shift+1] && Low[shift] > Low[shift+1] && 
              Close[shift] > Close[shift+1];
    downtrend = High[shift] < High[shift+1] && Low[shift] < Low[shift+1] &&
              Close[shift] < Close[shift+1];
    if (uptrend) {
      v2[i] = Close[shift];
    }else if(downtrend){
      v1[i] = Close[shift];
    }
    
    i--;
   }   
  return(0);
 }
 
//+------------------------------------------------------------------+

void watermark()
  {
   ObjectCreate("fxfisherman", OBJ_LABEL, 0, 0, 0);
   ObjectSetText("fxfisherman", "fxfisherman.com", 11, "Lucida Handwriting", RoyalBlue);
   ObjectSet("fxfisherman", OBJPROP_CORNER, 2);
   ObjectSet("fxfisherman", OBJPROP_XDISTANCE, 5);
   ObjectSet("fxfisherman", OBJPROP_YDISTANCE, 10);
   return(0);
  }