
//+------------------------------------------------------------------+
//|                                                           KI.mq4 |
//|                                                          Kalenzo |
//|                                      bartlomiej.gorski@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Kalenzo"
#property link      "bartlomiej.gorski@gmail.com"

#property indicator_separate_window
#property indicator_buffers 4
#property indicator_color1 SteelBlue
#property indicator_color2 Orange
#property indicator_color3 DodgerBlue
#property indicator_color4 Magenta

#property indicator_level1 0

extern int Length1 = 3;
extern int Length2 = 10;
extern int Length3 = 16;
 

double Histo[];
double MaHisto[];

double up[];
double dn[]; 
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- additional buffers are used for counting
   IndicatorBuffers(4);

   SetIndexStyle(0,DRAW_HISTOGRAM,EMPTY,1);
   SetIndexStyle(1,DRAW_LINE,STYLE_DOT,1);
   SetIndexStyle(2,DRAW_ARROW,EMPTY,0);
   SetIndexStyle(3,DRAW_ARROW,EMPTY,0);
   
   SetIndexArrow(2,108);
   SetIndexArrow(3,108);
   
   IndicatorDigits(6);

   SetIndexBuffer(0,Histo);
   SetIndexBuffer(1,MaHisto);
   SetIndexBuffer(2,up);
   SetIndexBuffer(3,dn);

   IndicatorShortName("KI");
   
   SetIndexLabel(0,"3/10 Diffrence");
   SetIndexLabel(1,"Moving Average of Diffrence");
   SetIndexLabel(2,"UP SIGNAL");
   SetIndexLabel(3,"DN SIGNAL");
   
   
   
   return(0);
  }
//+------------------------------------------------------------------+
//| SignalIndicator                                                  |
//+------------------------------------------------------------------+
int start()
  {
   int limit;
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) counted_bars=0;
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
//----
      
   for(int i = 0 ;i <= limit ;i++)Histo[i] = iMA(Symbol(),0,Length1,0,MODE_EMA,PRICE_CLOSE,i) - iMA(Symbol(),0,Length2,0,MODE_EMA,PRICE_CLOSE,i);      
   
   for(int j = 0 ;j <= limit ;j++)MaHisto[j] = iMAOnArray(Histo,0,Length3,0,MODE_EMA,j);
   
   for(int m = 0 ;m <= limit ;m++)
   {
      if(MaHisto[m+1] <= 0 && MaHisto[m]>0)
      {
         up[m] = 0;
      }
      
      if(MaHisto[m+1] >= 0 && MaHisto[m]<0)
      {
         dn[m] = 0;
      }
   }
//----
 return(0);
  }
//+------------------------------------------------------------------+