//+------------------------------------------------------------------+
//|                                              LCD BUYSELL.mq4 |
//|                                                   |
//|                                     |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, MetaQuotes Software Corp."
#property link "http://www.stealthforex.com"

#property indicator_separate_window
#property indicator_buffers 4
#property indicator_color1 Yellow
#property indicator_color2 Blue
#property indicator_color3 Black
#property indicator_color4 Black

//------- External parameters ------------------------------------------

extern int EMAPeriod = 34; //Period EMA
extern int LSMAPeriod = 25; // Period LSMA
extern int FromZero = 3; // Distance from the zero level

//------- Buffers of the indicator ------------------------------------------

double gda_88[];
double gda_92[];
double gda_96[];
double gda_100[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function |
//+------------------------------------------------------------------+
void init() {
  IndicatorDigits(2);
  SetIndexBuffer(0, gda_88);
  SetIndexLabel(0, "EMA higher than price");
  SetIndexStyle(0, DRAW_LINE, STYLE_SOLID, 5);
  SetIndexBuffer(1, gda_92);
  SetIndexLabel(1, "EMA lower than price");
  SetIndexStyle(1, DRAW_LINE, STYLE_SOLID, 5);
  SetIndexBuffer(2, gda_96);
  SetIndexLabel(2, "LSMA higher than price");
  SetIndexStyle(2, DRAW_LINE, STYLE_SOLID, 1);
  SetIndexBuffer(3, gda_100);
  SetIndexLabel(3, "LSMA lower than price");
  SetIndexStyle(3, DRAW_LINE, STYLE_SOLID, 1);
  Comment("Special Projects and Defence Limited");
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function |
//+------------------------------------------------------------------+
int start() {
  double ld_0;
  double ld_8;
  double ld_16;
  double ld_24;
  double l_ima_52;
  int li_40 = IndicatorCounted();
  if (li_40 < 0) return;
  if (li_40 > 0) li_40--;
  li_40 = Bars - li_40;
  for (int li_36 = 0; li_36 < li_40; li_36++) {
    gda_92[li_36] = -FromZero;
    gda_88[li_36] = -FromZero;
    l_ima_52 = iMA(NULL, 0, EMAPeriod, 0, MODE_EMA, PRICE_TYPICAL, li_36);
    if (Close[li_36] > l_ima_52) gda_88[li_36] = 2147483647;
    if (Close[li_36] < l_ima_52) gda_92[li_36] = 2147483647;
  }
  int li_44 = Bars - LSMAPeriod - 5;
  int li_48 = li_44 - LSMAPeriod - 1;
  for (li_36 = li_48; li_36 >= 0; li_36--) {
    ld_0 = 0;
    for (int li_32 = LSMAPeriod; li_32 >= 1; li_32--) {
      ld_8 = LSMAPeriod + 1;
      ld_8 /= 3.0;
      ld_16 = 0;
      ld_16 = (li_32 - ld_8) * (Close[LSMAPeriod - li_32 + li_36]);
      ld_0 += ld_16;
    }
    ld_24 = 6.0 * ld_0 / (LSMAPeriod * (LSMAPeriod + 1));
    //+------------------------------------------------------------------+

    gda_96[li_36] = FromZero;
    gda_100[li_36] = FromZero;
    if (ld_24 > Close[li_36]) gda_100[li_36] = 2147483647;
    if (ld_24 < Close[li_36]) gda_96[li_36] = 2147483647;
  }
  return (0);
}