
#property copyright "Copyright  2005, Live Charts"
#property link      "http://www.livecharts.co.uk"

#property indicator_chart_window
#property indicator_buffers 7
#property indicator_color1 Red
#property indicator_color2 OrangeRed
#property indicator_color3 Yellow
#property indicator_color4 Aqua
#property indicator_color5 Yellow
#property indicator_color6 OrangeRed
#property indicator_color7 Red



extern bool S1_R1 = true;
extern bool S2_R2 = true;
extern bool S3_R3 = true;



bool sr[3];

int lastShift = -1;
double PP, S[4], R[4];

double PP_Buffer[];

double S1_Buffer[];
double S2_Buffer[];
double S3_Buffer[];

double R1_Buffer[];
double R2_Buffer[];
double R3_Buffer[];



int init()
{
   
   int i;

   IndicatorShortName("Fibonacci Daily");

   IndicatorDigits(MarketInfo(Symbol(), MODE_DIGITS));


   sr[0] = S1_R1;
   sr[1] = S2_R2;
   sr[2] = S3_R3;
   
   for(i=0; i<3; i++)
   {
      int style;
      
      if(sr[i]==true) 
         style = DRAW_LINE;
      else   
         style = DRAW_NONE;
      
      SetIndexStyle(2-i, style);
      SetIndexStyle(i+4, style);
   }
   
            
   SetIndexBuffer(0, S3_Buffer);
   SetIndexBuffer(1, S2_Buffer);
   SetIndexBuffer(2, S1_Buffer);
   SetIndexBuffer(3, PP_Buffer);
   SetIndexBuffer(4, R1_Buffer);
   SetIndexBuffer(5, R2_Buffer);
   SetIndexBuffer(6, R3_Buffer);
   
      
   string indexLabels[] = {"S3", "S2", "S1", "Pivot", "R1", "R2", "R3"};
   
   for(i=0; i<7; i++)
   {
      SetIndexLabel(i, indexLabels[i]);
   }
   
}



int deinit()
{

}



int start()
{

   int counted_bars = IndicatorCounted();    
   int nBars = (Bars - counted_bars) - 1;
   
   
   for(int i=0; i<nBars; i++)
   {
      int shift = iBarShift(NULL, PERIOD_D1, Time[i]) + 1;

      
      if(shift!=lastShift)
      {
         lastShift = shift;
         
         double H = iHigh(NULL, PERIOD_D1, shift);
         double L = iLow(NULL, PERIOD_D1, shift);
         double C = iClose(NULL, PERIOD_D1, shift);
      
         GetFibonacciLevels(H, L, C, PP, S, R);      
      }
      
      
      PP_Buffer[i] = PP;

      S1_Buffer[i] = S[0];
      S2_Buffer[i] = S[1];
      S3_Buffer[i] = S[2];

      R1_Buffer[i] = R[0];
      R2_Buffer[i] = R[1];
      R3_Buffer[i] = R[2];   
   }
      
}



void GetFibonacciLevels(double H, double L, double C, double& PP, double& S[], double& R[])
{

   double k[3];
   
   k[0] = 0.382;
   k[1] = 0.618;
   k[2] = 1.000;
   
   double range = H - L;
   
   PP = (H + L + C)/3;
   
   for(int i=0; i<3; i++)
   {
      S[i] = PP - range*k[i];
      R[i] = PP + range*k[i];
   }

}

