#include <stdlib.mqh>
//+------------------------------------------------------------------+
//|                                       Linear_Jose_Regression.mq4 |
//|                            Copyright  2006, crux.crux@gmail.com |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+

#property copyright " Copyright  2006, crux.crux@gmail.com"
#property link      " http://indofx-trader.com"

#property indicator_chart_window
#property indicator_color1 Red
#property indicator_buffers 1

//+------------------------------------------------------------------+
//| Common External variables                                        |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| External variables                                               |
//+------------------------------------------------------------------+
extern int Rperiod = 10;

//+------------------------------------------------------------------+
//| Special Convertion Functions                                     |
//+------------------------------------------------------------------+

int LastTradeTime;
double ExtHistoBuffer[];

void SetLoopCount(int loops)
{
}

void SetIndexValue(int shift, double value)
{
  ExtHistoBuffer[shift] = value;
}

//+------------------------------------------------------------------+
//| End                                                              |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Initialization                                                   |
//+------------------------------------------------------------------+

int init()
{
   SetIndexStyle(0, DRAW_LINE, STYLE_SOLID);
   SetIndexBuffer(0, ExtHistoBuffer);
   return(0);
}
int start()
{
//+------------------------------------------------------------------+
//| Local variables                                                  |
//+------------------------------------------------------------------+
int shift = 0;
double loopbegin = 0;
double total = 0;
double length = 0;
int i = 0;
int lg = 0;
double WT = 0;
int    counted_bars=IndicatorCounted();
int  limit;

/*[[
Name := Linear_Jose_Regression.mq4
Author := Copyright  2006, crux.crux@gmail.com
Link := http://indofx-trader.com
Separate Window := No
First Color := Red
First Draw Type := Line
Use Second Data := No
]]*/
//---- check for possible errors
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;

limit=Bars-counted_bars;

SetLoopCount(0);
// initial checkings
if( Rperiod < 1 ) return(0);
length=Rperiod;
lg=Rperiod;
loopbegin = limit-length-1;
for(shift =loopbegin;shift >=0 ;shift --){ 
total=0;
for(i =length;i >=1 ;i --){ 
total = total + (i-(length+1)/3)*Close[lg-i+shift];
} 
WT=total*6/(length*(length+1));
SetIndexValue(shift,WT);
}   return(0);
}