//+------------------------------------------------------------------+
//|                                                  Custom MACD.mq4 |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property  copyright "Copyright  2004, MetaQuotes Software Corp."
#property  link      "http://www.metaquotes.net/"

//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 2
#property  indicator_color1  ForestGreen
#property  indicator_color2  Red
//---- indicator parameters
extern int FastEMA=5;
extern int SlowEMA=34;
//---- indicator buffers
double green_buffer[];
double red_buffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- drawing settings
   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,2);
   SetIndexBuffer(0,green_buffer);
//----
   SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID,2);
   SetIndexBuffer(1,red_buffer);
//----
   IndicatorDigits(Digits+1);
//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("MACD("+FastEMA+","+SlowEMA+")");
   SetIndexLabel(0,"MACD");
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Moving Averages Convergence/Divergence                           |
//+------------------------------------------------------------------+
int start()
  {
   double MACD;
   int counted_bars=IndicatorCounted();
   int i;
//---- check for possible errors
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   for (i = Bars - Max (counted_bars-1, 1); i>=0; i--) {
      MACD=iMA(NULL,0,FastEMA,0,MODE_EMA,PRICE_MEDIAN,i)-
           iMA(NULL,0,SlowEMA,0,MODE_EMA,PRICE_MEDIAN,i);
      if ( ( (green_buffer[i+1] != 0) && (MACD >= green_buffer[i+1]) ) ||
           ( (red_buffer[i+1] != 0) && (MACD > red_buffer[i+1]) ) ) {
        green_buffer[i] = MACD;
        red_buffer[i] = 0;
      }
      else {
        green_buffer[i] = 0;
        red_buffer[i] = MACD;
      }
   }
//---- done
   return(0);
  }

//+------------------------------------------------------------------+
int Max (int val1, int val2) {
  if (val1 > val2)  return(val1);
  return(val2);
}

