//+------------------------------------------------------------------+
//|                                            MACD_OsMA_ColorLH.mq4 |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//| mod. Variable MA settings             http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
// 2008forextsd mtf keris f-la  ki
#property  copyright "Copyright  2004, MetaQuotes Software Corp."
#property  link      "http://www.metaquotes.net/"

//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 6
#property  indicator_color1  LimeGreen
#property  indicator_color2  Red
#property  indicator_color3  C'83,0,0' //Maroon
#property  indicator_color4  C'0,66,0' //DarkGreen
#property  indicator_color5  DodgerBlue
#property  indicator_color6  Chocolate 

#property  indicator_width1  2
#property  indicator_width2  2
#property  indicator_width3  2
#property  indicator_width4  2
#property  indicator_width5  1
#property  indicator_width6  1

//---- indicator buffers

extern int TimeFrame = 0;
extern int FastMA_Period=12;
extern int SlowMA_Period=26;
extern int SignalMA_Period=9;

extern int FastMA_Mode=1;
extern int SlowMA_Mode=1;
extern int SignalMA_Mode=0;

extern int FastMA_Price=0;
extern int SlowMA_Price=0;
//extern int SignalMA_Price=0;   // ma on array - price Close only
extern   double    OsmaMultiplier  = 1.8;
extern bool ShowOsMA_Histo = true;
extern bool ShowMACD_Histo = false;
extern int MaxBarsToCount   = 1500;

extern string  note_TimeFrames = "M1;5,15,30,60H1;240H4;1440D1;10080W1;43200MN|0-CurrentTF";
extern string  note_AppliedPrice = "0C,1O 2H3L,4Md 5Tp 6WghC: Md(HL/2)4,Tp(HLC/3)5,Wgh(HLCC/4)6";
extern string  note_MA_Mode =  "SMA0 EMA1 SMMA2 LWMA3";
extern string  note_defaults = "AO:34,5;SMA;PriceMedian(4);MACD 12 26 9 EMA Close;SignalLinePrice- Close only(MaOnArray) ";


double     ind_buffer1[], ind_buffer1s[];
double     ind_buffer2[], ind_buffer2s[];
double     ind_buffer3[];
double     ind_buffer4[];
double     ind_buffer5[];
double     ind_buffer6[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//----  additional buffer used for counting.
   IndicatorBuffers(8);
   //---- drawing settings
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexStyle(2,DRAW_HISTOGRAM);
   SetIndexStyle(3,DRAW_HISTOGRAM);   
  
   SetIndexStyle(4,DRAW_LINE);
   SetIndexStyle(5,DRAW_LINE);   
   
   IndicatorDigits(Digits+2);
   
   SetIndexDrawBegin(0,SlowMA_Period);
   SetIndexDrawBegin(1,SlowMA_Period);
   SetIndexDrawBegin(2,SlowMA_Period);
   SetIndexDrawBegin(3,SlowMA_Period);

   SetIndexDrawBegin(4,SlowMA_Period);
   SetIndexDrawBegin(5,SlowMA_Period);

//---- indicator buffers mapping
  SetIndexBuffer(0,ind_buffer1)  ;

//---- indicator buffers mapping
   if(!SetIndexBuffer(0,ind_buffer1)  &&
      !SetIndexBuffer(1,ind_buffer1s) &&
      !SetIndexBuffer(2,ind_buffer2)  &&
      !SetIndexBuffer(3,ind_buffer2s) &&
      !SetIndexBuffer(4,ind_buffer3)  &&
      !SetIndexBuffer(5,ind_buffer4)  &&
      !SetIndexBuffer(6,ind_buffer5)  &&
      !SetIndexBuffer(7,ind_buffer6))
      Print("cannot set indicator buffers!");


           switch(TimeFrame)
   {
      case 1: string TimeFrameStr = "M1";  break;
      case 5     :   TimeFrameStr = "M5";  break;
      case 15    :   TimeFrameStr = "M15"; break;
      case 30    :   TimeFrameStr = "M30"; break;
      case 60    :   TimeFrameStr = "H1";  break;
      case 240   :   TimeFrameStr = "H4";  break;
      case 1440  :   TimeFrameStr = "D1";  break;
      case 10080 :   TimeFrameStr = "W1";  break;
      case 43200 :   TimeFrameStr = "MN1"; break;
      default :    TimeFrameStr   = "CurrTF";
   }

//---- name for DataWindow and indicator subwindow label

   SetIndexLabel(0,"");
   SetIndexLabel(1,"");
   SetIndexLabel(2,"");
   SetIndexLabel(3,"");
   SetIndexLabel(4,"MACD");
   SetIndexLabel(5,"SigL");

   IndicatorShortName("MACD_OsMA ["+TimeFrameStr+"] ("+FastMA_Period+","+SlowMA_Period+","+SignalMA_Period+")");
   if (TimeFrame < Period()) TimeFrame = Period();


//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Awesome Oscillator                                               |
//+------------------------------------------------------------------+
int start()
 {
   double prev,current;
   datetime TimeArray[],TimeArray1[];
   int    i,limit,y=0,counted_bars=IndicatorCounted();
//---- last counted bar will be recounted
   ArrayCopySeries(TimeArray,  MODE_TIME,Symbol(),TimeFrame); 
   ArrayCopySeries(TimeArray1, MODE_TIME,Symbol(),TimeFrame); 

   if(counted_bars>0) counted_bars--;
    limit= Bars-counted_bars;
    limit= MathMax(limit,TimeFrame/Period());
    limit= MathMin(limit,MaxBarsToCount);


  for(i=0,y=0; i<limit; i++)
     {

     if (Time[i]<TimeArray[y]) y++;
     ind_buffer3[i]=iMA(NULL,TimeFrame,FastMA_Period,0,FastMA_Mode,FastMA_Price,y)-
                    iMA(NULL,TimeFrame,SlowMA_Period,0,SlowMA_Mode,SlowMA_Price,y);
   
      ind_buffer5[y]= ind_buffer3[i];
     }
   
   limit = MathMin(limit, MaxBarsToCount-SignalMA_Period); 
   for(y=0,i=0; i<limit; i++)
        {
     if (Time[i]<TimeArray1[y]) y++;

      ind_buffer4[i]=iMAOnArray(ind_buffer5,0,SignalMA_Period,0,SignalMA_Mode,y);
    
      ind_buffer6[i]= (ind_buffer3[i]- ind_buffer4[i])*OsmaMultiplier;
        } 

//---- dispatch values between 2 buffers
  bool up=true;
 
    for (i=limit;i>=0;i--)
  
   {

            ind_buffer1[i] =0.0;
            ind_buffer1s[i]=0.0;             
            ind_buffer2[i] =0.0;
            ind_buffer2s[i]=0.0;

    if (ShowOsMA_Histo)
      {
      current=ind_buffer6[i];
      prev=ind_buffer6[i+1];
      }
   if (ShowMACD_Histo)
      {
      current=ind_buffer3[i];
      prev=ind_buffer3[i+1];
      }

      
      if(current>prev) up=true;
      if(current<prev) up=false;
      
      if(up)
        {
         if(current > 0)
            {
            ind_buffer1[i]=current;
            ind_buffer1s[i]=0.0;             
            ind_buffer2[i] =0.0;
            ind_buffer2s[i]=0.0;
            }        
            else
            {
            ind_buffer1[i] =0.0;
            ind_buffer1s[i]=current;           
            ind_buffer2[i] =0.0; 
            ind_buffer2s[i]=0.0;
            }             
         }
        else
         {
         if(current < 0)
           {
            ind_buffer1[i] =0.0;
            ind_buffer1s[i]=0.0;
            ind_buffer2[i] =current;
            ind_buffer2s[i]=0.0;
           }
        else
           {
            ind_buffer1[i] =0.0;
            ind_buffer1s[i]=0.0;
            ind_buffer2[i] =0.0;
            ind_buffer2s[i]=current;
            }           
         }       
    }  


   for (i=0;i<indicator_buffers;i++) SetIndexDrawBegin(i,Bars-MaxBarsToCount+SignalMA_Period);    


//---- done
   return(0);
 }

