//+------------------------------------------------------------------+
//|                                                         TSCD.mq4 |
//|                                         Copyright  2007 Mulyadi |
//| Time Series Convergen Divergen                                   |
//| indi ini menunjukkan  Conv.Div. dari 2 TSF                       |
//| Enter price , diatur oleh BarS & BarC                            |
//| BarS : jumlah total seleksi Bars                                 |
//| BarC : Bar patokan harga                                         |
//| Test aja supaya mengerti                                         |
//| Test it, you'll love it
//+------------------------------------------------------------------+
#property copyright "Copyright  2007 Mulyadi Santoso"
#property link      "musanto@yahoo.com"
#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1 Red
#property indicator_width1 2
#property indicator_color2 Yellow
#property indicator_width2 1
#property indicator_color3 Brown
#property indicator_width3 1
#define MaxMarkHL 50

//---- input parameters
extern   int        TSFfast      =  20;
extern   int        TSFslow      =  220;
extern   int        TSFma1       =  5;
extern   int        maxbar       =  300;
extern   bool       MarkEnable   = true; 
extern   int        BarS         =  4;
extern   int        BarC         =  50;
//---- buffers
double CdBuffer[];
double MaBuffer[];
double DCdMaBuffer[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
bool     awal,FlagMaxMarkHL;
double   sigma;
double   MarkHL;
datetime     lastHi,lastLo;

int init()
  {
//---- indicators
//   SetIndexStyle(0,DRAW_HISTOGRAM);
  SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2,CdBuffer);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,MaBuffer);
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(0,DCdMaBuffer);
   IndicatorShortName("TSCDos");
   SetIndexLabel(0,"TSCD");   
   SetIndexLabel(1,"MA");   
    SetIndexLabel(2,"Delta");   
   awal=true;FlagMaxMarkHL=false;
   MarkHL = 0;lastLo=0;lastHi=0;
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {   string st;
//----
   if (FlagMaxMarkHL) MarkHL=MaxMarkHL;
   for (int i=MarkHL;i>=0;i--)
   {
      st = "Mark"+StringTrimRight(DoubleToStr(i,0));
      ObjectDelete(st);
   }   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   int      counted_bars=IndicatorCounted();
   int      limit,i;

//----
   
   
   if (awal) 
   {  
      limit = maxbar ;
   } else
      limit = Bars - counted_bars;
   
   for (i=limit;i>=0;i--)
   {  
      CdBuffer[i] = Lreg(i,i+TSFfast-1)-Lreg(i,i+TSFslow-1);
      if (awal && limit-i <TSFma1) 
      {
         MaBuffer[i]=EMPTY_VALUE;  
      }
      else 
      {  MaBuffer[i] = iMAOnArray(CdBuffer,0,TSFma1,i,MODE_SMA,0);
         if (  CdBuffer[i]>0.0 
            && MarkEnable
            && MaBuffer[i]>CdBuffer[i]
            && MaBuffer[i+1]<=CdBuffer[i+1]
            && High[iHighest(NULL,0,MODE_HIGH,BarS,i)]> High[iHighest(NULL,0,MODE_HIGH,BarC,i+BarS)]
            && Time[i] > lastHi+60*60
            )
            {
               MarkHi(i);
               lastHi = Time[i];
            }
         if (  CdBuffer[i]<0.0 && MaBuffer[i]<CdBuffer[i]
            && MarkEnable
            && MaBuffer[i+1]>=CdBuffer[i+1]
            && Low[iLowest(NULL,0,MODE_LOW,BarS,i)]<=Low[iLowest(NULL,0,MODE_LOW,BarC,i+BarS)]
            && Time[i]>lastLo+60*60
            )
            {
               MarkLo(i);
               lastLo = Time[i];
            }
      }     
  //    for (i=limit;i>=0;i--)
        DCdMaBuffer[i]= (CdBuffer[i]-MaBuffer[i])*3;
    }
   awal=false;
   
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
double Lreg(int st0, int st1)
{ double    Sx=0,Sxx=0,Sxy=0,Sy;
  double    Beta,Alfa,x,y,c,rv;
  int       i,n;

  rv = 0.0;
  n = st1 - st0 + 1 ;                       //int n=m_pos[1]-m_pos[0]+1;
  Sy  = (iOpen(NULL,0,st0)+iHigh(NULL,0,st0)+iLow(NULL,0,st0)+
            iClose(NULL,0,st0))/4;          //double sumy=value;
  //Sy  = iClose(NULL,0,st0);          //double sumy=value;
  
  Sx  = 0.0;                                // double sumx=0.0;
  Sxy = 0.0;                                // double sumxy=0.0;
  Sxx = 0.0;                                // double sumx2=0.0;
  for (i=1;i<n;i++)                         //for(i=1; i<n; i++)
  {  
     x   = i;   
     y   = (iOpen(NULL,0,st0+i)+iHigh(NULL,0,st0+i)+iLow(NULL,0,st0+i)+
            iClose(NULL,0,st0+i))/4;    //value  = Close[m_pos[0]+i];
     //y  = iClose(NULL,0,st0+i);          //double sumy=value;
     Sx  = Sx + x;                          //sumx+  = i;
     Sy  = Sy + y;                          //sumy+  = value
     Sxx = Sxx + (x* x);                    //sumx2+ = i*i
     Sxy = Sxy + (x* y);                    //sumxy+ = value*i;
  }
  c    = Sxx*n - Sx * Sx;                   //c=sumx2*n-sumx*sumx;
  if (c==0.0) return;                     //if(c==0.0) return;
  Beta = (n*Sxy-Sx*Sy)/c;                   //b=(sumxy*n-sumx*sumy)/c;
  Alfa = (Sy-Beta*Sx)/n;                    //a=(sumy-sumx*b)/n;
  rv = Alfa;       
   return(rv);
}
void  MarkLo(int i)
{  string   st;
   st = "Mark"+StringTrimRight(DoubleToStr(MarkHL,0));MarkHL++;
   if (MarkHL>50) {MarkHL=0;FlagMaxMarkHL=true;}
   ObjectCreate(st,OBJ_ARROW,0,0,0);
   ObjectSet(st,OBJPROP_TIME1,Time[i]);
   ObjectSet(st,OBJPROP_PRICE1,Low[iLowest(NULL,0,MODE_LOW,BarS,i)]);
   ObjectSet(st,OBJPROP_ARROWCODE,241);
   ObjectSet(st,OBJPROP_COLOR,Lime);
}

void  MarkHi(int i)

{  string   st;
   st = "Mark"+StringTrimRight(DoubleToStr(MarkHL,0));MarkHL++;
   if (MarkHL>50) {MarkHL=0;FlagMaxMarkHL=true;}
   ObjectCreate(st,OBJ_ARROW,0,0,0);
   ObjectSet(st,OBJPROP_TIME1,Time[i]);
   ObjectSet(st,OBJPROP_PRICE1,High[iHighest(NULL,0,MODE_HIGH,BarS,i)]+8*Point);
   ObjectSet(st,OBJPROP_ARROWCODE,242);
   ObjectSet(st,OBJPROP_COLOR,BlanchedAlmond);
}


