//+------------------------------------------------------------------+
//|                                                     MAMy v.3.mq4 |
//|                             Copyright  2006, Victor Chebotariov |
//|                                      http://www.chebotariov.com/ 
//  MAO, MAC, MAohlc/4
//|
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Victor Chebotariov"
#property link      "http://www.chebotariov.com/" 
//----
extern int period = 3;
extern int ma_method = 3;
//----
#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 Green
#property indicator_color2 Red
//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorShortName("MAMy3 (" + period + ", " + ma_method + ")");
//---- indicators
   SetIndexStyle(0, DRAW_LINE);
   SetIndexBuffer(0, ExtMapBuffer1);
   SetIndexStyle(1, DRAW_LINE);
   SetIndexBuffer(1, ExtMapBuffer2);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start()
  {
   int i, counted_bars = IndicatorCounted();
//----
   i = Bars - counted_bars - 1;
   while(i >= 0)
     {
       double close     = iMA(NULL, 0, period, 0, ma_method, 0, i);
       double open      = iMA(NULL, 0, period, 0, ma_method, 1, i);
       double weighted  = iMA(NULL, 0, period, 0, ma_method, 6, i);
      
       double close1    = iMA(NULL, 0, period, 0, ma_method, 0, i + 1);
       double open1     = iMA(NULL, 0, period, 0, ma_method, 1, i + 1);
       double weighted1 = iMA(NULL, 0, period, 0, ma_method, 6, i + 1);

       ExtMapBuffer2[i] = (close - weighted)*1000;
       if((close < close1 && weighted < weighted1 && close < weighted && 
          weighted < open && weighted1 < open1 && 
          ExtMapBuffer2[i] <= ExtMapBuffer2[i+1]) || 
          (close > close1 && weighted > weighted1 && 
          close>weighted && weighted > open && weighted1>open1 && 
          ExtMapBuffer2[i] >= ExtMapBuffer2[i+1]))
         {
           ExtMapBuffer1[i] = ((weighted - open) + (close - weighted))*1000;
         }
       else
           ExtMapBuffer1[i] = 0;
       if(ExtMapBuffer1[i] >= 0 && ExtMapBuffer1[i] > ExtMapBuffer1[i+1] && 
          ExtMapBuffer2[i] < 0 && ExtMapBuffer2[i+1] >= 0)
         {
           ExtMapBuffer2[i] = 0;
         }
       else
           ExtMapBuffer2[i] = (close - weighted)*1000;
       i--;
     }
//----
   return(0);
  }
//+------------------------------------------------------------------+