
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 Green
#property indicator_levelcolor Red
#property indicator_levelstyle STYLE_SOLID
#property indicator_level1 5
#property indicator_level2 -5
#property indicator_minimum -50
#property indicator_maximum 50

extern int ShortPeriod=3;
extern int LongPeriod=28;
extern int ShortMode=3;
/*
MODE_SMA 0 Simple moving average, 
MODE_EMA 1 Exponential moving average, 
MODE_SMMA 2 Smoothed moving average, 
MODE_LWMA 3 Linear weighted moving average. 
*/     
extern int ShortPrice=0;
/*
PRICE_CLOSE 0 Close price. 
PRICE_OPEN 1 Open price. 
PRICE_HIGH 2 High price. 
PRICE_LOW 3 Low price. 
PRICE_MEDIAN 4 Median price, (high+low)/2. 
PRICE_TYPICAL 5 Typical price, (high+low+close)/3. 
PRICE_WEIGHTED 6 Weighted close price, (high+low+close+close)/4. 
*/
extern int LongMode=1;
extern int LongPrice=0;

//---- buffers
double IND[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   IndicatorShortName("MASD");
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(0,IND);
//----

   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
     int limit;
     int counted_bars=IndicatorCounted();
     if(counted_bars<0) return(-1);
     if(counted_bars>0) counted_bars-=10;
     limit=Bars-counted_bars;

     for(int i=0; i<limit; i++)
       {
        IND[i]=(iMA(NULL,0,ShortPeriod,0,ShortMode,ShortPrice,i)-iMA(NULL,0,LongPeriod,0,LongMode,LongPrice,i))*1/Point;
       }
  //----
    return(0);
  }
//+------------------------------------------------------------------+