//+------------------------------------------------------------------+
//|                                                    MAofHA_v1.mq4 |
//|                           Copyright  2007, TrendLaboratory Ltd. |
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |
//|                                   E-mail: igorad2003@yahoo.co.uk |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, TrendLaboratory Ltd."
#property link      "http://finance.groups.yahoo.com/group/TrendLaboratory"

#property indicator_chart_window
#property indicator_buffers 1
#property indicator_color1 Yellow
#property indicator_width1 2

//----
extern int Price        =  0;
extern int MA_Period    = 10;
extern int MA_Shift     =  0;
extern int MA_Mode      =  0;

//---- buffers
double haMA[];
double haClose[];
double haOpen[];
double haHigh[];
double haLow[];
double haPrice[];
//----
int ExtCountedBars=0;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//|------------------------------------------------------------------|
int init()
{
//---- indicators
   IndicatorBuffers(6);
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,haMA);
   SetIndexBuffer(1,haClose);
   SetIndexBuffer(2,haOpen);
   SetIndexBuffer(3,haHigh);
   SetIndexBuffer(4,haLow);
   SetIndexBuffer(5,haPrice);
//----
   string short_name="MAofHA("+Price+","+MA_Period+")";
   IndicatorShortName(short_name);
      
   SetIndexDrawBegin(0,MA_Period);
   SetIndexShift(0,MA_Shift);
//---- initialization done
   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
//---- TODO: add your code here
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   int shift, limit, counted_bars=IndicatorCounted();
   
   
   if (Bars-1<MA_Period)return(0);
   if (counted_bars<0)return(-1);
   if (counted_bars>0) counted_bars--;
   
   limit=Bars-counted_bars-1; 
      
   for( shift=limit; shift>=0; shift--)
   {
   haOpen[shift]=(haOpen[shift+1]+haClose[shift+1])/2.0;
   haClose[shift]=(Open[shift]+High[shift]+Low[shift]+Close[shift])/4;
   haHigh[shift]=MathMax(High[shift], MathMax(haOpen[shift], haClose[shift]));
   haLow[shift]=MathMin(Low[shift], MathMin(haOpen[shift], haClose[shift]));
   
      if(Price==0) haPrice[shift] = haClose[shift];
      else
      if(Price==1) haPrice[shift] = haOpen[shift];
      else
      if(Price==2) haPrice[shift] = haHigh[shift];
      else
      if(Price==3) haPrice[shift] = haLow[shift];
      else
      if(Price==4) haPrice[shift] = (haHigh[shift]+haLow[shift])/2;
      else
      if(Price==5) haPrice[shift] = (haHigh[shift]+haLow[shift]+haClose[shift])/3;
      else
      if(Price==6) haPrice[shift] = (haHigh[shift]+haLow[shift]+2*haClose[shift])/4;
      else
      haPrice[shift] = haClose[shift];
   }
   
   for( shift=limit; shift>=0; shift--)
   haMA[shift] = iMAOnArray(haPrice,0,MA_Period,0,MA_Mode,shift); 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+