//+------------------------------------------------------------------+
//|                                                        MP-HB.mq4 |
//|                                                           MojoFX |
//|                                         http://fx.studiomojo.com |
//|                             MojoFX@gmail.com | fx@studiomojo.com |
//|                                            v1.0 - March 27, 2004 |
//+------------------------------------------------------------------+
#property copyright "2005 - MojoFX - Uman Madiprasojo"
#property link      "http://fx.studiomojo.com"

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 Red
#property indicator_color2 GreenYellow
#property indicator_color3 Red
#property indicator_color4 GreenYellow
//---- variables
extern int       viewableBars=300;

double  lastFL,
        lastFH,
        lastHigh,
        highBefore,
        lowBefore,
        lastLow,
        point1,
        point2;

string  lastBroken;
       
int     trend,
        brokenBarH,
        brokenBarL,
        j;       
        
bool    fracLC,fracHC;
bool    expire=false;        

//---- buffers
double  XMB1[],
        XMB2[],
        XMB3[],
        XMB4[];

if ( CurTime()<StrToTime("2006.06.01") &&
   CurTime()>StrToTime("2006.06.15") )
   { 
   expire=true; 
   Comment("\n MojoPivot Package has expired!!!\n Please contact forexhusky@yahoo.com for subscription.");
   return(0);
   }

if (Bars<viewableBars) viewableBars=Bars;

int init()
  {

   SetIndexStyle(0,DRAW_HISTOGRAM,NULL,1);
   SetIndexStyle(1,DRAW_HISTOGRAM,NULL,1);
   SetIndexStyle(2,DRAW_HISTOGRAM,NULL,2);
   SetIndexStyle(3,DRAW_HISTOGRAM,NULL,2);   
   SetIndexBuffer(0,XMB1);
   SetIndexBuffer(1,XMB2);
   SetIndexBuffer(2,XMB3);
   SetIndexBuffer(3,XMB4);
   SetIndexLabel(0,"MP - HookBreak");
   SetIndexLabel(1,"MP - HookBreak");
   SetIndexLabel(2,"MP - HookBreak");   
   SetIndexLabel(3,"MP - HookBreak");

   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));
   IndicatorShortName("MP - HookBreak");

   return(0);
  }

int deinit()
  {

   return(0);
  }

int start()
  {
    int counted_bars=IndicatorCounted();
    if (counted_bars<0) return(-1);
    if (counted_bars>0) counted_bars--;
    //int limit=viewableBars-counted_bars;
    int limit=viewableBars;

    for (int i=limit; i>=0; i--)
        {
        
        if  (expire) 
            {
            ObjectsDeleteAll();
            break; 
            }

        while (fracLC==false)
            {
               j++;
               if (iFractals(NULL,0,MODE_LOWER,i+j) != 0)
                  {
                  lastFL  = iFractals(NULL,0,MODE_LOWER,i+j);
                  lastLow = iFractals(NULL,0,MODE_LOWER,i+j);
                  GlobalVariableSet(Symbol()+"-LFL",lastFL);
                  GlobalVariableSet(Symbol()+"-LL",lastLow);
                  j=0;
                  break;
                  }
            }

        while (fracHC==false)
            {
               j++;
               if (iFractals(NULL,0,MODE_UPPER,i+j) != 0)
                  {
                  lastFH  = iFractals(NULL,0,MODE_UPPER,i+j);
                  lastHigh = iFractals(NULL,0,MODE_UPPER,i+j);
                  GlobalVariableSet(Symbol()+"-LFH",lastFH);
                  GlobalVariableSet(Symbol()+"-LH",lastHigh);                
                  j=0;
                  break;
                  }
            }
        
        if  (High[i] > lastHigh)
            {
            highBefore = lastHigh;
            lastHigh = High[i];
            GlobalVariableSet(Symbol()+"-LH",lastHigh);
            lastBroken = "H";
            brokenBarH = Time[i];
            trend = 1;
            GlobalVariableSet(Symbol()+"-HBT",trend);
            }

        if  (Low[i] < lastLow) 
            {
            lowBefore = lastLow;
            lastLow = Low[i];
            GlobalVariableSet(Symbol()+"-LL",lastHigh);
            lastBroken = "L";
            brokenBarL = Time[i];
            trend = -1;	
            GlobalVariableSet(Symbol()+"-HBT",trend);
            }
        
        if 	(brokenBarL == brokenBarH &&
            Time[i] == brokenBarL)
            {
            if  (Close[i] > lastFH)
                {
                highBefore = lastHigh;
                lastHigh = High[i];
                GlobalVariableSet(Symbol()+"-LH",lastHigh);
                lastBroken = "H";
                trend = 1;
                GlobalVariableSet(Symbol()+"-HBT",trend);
                }
                
            if  (Close[i] < lastFL) 
                {
                lowBefore = lastLow;
                lastLow = Low[i];
                GlobalVariableSet(Symbol()+"-LL",lastHigh);
                lastBroken = "L";
                trend = -1;
                GlobalVariableSet(Symbol()+"-HBT",trend);
                }
            }
/*
	Comment("FH/H = ",lastFH," / ",lastHigh,"  |  ",
			"FL/L = ",lastFL," / ",lastLow,"\n",	
			//"PH/L = ",highBefore," / ",lowBefore,"\n",
			"B/Tr = ",lastBroken," / ",trend,"\n\n",
			"dFHL = ",(lastFH-lastFL)/Point," pips\n",
			"dC2F H = ",MathAbs(Close[0]-lastFH)/Point,"  L = ",MathAbs(Close[0]-lastFL)/Point);
*/            
            if 	(trend == -1)
                { 
                XMB1[i] = High[i];
                XMB2[i] = Low[i];
                
                if  (Open[i]>Close[i])
                    {
                    XMB3[i] = Open[i];
                    XMB4[i] = Close[i];
                    } else {
                    XMB4[i] = Open[i];
                    XMB3[i] = Close[i];
                    }
                               
                } else { 
                XMB2[i] = High[i];
                XMB1[i] = Low[i];
                
                if  (Open[i]<Close[i])
                    {
                    XMB3[i] = Open[i];
                    XMB4[i] = Close[i];
                    } else {
                    XMB4[i] = Open[i];
                    XMB3[i] = Close[i];
                    }                 
                }     
        
        } // for(int i=limit; i>TTFbars; i--)
   
   return(0);
  }