//+------------------------------------------------------------------+
//|                                                        MP-PZ.mq4 |
//|                                                           MojoFX |
//|                                         http://fx.studiomojo.com |
//|                             mojoFX@gmail.com | fx@studiomojo.com |
//|                                            v1.0 - March 27, 2004 |
//+------------------------------------------------------------------+
#property copyright "2005 - MojoFX - Uman Madiprasojo"
#property link      "http://fx.studiomojo.com"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 GreenYellow
#property indicator_color2 Red

//---- input parameters
extern int       dayChangeHour=22;
extern int       VolatilityRange=12;
extern bool      simpleSR=true;
extern bool      floatExit=true;
extern bool      ydayHL=true;

//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
//---- variables
int limit, prev_day, barChangeDay;
double y_c,t_o,y_h,y_l,y_hH,y_hL,y_lH,y_lL,P,PH,PL,R1,S1,R2,S2,R3,S3,cl3,ch3;
double day_high, day_low, day_highH, day_highL, day_lowH, day_lowL, dayHprev, dayLprev;
double last_week_close,last_week_open,last_week_high,last_week_low,this_week_open;
double dpFloatPrice,WP,posRisk,floatRisk;
bool expire = false;

if ( CurTime()<StrToTime("2006.06.01") &&
   CurTime()>StrToTime("2006.06.15") )
   { 
   expire=true; 
   Comment("\n MojoPivot Package has expired!!!\n Please contact forexhusky@yahoo.com for subscription.");
   return(0);
   }
   
if ( Period()>60 || Period()<15 )
   {
   Comment("Incorrect timeframe. 15M preferred. 1H is max.");
   }   

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_HISTOGRAM,EMPTY,2);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexStyle(1,DRAW_HISTOGRAM,EMPTY,2);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexLabel(0,"MP - PivotZone");
   SetIndexLabel(1,"MP - PivotZone");
   
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));
   IndicatorShortName("MP - PivotZone");   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- TODO: add your code here
   ObjectsRedraw();
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
   {
    
   ObjectCreate("yH_arr", OBJ_ARROW,0, 0, 0);
   ObjectCreate("yL_arr", OBJ_ARROW,0, 0, 0);
   ObjectCreate("WP_arr", OBJ_ARROW,0, 0, 0);
	ObjectCreate("DP_float",2,0,0,0,0,0);
	
   ObjectCreate("DP_PH",2,0,0,0,0,0);
   ObjectCreate("DP_PL",2,0,0,0,0,0);
   ObjectCreate("DP_FEH",2,0,0,0,0,0);
   ObjectCreate("DP_FEL",2,0,0,0,0,0);
   ObjectCreate("DP_yH",2,0,0,0,0,0);
   ObjectCreate("DP_yL",2,0,0,0,0,0);
   ObjectCreate("DP_WP",2,0,0,0,0,0);
   
   ObjectSet("yH_arr", OBJPROP_ARROWCODE, 5);
   ObjectSet("yL_arr", OBJPROP_ARROWCODE, 5);
   ObjectSet("WP_arr", OBJPROP_ARROWCODE, 5); 
   ObjectSet("yH_arr", OBJPROP_WIDTH, 1);
   ObjectSet("yL_arr", OBJPROP_WIDTH, 1); 
   ObjectSet("WP_arr", OBJPROP_WIDTH, 2);
   
   if (simpleSR)
      {
      ObjectCreate("BH_arr", OBJ_ARROW,0, 0, 0);
      ObjectCreate("BL_arr", OBJ_ARROW,0, 0, 0);

      ObjectSet("BH_arr", OBJPROP_ARROWCODE, 177);
      ObjectSet("BL_arr", OBJPROP_ARROWCODE, 177); 
      ObjectSet("BH_arr", OBJPROP_WIDTH, 1);
      ObjectSet("BL_arr", OBJPROP_WIDTH, 1);
      ObjectSet("BH_arr", OBJPROP_COLOR, White);
      ObjectSet("BL_arr", OBJPROP_COLOR, White);      
      }    

	ObjectSet("DP_PH",OBJPROP_COLOR,DarkSlateGray);
	ObjectSet("DP_PL",OBJPROP_COLOR,DarkSlateGray);
	ObjectSet("DP_FEH",OBJPROP_COLOR,DarkGray);
	ObjectSet("DP_FEL",OBJPROP_COLOR,DarkGray);
	ObjectSet("DP_FEH",OBJPROP_STYLE,STYLE_DOT);
	ObjectSet("DP_FEL",OBJPROP_STYLE,STYLE_DOT);

	ObjectSet("DP_yH",OBJPROP_COLOR,Red);
	ObjectSet("DP_yL",OBJPROP_COLOR,Red);
	ObjectSet("DP_yH",OBJPROP_STYLE,STYLE_DOT);
	ObjectSet("DP_yL",OBJPROP_STYLE,STYLE_DOT);

	ObjectSet("DP_WP",OBJPROP_COLOR,HotPink);
	ObjectSet("DP_WP",OBJPROP_STYLE,STYLE_DOT);

	ObjectSet   ("DP_float",OBJPROP_COLOR,White);
	ObjectSet   ("DP_float",OBJPROP_WIDTH,2);
	ObjectSet   ("DP_float",OBJPROP_RAY,true);

   int counted_bars=IndicatorCounted();
   if (counted_bars<0) return(-1);
   if (counted_bars>0) counted_bars--;
   
   limit=Bars-counted_bars;

   for(int i=limit; i>=0; i--)
      {
        if  (expire) 
            {
            ObjectsDeleteAll();
            break; 
            }
        
        if  (
            TimeDayOfWeek(Time[i])==1 &&
            TimeDayOfWeek(Time[i+1])!=1
            ){
            last_week_close = Close[i+1];
            this_week_open = Open[i];
            
            WP = (last_week_high + last_week_low + this_week_open + last_week_close) / 4;
            
            last_week_high = High[i];
            last_week_low  = Low[i];
            }      

	     last_week_high = MathMax(last_week_high, High[i]);
	     last_week_low = MathMin(last_week_low, Low[i]);
	     
	     if  (i==0 && last_week_close==0 && Period()<1440)
	         {
	         Comment(
	                "\n",
	                "ERROR: Insufficient bar data quantity. Min 11 days data needed.\n",
	                "Press HOME and click-drag chart screen to your right and release once.\n",
	                "Repeat until this message disappear."
	                );
	         }
        
        if  (
            (TimeHour(Time[i]) == dayChangeHour &&
            TimeMinute(Time[i]) == 0) || 
            (TimeHour(Time[i]) == dayChangeHour &&
            TimeHour(Time[i+1]) != dayChangeHour) 
            ){
            barChangeDay = i;
            y_c = Close[i+1];
            t_o = Open[i];
            y_h = day_high;
            y_l = day_low;
            y_hH = day_highH;
            y_hL = day_highL;
            y_lH = day_lowH;
            y_lL = day_lowL;
            
            P = (y_h + y_l + y_c + t_o) / 4;
            PH = (y_hH + y_lH + y_c + t_o) / 4;
            PL = (y_hL + y_lL + y_c + t_o) / 4;
            
            R1 = P + P - y_l;
            S1 = P + P - y_h;
            
            R2 = P + y_h - y_l;
            S2 = P - y_h + y_l;
            
            R3 = P + P - y_l - y_l + y_h;
            S3 = P + P - y_h - y_h + y_l;

            ch3 = ((y_h - y_l)* 0.2750) + y_c;
            cl3 = y_c - ((y_h - y_l)*(0.2750));
            
            day_high = High[i];
            day_low  = Low[i];
            
            GlobalVariableSet(Symbol()+"-PH",PH);
            GlobalVariableSet(Symbol()+"-PL",PL);
            
            } // if
        
        dayHprev = day_high;
        dayLprev = day_low;
        
        day_high = MathMax(day_high, High[i]);
        day_low = MathMin(day_low, Low[i]);
        
        if 	(dayHprev != day_high)
            {
            if (Period()<=15)
               {
               day_highH = High[Highest(NULL,0,MODE_HIGH,3,i-1)];
               day_highL = Low[Lowest(NULL,0,MODE_LOW,3,i-1)];
               } else {
               day_highH = High[i];
               day_highL = Low[i];
               }
            }
		
		  if	(dayLprev != day_low)
		      {
            if (Period()<=15)
               {
               day_lowH = High[Highest(NULL,0,MODE_HIGH,3,i-1)];
               day_lowL = Low[Lowest(NULL,0,MODE_LOW,3,i-1)];
               } else {
               day_lowH = High[i];
               day_lowL = Low[i];
               }
		      }
   
        if  (P > WP)
            {
            ExtMapBuffer1[i]=PH;
            ExtMapBuffer2[i]=PL;
            } else {
            ExtMapBuffer1[i]=PL;
            ExtMapBuffer2[i]=PH;            
            }
            
    dpFloatPrice = (day_high+day_low+Close[0])/3;                       
    
    if  (Close[0] > dpFloatPrice) 
        {
        ObjectSet("DP_float",OBJPROP_COLOR,Chartreuse);
        AdjustObject("DP_float",Time[5],dpFloatPrice,Time[0],dpFloatPrice);
        }

              
	 if  (Close[0] < dpFloatPrice)
	     {
	     ObjectSet("DP_float",OBJPROP_COLOR,Red);
	     AdjustObject("DP_float",Time[5],dpFloatPrice,Time[0],dpFloatPrice);
	     }    

    if  (Ask > PH) 
        {
        posRisk = MathRound(MathAbs(Ask- PL)/Point);
        floatRisk = MathRound(MathAbs(Ask - (((PH+PL)/2)-iATR(NULL,0,VolatilityRange,0)))/Point);
        }
        
    if  (Bid < PL)
        {
        posRisk = MathRound(MathAbs(PH - Bid)/Point);
        floatRisk = MathRound(MathAbs(((PH+PL)/2)+iATR(NULL,0,VolatilityRange,0) - Bid)/Point);
        }
       
    Comment("Entry Risk = ",posRisk," / ",floatRisk);    
	    
    AdjustObject("DP_PH",Time[barChangeDay+10],PH,Time[0],PH);
    AdjustObject("DP_PL",Time[barChangeDay+10],PL,Time[0],PL);
    
    if (floatExit) {
    AdjustObject("DP_FEH",Time[barChangeDay+10],((PH+PL)/2)+iATR(NULL,0,VolatilityRange,0),Time[0],((PH+PL)/2)+iATR(NULL,0,VolatilityRange,0));
    AdjustObject("DP_FEL",Time[barChangeDay+10],((PH+PL)/2)-iATR(NULL,0,VolatilityRange,0),Time[0],((PH+PL)/2)-iATR(NULL,0,VolatilityRange,0));
    }

    if (ydayHL) {
    AdjustObject("DP_yH",Time[barChangeDay+10],y_hH,Time[0],y_hH);
    AdjustObject("DP_yL",Time[barChangeDay+10],y_lL,Time[0],y_lL);
    AdjustObject("yL_arr",Time[barChangeDay+10], y_lL,Time[barChangeDay+10], y_lL);
    AdjustObject("yH_arr",Time[barChangeDay+10], y_hH,Time[barChangeDay+10], y_hH);
    }

    AdjustObject("DP_WP",Time[barChangeDay+10],WP,Time[0],WP);
    AdjustObject("WP_arr",Time[barChangeDay+10], WP,Time[barChangeDay+10], WP);
    
    if  (simpleSR)
        {
        AdjustObject("BH_arr",Time[0], ch3,Time[0], ch3);
        AdjustObject("BL_arr",Time[0], cl3,Time[0], cl3);
        }

        } // for
    
    if  (!simpleSR)
        {
        ObjectCreate("DR3_txt", OBJ_TEXT, 0, Time[20], R3);
        ObjectCreate("DR2_txt", OBJ_TEXT, 0, Time[20], R2);
        ObjectCreate("DR1_txt", OBJ_TEXT, 0, Time[20], R1);
        ObjectCreate("DS1_txt", OBJ_TEXT, 0, Time[20], S1);
        ObjectCreate("DS2_txt", OBJ_TEXT, 0, Time[20], S2);
        ObjectCreate("DS3_txt", OBJ_TEXT, 0, Time[20], S3);
            
        ObjectSetText("DR3_txt", "R3 "+DoubleToStr(R3,4), 8, "Arial", White);
        ObjectSetText("DR2_txt", "R2 "+DoubleToStr(R2,4), 8, "Arial", White);
        ObjectSetText("DR1_txt", "R1 "+DoubleToStr(R1,4), 8, "Arial", White);
        ObjectSetText("DS1_txt", "S1 "+DoubleToStr(S1,4), 8, "Arial", White);
        ObjectSetText("DS2_txt", "S2 "+DoubleToStr(S2,4), 8, "Arial", White);
        ObjectSetText("DS3_txt", "S3 "+DoubleToStr(S3,4), 8, "Arial", White);
        
      }

   return(0);
   }
   
//+------------------------------------------------------------------+

void AdjustObject(string ObjName, int T1, double P1, int T2, double P2)
    {
    ObjectSet(ObjName, OBJPROP_TIME1, T1);
    ObjectSet(ObjName, OBJPROP_PRICE1, P1);
    ObjectSet(ObjName, OBJPROP_TIME2, T2);
    ObjectSet(ObjName, OBJPROP_PRICE2, P2);
    }

