//+------------------------------------------------------------------+
//|                                                        MP-TL.mq4 |
//|                                                           MojoFX |
//|                                         http://fx.studiomojo.com |
//|                             mojoFX@gmail.com | fx@studiomojo.com |
//|                                            v1.0 - March 27, 2004 |
//+------------------------------------------------------------------+
#property copyright "2005 - MojoFX - Uman Madiprasojo"
#property link      "http://fx.studiomojo.com"

#property indicator_chart_window
#property indicator_buffers 1
#property indicator_color1 Orange

extern double TrendSpan_inDays = 5;
extern double CurveReflex = 0.618;

double t3Array[];

double e1,e2,e3,e4,e5,e6,ep1,ep2,ep3,ep4,ep5,ep6;
double c1,c2,c3,c4;
double n,w1,w2,b2,b3;
bool expire = false;

Comment("");
if ( CurTime()<StrToTime("2006.06.01") &&
   CurTime()>StrToTime("2006.06.15") )
   { 
   expire=true; 
   Comment("\n MojoPivot Package has expired!!!\n Please contact forexhusky@yahoo.com for subscription.");
   return(0);
   }

int init()
   {
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,1);
   SetIndexDrawBegin(0,TrendSpan_inDays);
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));
   IndicatorShortName("MP - Trendline");
   
   SetIndexBuffer(0,t3Array);
   SetIndexLabel(0,"MP - Trendline");
   
   b2=CurveReflex*CurveReflex;
   b3=b2*CurveReflex;
   c1=-b3;
   c2=(3*(b2+b3));
   c3=-3*(2*b2+CurveReflex+b3);
   c4=(1+3*CurveReflex+b3+3*b2);
   n=MathRound(TrendSpan_inDays*1440/Period());
   
   if (n<1) n=1;
   
   n = 1 + 0.5*(n-1);
   w1 = 2 / (n + 1);
   w2 = 1 - w1;
    
   e1=Open[Bars-1];
	e2=Open[Bars-1];
	e3=Open[Bars-1];
	e4=Open[Bars-1];
	e5=Open[Bars-1];
	e6=Open[Bars-1];
    
   return(0);
   }

int start()
   {
   int limit;
   int counted_bars=IndicatorCounted();
   limit=Bars;

   //int counted_bars = IndicatorCounted();
   //if (counted_bars < 0) return (-1);
   //int limit = Bars - counted_bars - 1;
   
   for(int i=limit; i>=0; i--)
      {
      
      if  (expire) { break; }
      
      ep1 = w1*Close[i] + w2*e1;
      ep2 = w1*ep1 + w2*e2;
      ep3 = w1*ep2 + w2*e3;
      ep4 = w1*ep3 + w2*e4;
      ep5 = w1*ep4 + w2*e5;
      ep6 = w1*ep5 + w2*e6;
      
      t3Array[i]=c1*ep6 + c2*ep5 + c3*ep4 + c4*ep3;
      e1=ep1;
      e2=ep2;
      e3=ep3;
      e4=ep4;
      e5=ep5;
      e6=ep6;
      }
      
   return(0);
   }