//+------------------------------------------------------------------+
//|                                                       MTFMI+.mq4 |
//|                                        Copyright  2007, FerruFx |
//+------------------------------------------------------------------+

#property indicator_separate_window

#property indicator_minimum 50
#property indicator_maximum 100
#property indicator_buffers 2
#property indicator_color1 Blue
#property indicator_color2 Red
#property indicator_width1  2
#property indicator_width2  2

//---- Bars to display
extern string    Max_Bars_To_Display     = "=== How many bars to display ===";
extern int       maxbars=500;

//---- Indicators to calculate the trend
extern string    Trend_calculation     = "=== Trend calculation and display ===";
extern bool      display_fast_MA       =     true;
extern bool      display_medium_MA     =     true;
extern bool      display_slow_MA       =     true;
extern bool      display_CCI           =     true;
extern bool      display_MACD          =     true;
extern bool      display_ADX           =     true;
extern bool      display_BULLS         =     true;
extern bool      display_BEARS         =     true;
extern bool      display_STOCH         =     true;
extern bool      display_RSI           =     true;
extern bool      display_FORCE         =     true;
extern bool      display_MOMENTUM      =     true;
extern bool      display_DeMARKER      =     true;
extern bool      display_WAE           =     true;

//---- Timeframes to display and calculate the trend
extern string    TF_calculation        = "=== If display false, set coef to 0 ===";
extern string    Coefs_TF              = "3 TF true, SUM of their coef must be 3";
extern bool      display_M1            =     true;
extern double    coef_m1               =      1.0;
extern bool      display_M5            =     true;
extern double    coef_m5               =      1.0;
extern bool      display_M15           =     true;
extern double    coef_m15              =      1.0;
extern bool      display_M30           =     true;
extern double    coef_m30              =      1.0;
extern bool      display_H1            =     true;
extern double    coef_H1               =      1.0;
extern bool      display_H4            =     true;
extern double    coef_H4               =      1.0;
extern bool      display_D1            =     true;
extern double    coef_D1               =      1.0;

string    MA_Settings           = "=== Moving Average Settings ===";
int       FastMAPeriod          =           20;  // Fast Moving Average period
int       MediumMAPeriod        =           50;  // Medium Moving Average period
int       SlowMAPeriod          =          100;  // Slow Moving Average period
int       MAMethod              =     MODE_EMA;  // Moving Average method
int       MAPrice               =  PRICE_CLOSE;  // Moving Average price

string    CCI_Settings          = "=== CCI Settings ===";
int       CCIPeriod             =           14;  // Commodity Channel Index  period
int       CCIPrice              =  PRICE_CLOSE;  // CCI price

string    MACD_Settings         = "=== MACD Settings ===";
int       MACDFast              =           12;  // MACD fast EMA period
int       MACDSlow              =           26;  // MACD slow EMA period
int       MACDSignal            =            9;  // MACD signal SMA period

string    ADX_Settings          = "=== ADX Settings ===";
int       ADXPeriod             =           14;  // Average Directional movement  period
int       ADXPrice              =  PRICE_CLOSE;  // ADX price

string    BULLS_Settings        = "=== BULLS Settings ===";
int       BULLSPeriod           =           13;  // Bulls Power  period
int       BULLSPrice            =  PRICE_CLOSE;  // Bulls Power price

string    BEARS_Settings        = "=== BEARS Settings ===";
int       BEARSPeriod           =           13;  // Bears Power  period
int       BEARSPrice            =  PRICE_CLOSE;  // Bears Power price

string    STOCHASTIC_Settings   = "=== STOCHASTIC Settings ===";
int       STOKPeriod            =            5;  // Stochastic %K  period
int       STODPeriod            =            3;  // Stochastic %D  period
int       STOSlowing            =            3;  // Stochastic slowing

string    RSI_Settings          = "=== RSI Settings ===";
int       RSIPeriod             =           14;  // RSI  period

string    FORCE_Settings        = "=== FORCE INDEX Settings ===";
int       FIPeriod              =           14;  // Force Index period
int       FIMethod              =     MODE_SMA;  // Force Index method
int       FIPrice               =  PRICE_CLOSE;  // Force Index price

string    MOMENTUM_Settings     = "=== MOMENTUM INDEX Settings ===";
int       MOMPeriod             =           14;  // Momentum period
int       MOMPrice              =  PRICE_CLOSE;  // Momentum price

string    DeMARKER_Settings     = "=== DeMARKER Settings ===";
int       DEMPeriod             =           14;  // DeMarker  period

double UPBuffer[];
double DOWNBuffer[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
  
//---- indicator line
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(0,UPBuffer);
   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(1,DOWNBuffer);

//---- name for indicator window
   string short_name="MTFMI+ (Multi TFs Multi Indics)";
   IndicatorShortName(short_name);

   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
  
double UP_1, UP_2, UP_3, UP_4, UP_5, UP_6, UP_7, UP_8, UP_9, UP_10;
double UP_11, UP_12, UP_13, UP_14, UP_15, UP_16, UP_17, UP_18, UP_19, UP_20;
double UP_21, UP_22, UP_23, UP_24, UP_25, UP_26, UP_27, UP_28, UP_29, UP_30;
double UP_31, UP_32, UP_33, UP_34, UP_35, UP_36, UP_37, UP_38, UP_39, UP_40;
double UP_41, UP_42, UP_43, UP_44, UP_45, UP_46, UP_47, UP_48, UP_49, UP_50;
double UP_51, UP_52, UP_53, UP_54, UP_55, UP_56, UP_57, UP_58, UP_59, UP_60;
double UP_61, UP_62, UP_63, UP_64;

double DOWN_1, DOWN_2, DOWN_3, DOWN_4, DOWN_5, DOWN_6, DOWN_7, DOWN_8, DOWN_9, DOWN_10;
double DOWN_11, DOWN_12, DOWN_13, DOWN_14, DOWN_15, DOWN_16, DOWN_17, DOWN_18, DOWN_19, DOWN_20;
double DOWN_21, DOWN_22, DOWN_23, DOWN_24, DOWN_25, DOWN_26, DOWN_27, DOWN_28, DOWN_29, DOWN_30;
double DOWN_31, DOWN_32, DOWN_33, DOWN_34, DOWN_35, DOWN_36, DOWN_37, DOWN_38, DOWN_39, DOWN_40;
double DOWN_41, DOWN_42, DOWN_43, DOWN_44, DOWN_45, DOWN_46, DOWN_47, DOWN_48, DOWN_49, DOWN_50;
double DOWN_51, DOWN_52, DOWN_53, DOWN_54, DOWN_55, DOWN_56, DOWN_57, DOWN_58, DOWN_59, DOWN_60;
double DOWN_61, DOWN_62, DOWN_63, DOWN_64;

double UP_65, UP_66, UP_67, UP_68, UP_69, UP_70;
double UP_71, UP_72, UP_73, UP_74, UP_75, UP_76, UP_77, UP_78, UP_79, UP_80;
double UP_81, UP_82, UP_83, UP_84, UP_85, UP_86, UP_87, UP_88, UP_89, UP_90;
double UP_91, UP_92, UP_93, UP_94, UP_95, UP_96, UP_97, UP_98, UP_99, UP_100;
double UP_101, UP_102, UP_103, UP_104, UP_105, UP_106, UP_107, UP_108, UP_109, UP_110;
double UP_111, UP_112;

double DOWN_65, DOWN_66, DOWN_67, DOWN_68, DOWN_69, DOWN_70;
double DOWN_71, DOWN_72, DOWN_73, DOWN_74, DOWN_75, DOWN_76, DOWN_77, DOWN_78, DOWN_79, DOWN_80;
double DOWN_81, DOWN_82, DOWN_83, DOWN_84, DOWN_85, DOWN_86, DOWN_87, DOWN_88, DOWN_89, DOWN_90;
double DOWN_91, DOWN_92, DOWN_93, DOWN_94, DOWN_95, DOWN_96, DOWN_97, DOWN_98, DOWN_99, DOWN_100;
double DOWN_101, DOWN_102, DOWN_103, DOWN_104, DOWN_105, DOWN_106, DOWN_107, DOWN_108, DOWN_109, DOWN_110;
double DOWN_111, DOWN_112;

double count_m1, count_m5, count_m15, count_m30, count_h1, count_h4, count_d1;

  if ( display_M1 == true) { count_m1 = 1; }
  if ( display_M5 == true) { count_m5 = 1; }
  if ( display_M15 == true) { count_m15 = 1; }
  if ( display_M30 == true) { count_m30 = 1; }
  if ( display_H1 == true) { count_h1 = 1; }
  if ( display_H4 == true) { count_h4 = 1; }
  if ( display_D1 == true) { count_d1 = 1; }
  
  double count_tf = count_m1 + count_m5 + count_m15 + count_m30 + count_h1 + count_h4 + count_d1;
  double coef = coef_m1 + coef_m5 + coef_m15 + coef_m30 + coef_H1 + coef_H4 + coef_D1;
  if( coef != count_tf ) { Alert("The sum of the coefs must be ",  count_tf,". Your setting is ", coef,"!!!"); }
   
      
      //---- Count number of bars on chart
      int    counted_bars=IndicatorCounted();
      //---- check for possible errors
      if(counted_bars<0) return(-1);
      int limit=Bars-counted_bars;
      if(limit>maxbars)limit=maxbars;
      //---- 
      for (int i=0;i<=limit;i++)
      {
   
// Indicator (Moving Average)

   // FAST
   
   if( display_fast_MA == true )
   {
   if( display_M1 == true )
   {
   double FastMA_1_1 = iMA(NULL,PERIOD_M1,FastMAPeriod,0,MAMethod,MAPrice,i);
   double FastMA_2_1 = iMA(NULL,PERIOD_M1,FastMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((FastMA_1_1 > FastMA_2_1)) { UP_1 = 1; DOWN_1 = 0; }
   if ((FastMA_1_1 < FastMA_2_1)) { UP_1 = 0; DOWN_1 = 1; }
   }
  
   if( display_M5 == true )
   {   
   double FastMA_1_5 = iMA(NULL,PERIOD_M5,FastMAPeriod,0,MAMethod,MAPrice,i);
   double FastMA_2_5 = iMA(NULL,PERIOD_M5,FastMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((FastMA_1_5 > FastMA_2_5)) { UP_2 = 1; DOWN_2 = 0; }
   if ((FastMA_1_5 < FastMA_2_5)) { UP_2 = 0; DOWN_2 = 1; }
   }
   
   if( display_M15 == true )
   {   
   double FastMA_1_15 = iMA(NULL,PERIOD_M15,FastMAPeriod,0,MAMethod,MAPrice,i);
   double FastMA_2_15 = iMA(NULL,PERIOD_M15,FastMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((FastMA_1_15 > FastMA_2_15)) { UP_3 = 1; DOWN_3 = 0; }
   if ((FastMA_1_15 < FastMA_2_15)) { UP_3 = 0; DOWN_3 = 1; }
   }
   
   if( display_M30 == true )
   {   
   double FastMA_1_30 = iMA(NULL,PERIOD_M30,FastMAPeriod,0,MAMethod,MAPrice,i);
   double FastMA_2_30 = iMA(NULL,PERIOD_M30,FastMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((FastMA_1_30 > FastMA_2_30)) { UP_4 = 1; DOWN_4 = 0; }
   if ((FastMA_1_30 < FastMA_2_30)) { UP_4 = 0; DOWN_4 = 1; }
   }
   
   if( display_H1 == true )
   {  
   double FastMA_1_60 = iMA(NULL,PERIOD_H1,FastMAPeriod,0,MAMethod,MAPrice,i);
   double FastMA_2_60 = iMA(NULL,PERIOD_H1,FastMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((FastMA_1_60 > FastMA_2_60)) { UP_5 = 1; DOWN_5 = 0; }
   if ((FastMA_1_60 < FastMA_2_60)) { UP_5 = 0; DOWN_5 = 1; }
   }
   
   if( display_H4 == true )
   {
   double FastMA_1_240 = iMA(NULL,PERIOD_H4,FastMAPeriod,0,MAMethod,MAPrice,i);
   double FastMA_2_240 = iMA(NULL,PERIOD_H4,FastMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((FastMA_1_240 > FastMA_2_240)) { UP_6 = 1; DOWN_6 = 0; }
   if ((FastMA_1_240 < FastMA_2_240)) { UP_6 = 0; DOWN_6 = 1; }
   }
   
   if( display_D1 == true )
   {
   double FastMA_1_1440 = iMA(NULL,PERIOD_D1,FastMAPeriod,0,MAMethod,MAPrice,i);
   double FastMA_2_1440 = iMA(NULL,PERIOD_D1,FastMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((FastMA_1_1440 > FastMA_2_1440)) { UP_7 = 1; DOWN_7 = 0; }
   if ((FastMA_1_1440 < FastMA_2_1440)) { UP_7 = 0; DOWN_7 = 1; }
   }
   }
   
   // MEDIUM
   
   if( display_medium_MA == true )
   {
   if( display_M1 == true )
   {
   double MediumMA_1_1 = iMA(NULL,PERIOD_M1,MediumMAPeriod,0,MAMethod,MAPrice,i);
   double MediumMA_2_1 = iMA(NULL,PERIOD_M1,MediumMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((MediumMA_1_1 > MediumMA_2_1)) { UP_9 = 1; DOWN_9 = 0; }
   if ((MediumMA_1_1 < MediumMA_2_1)) { UP_9 = 0; DOWN_9 = 1; }
   }
   
   if( display_M5 == true )
   {
   double MediumMA_1_5 = iMA(NULL,PERIOD_M5,MediumMAPeriod,0,MAMethod,MAPrice,i);
   double MediumMA_2_5 = iMA(NULL,PERIOD_M5,MediumMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((MediumMA_1_5 > MediumMA_2_5)) { UP_10 = 1; DOWN_10 = 0; }
   if ((MediumMA_1_5 < MediumMA_2_5)) { UP_10 = 0; DOWN_10 = 1; }
   }
   
   if( display_M15 == true )
   {
   double MediumMA_1_15 = iMA(NULL,PERIOD_M15,MediumMAPeriod,0,MAMethod,MAPrice,i);
   double MediumMA_2_15 = iMA(NULL,PERIOD_M15,MediumMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((MediumMA_1_15 > MediumMA_2_15)) { UP_11 = 1; DOWN_11 = 0; }
   if ((MediumMA_1_15 < MediumMA_2_15)) { UP_11 = 0; DOWN_11 = 1; }
   }
   
   if( display_M30 == true )
   {
   double MediumMA_1_30 = iMA(NULL,PERIOD_M30,MediumMAPeriod,0,MAMethod,MAPrice,i);
   double MediumMA_2_30 = iMA(NULL,PERIOD_M30,MediumMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((MediumMA_1_30 > MediumMA_2_30)) { UP_12 = 1; DOWN_12 = 0; }
   if ((MediumMA_1_30 < MediumMA_2_30)) { UP_12 = 0; DOWN_12 = 1; }
   }
   
   if( display_H1 == true )
   {
   double MediumMA_1_60 = iMA(NULL,PERIOD_H1,MediumMAPeriod,0,MAMethod,MAPrice,i);
   double MediumMA_2_60 = iMA(NULL,PERIOD_H1,MediumMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((MediumMA_1_60 > MediumMA_2_60)) { UP_13 = 1; DOWN_13 = 0; }
   if ((MediumMA_1_60 < MediumMA_2_60)) { UP_13 = 0; DOWN_13 = 1; }
   }
   
   if( display_H4 == true )
   {
   double MediumMA_1_240 = iMA(NULL,PERIOD_H4,MediumMAPeriod,0,MAMethod,MAPrice,i);
   double MediumMA_2_240 = iMA(NULL,PERIOD_H4,MediumMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((MediumMA_1_240 > MediumMA_2_240)) { UP_14 = 1; DOWN_14 = 0; }
   if ((MediumMA_1_240 < MediumMA_2_240)) { UP_14 = 0; DOWN_14 = 1; }
   }
   
   if( display_D1 == true )
   {
   double MediumMA_1_1440 = iMA(NULL,PERIOD_D1,MediumMAPeriod,0,MAMethod,MAPrice,i);
   double MediumMA_2_1440 = iMA(NULL,PERIOD_D1,MediumMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((MediumMA_1_1440 > MediumMA_2_1440)) { UP_15 = 1; DOWN_15 = 0; }
   if ((MediumMA_1_1440 < MediumMA_2_1440)) { UP_15 = 0; DOWN_15 = 1; }
   }
   }
   
   // SLOW
   
   if( display_slow_MA == true )
   {
   if( display_M1 == true )
   {
   double SlowMA_1_1 = iMA(NULL,PERIOD_M1,SlowMAPeriod,0,MAMethod,MAPrice,i);
   double SlowMA_2_1 = iMA(NULL,PERIOD_M1,SlowMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((SlowMA_1_1 > SlowMA_2_1)) { UP_17 = 1; DOWN_17 = 0; }
   if ((SlowMA_1_1 < SlowMA_2_1)) { UP_17 = 0; DOWN_17 = 1; }
   }
   
   if( display_M5 == true )
   {
   double SlowMA_1_5 = iMA(NULL,PERIOD_M5,SlowMAPeriod,0,MAMethod,MAPrice,i);
   double SlowMA_2_5 = iMA(NULL,PERIOD_M5,SlowMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((SlowMA_1_5 > SlowMA_2_5)) { UP_18 = 1; DOWN_18 = 0; }
   if ((SlowMA_1_5 < SlowMA_2_5)) { UP_18 = 0; DOWN_18 = 1; }
   }
   
   if( display_M15 == true )
   {
   double SlowMA_1_15 = iMA(NULL,PERIOD_M15,SlowMAPeriod,0,MAMethod,MAPrice,i);
   double SlowMA_2_15 = iMA(NULL,PERIOD_M15,SlowMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((SlowMA_1_15 > SlowMA_2_15)) { UP_19 = 1; DOWN_19 = 0; }
   if ((SlowMA_1_15 < SlowMA_2_15)) { UP_19 = 0; DOWN_19 = 1; }
   }
   
   if( display_M30 == true )
   {
   double SlowMA_1_30 = iMA(NULL,PERIOD_M30,SlowMAPeriod,0,MAMethod,MAPrice,i);
   double SlowMA_2_30 = iMA(NULL,PERIOD_M30,SlowMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((SlowMA_1_30 > SlowMA_2_30)) { UP_20 = 1; DOWN_20 = 0; }
   if ((SlowMA_1_30 < SlowMA_2_30)) { UP_20 = 0; DOWN_20 = 1; }
   }
   
   if( display_H1 == true )
   {
   double SlowMA_1_60 = iMA(NULL,PERIOD_H1,SlowMAPeriod,0,MAMethod,MAPrice,i);
   double SlowMA_2_60 = iMA(NULL,PERIOD_H1,SlowMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((SlowMA_1_60 > SlowMA_2_60)) { UP_21 = 1; DOWN_21 = 0; }
   if ((SlowMA_1_60 < SlowMA_2_60)) { UP_21 = 0; DOWN_21 = 1; }
   }
   
   if( display_H4 == true )
   {
   double SlowMA_1_240 = iMA(NULL,PERIOD_H4,SlowMAPeriod,0,MAMethod,MAPrice,i);
   double SlowMA_2_240 = iMA(NULL,PERIOD_H4,SlowMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((SlowMA_1_240 > SlowMA_2_240)) { UP_22 = 1; DOWN_22 = 0; }
   if ((SlowMA_1_240 < SlowMA_2_240)) { UP_22 = 0; DOWN_22 = 1; }
   }
   
   if( display_D1 == true )
   {
   double SlowMA_1_1440 = iMA(NULL,PERIOD_D1,SlowMAPeriod,0,MAMethod,MAPrice,i);
   double SlowMA_2_1440 = iMA(NULL,PERIOD_D1,SlowMAPeriod,0,MAMethod,MAPrice,i+1);
   if ((SlowMA_1_1440 > SlowMA_2_1440)) { UP_23 = 1; DOWN_23 = 0; }
   if ((SlowMA_1_1440 < SlowMA_2_1440)) { UP_23 = 0; DOWN_23 = 1; }
   }
   }
   
// Indicator (CCI)
   
   if( display_CCI == true )
   {
   if( display_M1 == true )
   {
   double CCI_1=iCCI(NULL,PERIOD_M1,CCIPeriod,CCIPrice,i);
   if ((CCI_1 > 0)) { UP_25 = 1; DOWN_25 = 0; }
   if ((CCI_1 < 0)) { UP_25 = 0; DOWN_25 = 1; }
   }
   
   if( display_M5 == true )
   {
   double CCI_5=iCCI(NULL,PERIOD_M5,CCIPeriod,CCIPrice,i);
   if ((CCI_5 > 0)) { UP_26 = 1; DOWN_26 = 0; }
   if ((CCI_5 < 0)) { UP_26 = 0; DOWN_26 = 1; }
   }
   
   if( display_M15 == true )
   {
   double CCI_15=iCCI(NULL,PERIOD_M15,CCIPeriod,CCIPrice,i);
   if ((CCI_15 > 0)) { UP_27 = 1; DOWN_27 = 0; }
   if ((CCI_15 < 0)) { UP_27 = 0; DOWN_27 = 1; }
   }
   
   if( display_M30 == true )
   {
   double CCI_30=iCCI(NULL,PERIOD_M30,CCIPeriod,CCIPrice,i);
   if ((CCI_30 > 0)) { UP_28 = 1; DOWN_28 = 0; }
   if ((CCI_30 < 0)) { UP_28 = 0; DOWN_28 = 1; }
   }
   
   if( display_H1 == true )
   {
   double CCI_60=iCCI(NULL,PERIOD_H1,CCIPeriod,CCIPrice,i);
   if ((CCI_60 > 0)) { UP_29 = 1; DOWN_29 = 0; }
   if ((CCI_60 < 0)) { UP_29 = 0; DOWN_29 = 1; }
   }
   
   if( display_H4 == true )
   {
   double CCI_240=iCCI(NULL,PERIOD_H4,CCIPeriod,CCIPrice,i);
   if ((CCI_240 > 0)) { UP_30 = 1; DOWN_30 = 0; }
   if ((CCI_240 < 0)) { UP_30 = 0; DOWN_30 = 1; }
   }
   
   if( display_D1 == true )
   {
   double CCI_1440=iCCI(NULL,PERIOD_D1,CCIPeriod,CCIPrice,i);
   if ((CCI_1440 > 0)) { UP_31 = 1; DOWN_31 = 0; }
   if ((CCI_1440 < 0)) { UP_31 = 0; DOWN_31 = 1; }
   }
   }
   
// Indicator (MACD)
   
   if( display_MACD == true )
   {
   if( display_M1 == true )
   {
   double MACD_m_1=iMACD(NULL,PERIOD_M1,MACDFast,MACDSlow,MACDSignal,PRICE_CLOSE,MODE_MAIN,i);
   double MACD_s_1=iMACD(NULL,PERIOD_M1,MACDFast,MACDSlow,MACDSignal,PRICE_CLOSE,MODE_SIGNAL,i);
   if ((MACD_m_1 > MACD_s_1)) { UP_33 = 1; DOWN_33 = 0; }
   if ((MACD_m_1 < MACD_s_1)) { UP_33 = 0; DOWN_33 = 1; }
   }
   
   if( display_M5 == true )
   {
   double MACD_m_5=iMACD(NULL,PERIOD_M5,MACDFast,MACDSlow,MACDSignal,PRICE_CLOSE,MODE_MAIN,i);
   double MACD_s_5=iMACD(NULL,PERIOD_M5,MACDFast,MACDSlow,MACDSignal,PRICE_CLOSE,MODE_SIGNAL,i);
   if ((MACD_m_5 > MACD_s_5)) { UP_34 = 1; DOWN_34 = 0; }
   if ((MACD_m_5 < MACD_s_5)) { UP_34 = 0; DOWN_34 = 1; }
   }
   
   if( display_M15 == true )
   {
   double MACD_m_15=iMACD(NULL,PERIOD_M15,MACDFast,MACDSlow,MACDSignal,PRICE_CLOSE,MODE_MAIN,i);
   double MACD_s_15=iMACD(NULL,PERIOD_M15,MACDFast,MACDSlow,MACDSignal,PRICE_CLOSE,MODE_SIGNAL,i);
   if ((MACD_m_15 > MACD_s_15)) { UP_35 = 1; DOWN_35 = 0; }
   if ((MACD_m_15 < MACD_s_15)) { UP_35 = 0; DOWN_35 = 1; }
   }
   
   if( display_M30 == true )
   {
   double MACD_m_30=iMACD(NULL,PERIOD_M30,MACDFast,MACDSlow,MACDSignal,PRICE_CLOSE,MODE_MAIN,i);
   double MACD_s_30=iMACD(NULL,PERIOD_M30,MACDFast,MACDSlow,MACDSignal,PRICE_CLOSE,MODE_SIGNAL,i);
   if ((MACD_m_30 > MACD_s_30)) { UP_36 = 1; DOWN_36 = 0; }
   if ((MACD_m_30 < MACD_s_30)) { UP_36 = 0; DOWN_36 = 1; }
   }
   
   if( display_H1 == true )
   {
   double MACD_m_60=iMACD(NULL,PERIOD_H1,MACDFast,MACDSlow,MACDSignal,PRICE_CLOSE,MODE_MAIN,i);
   double MACD_s_60=iMACD(NULL,PERIOD_H1,MACDFast,MACDSlow,MACDSignal,PRICE_CLOSE,MODE_SIGNAL,i);
   if ((MACD_m_60 > MACD_s_60)) { UP_37 = 1; DOWN_37 = 0; }
   if ((MACD_m_60 < MACD_s_60)) { UP_37 = 0; DOWN_37 = 1; }
   }
   
   if( display_H4 == true )
   {
   double MACD_m_240=iMACD(NULL,PERIOD_H4,MACDFast,MACDSlow,MACDSignal,PRICE_CLOSE,MODE_MAIN,i);
   double MACD_s_240=iMACD(NULL,PERIOD_H4,MACDFast,MACDSlow,MACDSignal,PRICE_CLOSE,MODE_SIGNAL,i);
   if ((MACD_m_240 > MACD_s_240)) { UP_38 = 1; DOWN_38 = 0; }
   if ((MACD_m_240 < MACD_s_240)) { UP_38 = 0; DOWN_38 = 1; }
   }
   
   if( display_D1 == true )
   {
   double MACD_m_1440=iMACD(NULL,PERIOD_D1,MACDFast,MACDSlow,MACDSignal,PRICE_CLOSE,MODE_MAIN,i);
   double MACD_s_1440=iMACD(NULL,PERIOD_D1,MACDFast,MACDSlow,MACDSignal,PRICE_CLOSE,MODE_SIGNAL,i);
   if ((MACD_m_1440 > MACD_s_1440)) { UP_39 = 1; DOWN_39 = 0; }
   if ((MACD_m_1440 < MACD_s_1440)) { UP_39 = 0; DOWN_39 = 1; }
   }
   }
   
// Indicator (ADX)
   
   if( display_ADX == true )
   {
   if( display_M1 == true )
   {
   double ADX_plus_1=iADX(NULL,PERIOD_M1,ADXPeriod,ADXPrice,MODE_PLUSDI,i);
   double ADX_minus_1=iADX(NULL,PERIOD_M1,ADXPeriod,ADXPrice,MODE_MINUSDI,i);
   if ((ADX_plus_1 > ADX_minus_1)) { UP_41 = 1; DOWN_41 = 0; }
   if ((ADX_plus_1 < ADX_minus_1)) { UP_41 = 0; DOWN_41 = 1; }
   }
   
   if( display_M5 == true )
   {
   double ADX_plus_5=iADX(NULL,PERIOD_M5,ADXPeriod,ADXPrice,MODE_PLUSDI,i);
   double ADX_minus_5=iADX(NULL,PERIOD_M5,ADXPeriod,ADXPrice,MODE_MINUSDI,i);
   if ((ADX_plus_5 > ADX_minus_5)) { UP_42 = 1; DOWN_42 = 0; }
   if ((ADX_plus_5 < ADX_minus_5)) { UP_42 = 0; DOWN_42 = 1; }
   }
   
   if( display_M15 == true )
   {
   double ADX_plus_15=iADX(NULL,PERIOD_M15,ADXPeriod,ADXPrice,MODE_PLUSDI,i);
   double ADX_minus_15=iADX(NULL,PERIOD_M15,ADXPeriod,ADXPrice,MODE_MINUSDI,i);
   if ((ADX_plus_15 > ADX_minus_15)) { UP_43 = 1; DOWN_43 = 0; }
   if ((ADX_plus_15 < ADX_minus_15)) { UP_43 = 0; DOWN_43 = 1; }
   }
   
   if( display_M30 == true )
   {
   double ADX_plus_30=iADX(NULL,PERIOD_M30,ADXPeriod,ADXPrice,MODE_PLUSDI,i);
   double ADX_minus_30=iADX(NULL,PERIOD_M30,ADXPeriod,ADXPrice,MODE_MINUSDI,i);
   if ((ADX_plus_30 > ADX_minus_30)) { UP_44 = 1; DOWN_44 = 0; }
   if ((ADX_plus_30 < ADX_minus_30)) { UP_44 = 0; DOWN_44 = 1; }
   }
   
   if( display_H1 == true )
   {
   double ADX_plus_60=iADX(NULL,PERIOD_H1,ADXPeriod,ADXPrice,MODE_PLUSDI,i);
   double ADX_minus_60=iADX(NULL,PERIOD_H1,ADXPeriod,ADXPrice,MODE_MINUSDI,i);
   if ((ADX_plus_60 > ADX_minus_60)) { UP_45 = 1; DOWN_45 = 0; }
   if ((ADX_plus_60 < ADX_minus_60)) { UP_45 = 0; DOWN_45 = 1; }
   }
   
   if( display_H4 == true )
   {
   double ADX_plus_240=iADX(NULL,PERIOD_H4,ADXPeriod,ADXPrice,MODE_PLUSDI,i);
   double ADX_minus_240=iADX(NULL,PERIOD_H4,ADXPeriod,ADXPrice,MODE_MINUSDI,i);
   if ((ADX_plus_240 > ADX_minus_240)) { UP_46 = 1; DOWN_46 = 0; }
   if ((ADX_plus_240 < ADX_minus_240)) { UP_46 = 0; DOWN_46 = 1; }
   }
   
   if( display_D1 == true )
   {
   double ADX_plus_1440=iADX(NULL,PERIOD_D1,ADXPeriod,ADXPrice,MODE_PLUSDI,i);
   double ADX_minus_1440=iADX(NULL,PERIOD_D1,ADXPeriod,ADXPrice,MODE_MINUSDI,i);
   if ((ADX_plus_1440 > ADX_minus_1440)) { UP_47 = 1; DOWN_47 = 0; }
   if ((ADX_plus_1440 < ADX_minus_1440)) { UP_47 = 0; DOWN_47 = 1; }
   }
   }
   
// Indicator (BULLS)
   
   if( display_BULLS == true )
   {
   if( display_M1 == true )
   {
   double bulls_1=iBullsPower(NULL,PERIOD_M1,BULLSPeriod,BULLSPrice,i);
   if ((bulls_1 > 0)) { UP_49 = 1; DOWN_49 = 0; }
   if ((bulls_1 < 0)) { UP_49 = 0; DOWN_49 = 1; }
   }
   
   if( display_M5 == true )
   {
   double bulls_5=iBullsPower(NULL,PERIOD_M5,BULLSPeriod,BULLSPrice,i);
   if ((bulls_5 > 0)) { UP_50 = 1; DOWN_50 = 0; }
   if ((bulls_5 < 0)) { UP_50 = 0; DOWN_50 = 1; }
   }
   
   if( display_M15 == true )
   {
   double bulls_15=iBullsPower(NULL,PERIOD_M15,BULLSPeriod,BULLSPrice,i);
   if ((bulls_15 > 0)) { UP_51 = 1; DOWN_51 = 0; }
   if ((bulls_15 < 0)) { UP_51 = 0; DOWN_51 = 1; }
   }
   
   if( display_M30 == true )
   {
   double bulls_30=iBullsPower(NULL,PERIOD_M30,BULLSPeriod,BULLSPrice,i);
   if ((bulls_30 > 0)) { UP_52 = 1; DOWN_52 = 0; }
   if ((bulls_30 < 0)) { UP_52 = 0; DOWN_52 = 1; }
   }
   
   if( display_H1 == true )
   {
   double bulls_60=iBullsPower(NULL,PERIOD_H1,BULLSPeriod,BULLSPrice,i);
   if ((bulls_60 > 0)) { UP_53 = 1; DOWN_53 = 0; }
   if ((bulls_60 < 0)) { UP_53 = 0; DOWN_53 = 1; }
   }
   
   if( display_H4 == true )
   {
   double bulls_240=iBullsPower(NULL,PERIOD_H4,BULLSPeriod,BULLSPrice,i);
   if ((bulls_240 > 0)) { UP_54 = 1; DOWN_54 = 0; }
   if ((bulls_240 < 0)) { UP_54 = 0; DOWN_54 = 1; }
   }
   
   if( display_D1 == true )
   {
   double bulls_1440=iBullsPower(NULL,PERIOD_D1,BULLSPeriod,BULLSPrice,i);
   if ((bulls_1440 > 0)) { UP_55 = 1; DOWN_55 = 0; }
   if ((bulls_1440 < 0)) { UP_55 = 0; DOWN_55 = 1; }
   }
   }
   
// Indicator (BEARS)
   
   if( display_BEARS == true )
   {
   if( display_M1 == true )
   {
   double bears_1=iBearsPower(NULL,PERIOD_M1,BEARSPeriod,BEARSPrice,i);
   if ((bears_1 > 0)) { UP_57 = 1; DOWN_57 = 0; }
   if ((bears_1 < 0)) { UP_57 = 0; DOWN_57 = 1; }
   }
   
   if( display_M5 == true )
   {
   double bears_5=iBearsPower(NULL,PERIOD_M5,BEARSPeriod,BEARSPrice,i);
   if ((bears_5 > 0)) { UP_58 = 1; DOWN_58 = 0; }
   if ((bears_5 < 0)) { UP_58 = 0; DOWN_58 = 1; }
   }
   
   if( display_M15 == true )
   {
   double bears_15=iBearsPower(NULL,PERIOD_M15,BEARSPeriod,BEARSPrice,i);
   if ((bears_15 > 0)) { UP_59 = 1; DOWN_59 = 0; }
   if ((bears_15 < 0)) { UP_59 = 0; DOWN_59 = 1; }
   }
   
   if( display_M30 == true )
   {
   double bears_30=iBearsPower(NULL,PERIOD_M30,BEARSPeriod,BEARSPrice,i);
   if ((bears_30 > 0)) { UP_60 = 1; DOWN_60 = 0; }
   if ((bears_30 < 0)) { UP_60 = 0; DOWN_60 = 1; }
   }
   
   if( display_H1 == true )
   {
   double bears_60=iBearsPower(NULL,PERIOD_H1,BEARSPeriod,BEARSPrice,i);
   if ((bears_60 > 0)) { UP_61 = 1; DOWN_61 = 0; }
   if ((bears_60 < 0)) { UP_61 = 0; DOWN_61 = 1; }
   }
   
   if( display_H4 == true )
   {
   double bears_240=iBearsPower(NULL,PERIOD_H4,BEARSPeriod,BEARSPrice,i);
   if ((bears_240 > 0)) { UP_62 = 1; DOWN_62 = 0; }
   if ((bears_240 < 0)) { UP_62 = 0; DOWN_62 = 1; }
   }
   
   if( display_D1 == true )
   {
   double bears_1440=iBearsPower(NULL,PERIOD_D1,BEARSPeriod,BEARSPrice,i);
   if ((bears_1440 > 0)) { UP_63 = 1; DOWN_63 = 0; }
   if ((bears_1440 < 0)) { UP_63 = 0; DOWN_63 = 1; }
   }
   }
   
// Indicator (STOCH)

   if( display_STOCH == true )
   {
   if( display_M1 == true )
   {
   double stoch_m_1=iStochastic(NULL,PERIOD_M1,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_MAIN,i);
   double stoch_s_1=iStochastic(NULL,PERIOD_M1,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_SIGNAL,i);
   if (stoch_m_1 >= stoch_s_1) { UP_65 = 1; DOWN_65 = 0; }
   if (stoch_m_1 < stoch_s_1) { UP_65 = 0; DOWN_65 = 1; }
   }
   
   if( display_M5 == true )
   {
   double stoch_m_5=iStochastic(NULL,PERIOD_M5,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_MAIN,i);
   double stoch_s_5=iStochastic(NULL,PERIOD_M5,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_SIGNAL,i);
   if (stoch_m_5 >= stoch_s_5) { UP_66 = 1; DOWN_66 = 0; }
   if (stoch_m_5 < stoch_s_5) { UP_66 = 0; DOWN_66 = 1; }
   }
   
   if( display_M15 == true )
   {
   double stoch_m_15=iStochastic(NULL,PERIOD_M15,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_MAIN,i);
   double stoch_s_15=iStochastic(NULL,PERIOD_M15,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_SIGNAL,i);
   if (stoch_m_15 >= stoch_s_15) { UP_67 = 1; DOWN_67 = 0; }
   if (stoch_m_15 < stoch_s_15) { UP_67 = 0; DOWN_67 = 1; }
   }
   
   if( display_M30 == true )
   {
   double stoch_m_30=iStochastic(NULL,PERIOD_M30,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_MAIN,i);
   double stoch_s_30=iStochastic(NULL,PERIOD_M30,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_SIGNAL,i);
   if (stoch_m_30 >= stoch_s_30) { UP_68 = 1; DOWN_68 = 0; }
   if (stoch_m_30 < stoch_s_30) { UP_68 = 0; DOWN_68 = 1; }
   }
   
   if( display_H1 == true )
   {
   double stoch_m_60=iStochastic(NULL,PERIOD_H1,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_MAIN,i);
   double stoch_s_60=iStochastic(NULL,PERIOD_H1,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_SIGNAL,i);
   if (stoch_m_60 >= stoch_s_60) { UP_69 = 1; DOWN_69 = 0; }
   if (stoch_m_60 < stoch_s_60) { UP_69 = 0; DOWN_69 = 1; }
   }
   
   if( display_H4 == true )
   {
   double stoch_m_240=iStochastic(NULL,PERIOD_H4,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_MAIN,i);
   double stoch_s_240=iStochastic(NULL,PERIOD_H4,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_SIGNAL,i);
   if (stoch_m_240 >= stoch_s_240) { UP_70 = 1; DOWN_70 = 0; }
   if (stoch_m_240 < stoch_s_240) { UP_70 = 0; DOWN_70 = 1; }
   }
   
   if( display_D1 == true )
   {
   double stoch_m_1440=iStochastic(NULL,PERIOD_D1,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_MAIN,i);
   double stoch_s_1440=iStochastic(NULL,PERIOD_D1,STOKPeriod,STODPeriod,STOSlowing,MODE_SMA,1,MODE_SIGNAL,i);
   if (stoch_m_1440 >= stoch_s_1440) { UP_71 = 1; DOWN_71 = 0; }
   if (stoch_m_1440 < stoch_s_1440) { UP_71 = 0; DOWN_71 = 1; }
   }
   }
   
// Indicator (RSI)
   
   if( display_RSI == true )
   {
   if( display_M1 == true )
   {
   double rsi_1=iRSI(NULL,PERIOD_M1,RSIPeriod,PRICE_CLOSE,i);
   if (rsi_1 >= 50) { UP_73 = 1; DOWN_73 = 0; }
   if (rsi_1 < 50) { UP_73 = 0; DOWN_73 = 1; }
   }
   
   if( display_M5 == true )
   {
   double rsi_5=iRSI(NULL,PERIOD_M5,RSIPeriod,PRICE_CLOSE,i);
   if (rsi_5 >= 50) { UP_74 = 1; DOWN_74 = 0; }
   if (rsi_5 < 50) { UP_74 = 0; DOWN_74 = 1; }
   }
   
   if( display_M15 == true )
   {
   double rsi_15=iRSI(NULL,PERIOD_M15,RSIPeriod,PRICE_CLOSE,i);
   if (rsi_15 >= 50) { UP_75 = 1; DOWN_75 = 0; }
   if (rsi_15 < 50) { UP_75 = 0; DOWN_75 = 1; }
   }
   
   if( display_M30 == true )
   {
   double rsi_30=iRSI(NULL,PERIOD_M30,RSIPeriod,PRICE_CLOSE,i);
   if (rsi_30 >= 50) { UP_76 = 1; DOWN_76 = 0; }
   if (rsi_30 < 50) { UP_76 = 0; DOWN_76 = 1; }
   }
   
   if( display_H1 == true )
   {
   double rsi_60=iRSI(NULL,PERIOD_H1,RSIPeriod,PRICE_CLOSE,i);
   if (rsi_60 >= 50) { UP_77 = 1; DOWN_77 = 0; }
   if (rsi_60 < 50) { UP_77 = 0; DOWN_77 = 1; }
   }
   
   if( display_H4 == true )
   {
   double rsi_240=iRSI(NULL,PERIOD_H4,RSIPeriod,PRICE_CLOSE,i);
   if (rsi_240 >= 50) { UP_78 = 1; DOWN_78 = 0; }
   if (rsi_240 < 50) { UP_78 = 0; DOWN_78 = 1; }
   }
   
   if( display_D1 == true )
   {
   double rsi_1440=iRSI(NULL,PERIOD_D1,RSIPeriod,PRICE_CLOSE,i);
   if (rsi_1440 >= 50) { UP_79 = 1; DOWN_79 = 0; }
   if (rsi_1440 < 50) { UP_79 = 0; DOWN_79 = 1; }
   }
   }
   
// Indicator (FORCE INDEX)
   
   if( display_FORCE == true )
   {
   if( display_M1 == true )
   {
   double fi_1=iForce(NULL,PERIOD_M1,FIPeriod,FIMethod,FIPrice,i);
   if (fi_1 >= 0) { UP_81 = 1; DOWN_81 = 0; }
   if (fi_1 < 0) { UP_81 = 0; DOWN_81 = 1; }
   }
   
   if( display_M5 == true )
   {
   double fi_5=iForce(NULL,PERIOD_M5,FIPeriod,FIMethod,FIPrice,i);
   if (fi_5 >= 0) { UP_82 = 1; DOWN_82 = 0; }
   if (fi_5 < 0) { UP_82 = 0; DOWN_82 = 1; }
   }
   
   if( display_M15 == true )
   {
   double fi_15=iForce(NULL,PERIOD_M15,FIPeriod,FIMethod,FIPrice,i);
   if (fi_15 >= 0) { UP_83 = 1; DOWN_83 = 0; }
   if (fi_15 < 0) { UP_83 = 0; DOWN_83 = 1; }
   }
   
   if( display_M30 == true )
   {
   double fi_30=iForce(NULL,PERIOD_M30,FIPeriod,FIMethod,FIPrice,i);
   if (fi_30 >= 0) { UP_84 = 1; DOWN_84 = 0; }
   if (fi_30 < 0) { UP_84 = 0; DOWN_84 = 1; }
   }
   
   if( display_H1 == true )
   {
   double fi_60=iForce(NULL,PERIOD_H1,FIPeriod,FIMethod,FIPrice,i);
   if (fi_60 >= 0) { UP_85 = 1; DOWN_85 = 0; }
   if (fi_60 < 0) { UP_85 = 0; DOWN_85 = 1; }
   }
   
   if( display_H4 == true )
   {
   double fi_240=iForce(NULL,PERIOD_H4,FIPeriod,FIMethod,FIPrice,i);
   if (fi_240 >= 0) { UP_86 = 1; DOWN_86 = 0; }
   if (fi_240 < 0) { UP_86 = 0; DOWN_86 = 1; }
   }
   
   if( display_D1 == true )
   {
   double fi_1440=iForce(NULL,PERIOD_D1,FIPeriod,FIMethod,FIPrice,i);
   if (fi_1440 >= 0) { UP_87 = 1; DOWN_87 = 0; }
   if (fi_1440 < 0) { UP_87 = 0; DOWN_87 = 1; }
   }
   }
   
// Indicator (MOMENTUM)
   
   if( display_MOMENTUM == true )
   {
   if( display_M1 == true )
   {
   double momentum_1=iMomentum(NULL,PERIOD_M1,MOMPeriod,MOMPrice,i);
   if (momentum_1 >= 100) { UP_89 = 1; DOWN_89 = 0; }
   if (momentum_1 < 100) { UP_89 = 0; DOWN_89 = 1; }
   }
   
   if( display_M5 == true )
   {
   double momentum_5=iMomentum(NULL,PERIOD_M5,MOMPeriod,MOMPrice,i);
   if (momentum_5 >= 100) { UP_90 = 1; DOWN_90 = 0; }
   if (momentum_5 < 100) { UP_90 = 0; DOWN_90 = 1; }
   }
   
   if( display_M15 == true )
   {
   double momentum_15=iMomentum(NULL,PERIOD_M15,MOMPeriod,MOMPrice,i);
   if (momentum_15 >= 100) { UP_91 = 1; DOWN_91 = 0; }
   if (momentum_15 < 100) { UP_91 = 0; DOWN_91 = 1; }
   }
   
   if( display_M30 == true )
   {
   double momentum_30=iMomentum(NULL,PERIOD_M30,MOMPeriod,MOMPrice,i);
   if (momentum_30 >= 100) { UP_92 = 1; DOWN_92 = 0; }
   if (momentum_30 < 100) { UP_92 = 0; DOWN_92 = 1; }
   }
   
   if( display_H1 == true )
   {
   double momentum_60=iMomentum(NULL,PERIOD_H1,MOMPeriod,MOMPrice,i);
   if (momentum_60 >= 100) { UP_93 = 1; DOWN_93 = 0; }
   if (momentum_60 < 100) { UP_93 = 0; DOWN_93 = 1; }
   }
   
   if( display_H4 == true )
   {
   double momentum_240=iMomentum(NULL,PERIOD_H4,MOMPeriod,MOMPrice,i);
   if (momentum_240 >= 100) { UP_94 = 1; DOWN_94 = 0; }
   if (momentum_240 < 100) { UP_94 = 0; DOWN_94 = 1; }
   }
   
   if( display_D1 == true )
   {
   double momentum_1440=iMomentum(NULL,PERIOD_D1,MOMPeriod,MOMPrice,i);
   if (momentum_1440 >= 100) { UP_95 = 1; DOWN_95 = 0; }
   if (momentum_1440 < 100) { UP_95 = 0; DOWN_95 = 1; }
   }
   }
   
// Indicator (DE MARKER)
   
   
   if( display_DeMARKER == true )
   {
   if( display_M1 == true )
   {
   double demarker_1_0=iDeMarker(NULL,PERIOD_M1,DEMPeriod,i);
   double demarker_1_1=iDeMarker(NULL,PERIOD_M1,DEMPeriod,i+1);
   if (demarker_1_0 >= demarker_1_1) { UP_97 = 1; DOWN_97 = 0; }
   if (demarker_1_0 < demarker_1_1) { UP_97 = 0; DOWN_97 = 1; }
   }
   
   if( display_M5 == true )
   {
   double demarker_5_0=iDeMarker(NULL,PERIOD_M5,DEMPeriod,i);
   double demarker_5_1=iDeMarker(NULL,PERIOD_M5,DEMPeriod,i+1);
   if (demarker_5_0 >= demarker_5_1) { UP_98 = 1; DOWN_98 = 0; }
   if (demarker_5_0 < demarker_5_1) { UP_98 = 0; DOWN_98 = 1; }
   }
   
   if( display_M15 == true )
   {
   double demarker_15_0=iDeMarker(NULL,PERIOD_M15,DEMPeriod,i);
   double demarker_15_1=iDeMarker(NULL,PERIOD_M15,DEMPeriod,i+1);
   if (demarker_15_0 >= demarker_15_1) { UP_99 = 1; DOWN_99 = 0; }
   if (demarker_15_0 < demarker_15_1) { UP_99 = 0; DOWN_99 = 1; }
   }
   
   if( display_M30 == true )
   {
   double demarker_30_0=iDeMarker(NULL,PERIOD_M30,DEMPeriod,i);
   double demarker_30_1=iDeMarker(NULL,PERIOD_M30,DEMPeriod,i+1);
   if (demarker_30_0 >= demarker_30_1) { UP_100 = 1; DOWN_100 = 0; }
   if (demarker_30_0 < demarker_30_1) { UP_100 = 0; DOWN_100 = 1; }
   }
   
   if( display_H1 == true )
   {
   double demarker_60_0=iDeMarker(NULL,PERIOD_H1,DEMPeriod,i);
   double demarker_60_1=iDeMarker(NULL,PERIOD_H1,DEMPeriod,i+1);
   if (demarker_60_0 >= demarker_60_1) { UP_101 = 1; DOWN_101 = 0; }
   if (demarker_60_0 < demarker_60_1) { UP_101 = 0; DOWN_101 = 1; }
   }
   
   if( display_H4 == true )
   {
   double demarker_240_0=iDeMarker(NULL,PERIOD_H4,DEMPeriod,i);
   double demarker_240_1=iDeMarker(NULL,PERIOD_H4,DEMPeriod,i+1);
   if (demarker_240_0 >= demarker_240_1) { UP_102 = 1; DOWN_102 = 0; }
   if (demarker_240_0 < demarker_240_1) { UP_102 = 0; DOWN_102 = 1; }
   }
   
   if( display_D1 == true )
   {
   double demarker_1440_0=iDeMarker(NULL,PERIOD_D1,DEMPeriod,i);
   double demarker_1440_1=iDeMarker(NULL,PERIOD_D1,DEMPeriod,i+1);
   if (demarker_1440_0 >= demarker_1440_1) { UP_103 = 1; DOWN_103 = 0; }
   if (demarker_1440_0 < demarker_1440_1) { UP_103 = 0; DOWN_103 = 1; }
   }
   }
   
// Indicator (Waddah Attar Explosion)
   
   if( display_WAE == true )
   {
   if( display_M1 == true )
   {
   double wae_histo_up_1_0 = iCustom(NULL,PERIOD_M1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,i);
   double wae_histo_up_1_1 = iCustom(NULL,PERIOD_M1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,i+1);
   double wae_histo_down_1_0 = iCustom(NULL,PERIOD_M1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,i);
   double wae_histo_down_1_1 = iCustom(NULL,PERIOD_M1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,i+1);
   if (wae_histo_up_1_0 > wae_histo_up_1_1 || wae_histo_down_1_0 < wae_histo_down_1_1) { UP_105 = 1; DOWN_105 = 0; }
   if (wae_histo_up_1_0 < wae_histo_up_1_1 || wae_histo_down_1_0 > wae_histo_down_1_1) { UP_105 = 0; DOWN_105 = 1; }
   }
   
   if( display_M5 == true )
   {
   double wae_histo_up_5_0 = iCustom(NULL,PERIOD_M5,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,i);
   double wae_histo_up_5_1 = iCustom(NULL,PERIOD_M5,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,i+1);
   double wae_histo_down_5_0 = iCustom(NULL,PERIOD_M5,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,i);
   double wae_histo_down_5_1 = iCustom(NULL,PERIOD_M5,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,i+1);
   if (wae_histo_up_5_0 > wae_histo_up_5_1 || wae_histo_down_5_0 < wae_histo_down_5_1) { UP_106 = 1; DOWN_106 = 0; }
   if (wae_histo_up_5_0 < wae_histo_up_5_1 || wae_histo_down_5_0 > wae_histo_down_5_1) { UP_106 = 0; DOWN_106 = 1; }
   }
   
   if( display_M15 == true )
   {
   double wae_histo_up_15_0 = iCustom(NULL,PERIOD_M15,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,i);
   double wae_histo_up_15_1 = iCustom(NULL,PERIOD_M15,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,i+1);
   double wae_histo_down_15_0 = iCustom(NULL,PERIOD_M15,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,i);
   double wae_histo_down_15_1 = iCustom(NULL,PERIOD_M15,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,i+1);
   if (wae_histo_up_15_0 > wae_histo_up_15_1 || wae_histo_down_15_0 < wae_histo_down_15_1) { UP_107 = 1; DOWN_107 = 0; }
   if (wae_histo_up_15_0 < wae_histo_up_15_1 || wae_histo_down_15_0 > wae_histo_down_15_1) { UP_107 = 0; DOWN_107 = 1; }
   }
   
   if( display_M30 == true )
   {
   double wae_histo_up_30_0 = iCustom(NULL,PERIOD_M30,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,i);
   double wae_histo_up_30_1 = iCustom(NULL,PERIOD_M30,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,i+1);
   double wae_histo_down_30_0 = iCustom(NULL,PERIOD_M30,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,i);
   double wae_histo_down_30_1 = iCustom(NULL,PERIOD_M30,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,i+1);
   if (wae_histo_up_30_0 > wae_histo_up_30_1 || wae_histo_down_30_0 < wae_histo_down_30_1) { UP_108 = 1; DOWN_108 = 0; }
   if (wae_histo_up_30_0 < wae_histo_up_30_1 || wae_histo_down_30_0 > wae_histo_down_30_1) { UP_108 = 0; DOWN_108 = 1; }
   }
   
   if( display_H1 == true )
   {
   double wae_histo_up_60_0 = iCustom(NULL,PERIOD_H1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,i);
   double wae_histo_up_60_1 = iCustom(NULL,PERIOD_H1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,i+1);
   double wae_histo_down_60_0 = iCustom(NULL,PERIOD_H1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,i);
   double wae_histo_down_60_1 = iCustom(NULL,PERIOD_H1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,i+1);
   if (wae_histo_up_60_0 > wae_histo_up_60_1 || wae_histo_down_60_0 < wae_histo_down_60_1) { UP_109 = 1; DOWN_109 = 0; }
   if (wae_histo_up_60_0 < wae_histo_up_60_1 || wae_histo_down_60_0 > wae_histo_down_60_1) { UP_109 = 0; DOWN_109 = 1; }
   }
   
   if( display_H4 == true )
   {
   double wae_histo_up_240_0 = iCustom(NULL,PERIOD_H4,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,i);
   double wae_histo_up_240_1 = iCustom(NULL,PERIOD_H4,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,i+1);
   double wae_histo_down_240_0 = iCustom(NULL,PERIOD_H4,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,i);
   double wae_histo_down_240_1 = iCustom(NULL,PERIOD_H4,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,i+1);
   if (wae_histo_up_240_0 > wae_histo_up_240_1 || wae_histo_down_240_0 < wae_histo_down_240_1) { UP_110 = 1; DOWN_110 = 0; }
   if (wae_histo_up_240_0 < wae_histo_up_240_1 || wae_histo_down_240_0 > wae_histo_down_240_1) { UP_110 = 0; DOWN_110 = 1; }
   }
   
   if( display_D1 == true )
   {
   double wae_histo_up_1440_0 = iCustom(NULL,PERIOD_D1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,i);
   double wae_histo_up_1440_1 = iCustom(NULL,PERIOD_D1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,0,i+1);
   double wae_histo_down_1440_0 = iCustom(NULL,PERIOD_D1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,i);
   double wae_histo_down_1440_1 = iCustom(NULL,PERIOD_D1,"Waddah_Attar_Explosion",150,30,15,15,false,1,true,true,true,true,1,i+1);
   if (wae_histo_up_1440_0 > wae_histo_up_1440_1 || wae_histo_down_1440_0 < wae_histo_down_1440_1) { UP_111 = 1; DOWN_111 = 0; }
   if (wae_histo_up_1440_0 < wae_histo_up_1440_1 || wae_histo_down_1440_0 > wae_histo_down_1440_1) { UP_111 = 0; DOWN_111 = 1; }
   }
   }

//---- Count Indicators

   double Indy_count = UP_1 + UP_9 + UP_17 + UP_25 + UP_33 + UP_41 + UP_49 + UP_57 + UP_65 + UP_73 + UP_81 + UP_89 + UP_97 + UP_105
                     + UP_2 + UP_10 + UP_18 + UP_26 + UP_34 + UP_42 + UP_50 + UP_58 + UP_66 + UP_74 + UP_82 + UP_90 + UP_98 + UP_106
                     + UP_3 + UP_11 + UP_19 + UP_27 + UP_35 + UP_43 + UP_51 + UP_59 + UP_67 + UP_75 + UP_83 + UP_91 + UP_99 + UP_107
                     + UP_4 + UP_12 + UP_20 + UP_28 + UP_36 + UP_44 + UP_52 + UP_60 + UP_68 + UP_76 + UP_84 + UP_92 + UP_100 + UP_108
                     + UP_5 + UP_13 + UP_21 + UP_29 + UP_37 + UP_45 + UP_53 + UP_61 + UP_69 + UP_77 + UP_85 + UP_93 + UP_101 + UP_109
                     + UP_6 + UP_14 + UP_22 + UP_30 + UP_38 + UP_46 + UP_54 + UP_62 + UP_70 + UP_78 + UP_86 + UP_94 + UP_102 + UP_110
                     + UP_7 + UP_15 + UP_23 + UP_31 + UP_39 + UP_47 + UP_55 + UP_63 + UP_71 + UP_79 + UP_87 + UP_95 + UP_103 + UP_111
                     + DOWN_1 + DOWN_9 + DOWN_17 + DOWN_25 + DOWN_33 + DOWN_41 + DOWN_49 + DOWN_57 + DOWN_65 + DOWN_73 + DOWN_81 + DOWN_89 + DOWN_97 + DOWN_105
                     + DOWN_2 + DOWN_10 + DOWN_18 + DOWN_26 + DOWN_34 + DOWN_42 + DOWN_50 + DOWN_58 + DOWN_66 + DOWN_74 + DOWN_82 + DOWN_90 + DOWN_98 + DOWN_106
                     + DOWN_3 + DOWN_11 + DOWN_19 + DOWN_27 + DOWN_35 + DOWN_43 + DOWN_51 + DOWN_59 + DOWN_67 + DOWN_75 + DOWN_83 + DOWN_91 + DOWN_99 + DOWN_107
                     + DOWN_4 + DOWN_12 + DOWN_20 + DOWN_28 + DOWN_36 + DOWN_44 + DOWN_52 + DOWN_60 + DOWN_68 + DOWN_76 + DOWN_84 + DOWN_92 + DOWN_100 + DOWN_108
                     + DOWN_5 + DOWN_13 + DOWN_21 + DOWN_29 + DOWN_37 + DOWN_45 + DOWN_53 + DOWN_61 + DOWN_69 + DOWN_77 + DOWN_85 + DOWN_93 + DOWN_101 + DOWN_109
                     + DOWN_6 + DOWN_14 + DOWN_22 + DOWN_30 + DOWN_38 + DOWN_46 + DOWN_54 + DOWN_62 + DOWN_70 + DOWN_78 + DOWN_86 + DOWN_94 + DOWN_102 + DOWN_110
                     + DOWN_7 + DOWN_15 + DOWN_23 + DOWN_31 + DOWN_39 + DOWN_47 + DOWN_55 + DOWN_63 + DOWN_71 + DOWN_79 + DOWN_87 + DOWN_95 + DOWN_103 + DOWN_111;
                       
//---- Calculation of the trend. Let's give TFs more "force"
   
   double UP_m1 = (UP_1 + UP_9 + UP_17 + UP_25 + UP_33 + UP_41 + UP_49 + UP_57 + UP_65 + UP_73 + UP_81 + UP_89 + UP_97 + UP_105) * coef_m1;
   double UP_m5 = (UP_2 + UP_10 + UP_18 + UP_26 + UP_34 + UP_42 + UP_50 + UP_58 + UP_66 + UP_74 + UP_82 + UP_90 + UP_98 + UP_106) * coef_m5;
   double UP_m15 = (UP_3 + UP_11 + UP_19 + UP_27 + UP_35 + UP_43 + UP_51 + UP_59 + UP_67 + UP_75 + UP_83 + UP_91 + UP_99 + UP_107) * coef_m15;
   double UP_m30 = (UP_4 + UP_12 + UP_20 + UP_28 + UP_36 + UP_44 + UP_52 + UP_60 + UP_68 + UP_76 + UP_84 + UP_92 + UP_100 + UP_108) * coef_m30;
   double UP_H1 = (UP_5 + UP_13 + UP_21 + UP_29 + UP_37 + UP_45 + UP_53 + UP_61 + UP_69 + UP_77 + UP_85 + UP_93 + UP_101 + UP_109) * coef_H1;
   double UP_H4 = (UP_6 + UP_14 + UP_22 + UP_30 + UP_38 + UP_46 + UP_54 + UP_62 + UP_70 + UP_78 + UP_86 + UP_94 + UP_102 + UP_110) * coef_H4;
   double UP_D1 = (UP_7 + UP_15 + UP_23 + UP_31 + UP_39 + UP_47 + UP_55 + UP_63 + UP_71 + UP_79 + UP_87 + UP_95 + UP_103 + UP_111) * coef_D1;
   
   double TrendUP = UP_m1 + UP_m5 + UP_m15 + UP_m30 + UP_H1 + UP_H4 + UP_D1;
   
   double DOWN_m1 = (DOWN_1 + DOWN_9 + DOWN_17 + DOWN_25 + DOWN_33 + DOWN_41 + DOWN_49 + DOWN_57 + DOWN_65 + DOWN_73 + DOWN_81 + DOWN_89 + DOWN_97 + DOWN_105) * coef_m1;
   double DOWN_m5 = (DOWN_2 + DOWN_10 + DOWN_18 + DOWN_26 + DOWN_34 + DOWN_42 + DOWN_50 + DOWN_58 + DOWN_66 + DOWN_74 + DOWN_82 + DOWN_90 + DOWN_98 + DOWN_106) * coef_m5;
   double DOWN_m15 = (DOWN_3 + DOWN_11 + DOWN_19 + DOWN_27 + DOWN_35 + DOWN_43 + DOWN_51 + DOWN_59 + DOWN_67 + DOWN_75 + DOWN_83 + DOWN_91 + DOWN_99 + DOWN_107) * coef_m15;
   double DOWN_m30 = (DOWN_4 + DOWN_12 + DOWN_20 + DOWN_28 + DOWN_36 + DOWN_44 + DOWN_52 + DOWN_60 + DOWN_68 + DOWN_76 + DOWN_84 + DOWN_92 + DOWN_100 + DOWN_108) * coef_m30;
   double DOWN_H1 = (DOWN_5 + DOWN_13 + DOWN_21 + DOWN_29 + DOWN_37 + DOWN_45 + DOWN_53 + DOWN_61 + DOWN_69 + DOWN_77 + DOWN_85 + DOWN_93 + DOWN_101 + DOWN_109) * coef_H1;
   double DOWN_H4 = (DOWN_6 + DOWN_14 + DOWN_22 + DOWN_30 + DOWN_38 + DOWN_46 + DOWN_54 + DOWN_62 + DOWN_70 + DOWN_78 + DOWN_86 + DOWN_94 + DOWN_102 + DOWN_110) * coef_H4;
   double DOWN_D1 = (DOWN_7 + DOWN_15 + DOWN_23 + DOWN_31 + DOWN_39 + DOWN_47 + DOWN_55 + DOWN_63 + DOWN_71 + DOWN_79 + DOWN_87 + DOWN_95 + DOWN_103 + DOWN_111) * coef_D1;
   
   double TrendDOWN = DOWN_m1 + DOWN_m5 + DOWN_m15 + DOWN_m30 + DOWN_H1 + DOWN_H4 + DOWN_D1;
   
   if(((TrendUP/Indy_count)*100) >= 50) { UPBuffer[i] = (TrendUP/Indy_count)*100; DOWNBuffer[i]=0; }
   if(((TrendUP/Indy_count)*100) < 50) { UPBuffer[i]=0; DOWNBuffer[i] = 100-((TrendUP/Indy_count)*100); }
   
   
  }   //---- for
   
 

   
      
   return(0);
  }