//+------------------------------------------------------------------+
//|            MTF_AMA_SLOPE_v24_3x3                   AMA SLOPE.mq4 |
//|            2007   forexTSD.com                    2006   Kalenzo |
//|                                     bartlomiej.gorski@gmail.com  |
//| I used the idea of P.Kauffman and code from KAMA             idk |
//| made by  2004, by konKop,wellx                                  |
//+------------------------------------------------------------------+
#property copyright "Kalenzo"
#property link      "bartlomiej.gorski@gmail.com"

#property indicator_separate_window
#property indicator_buffers 8
#property indicator_color1 Green
#property indicator_color2 Red
#property indicator_color3 Maroon
#property indicator_color4 DarkGreen
#property indicator_color5 Maroon
#property indicator_color6 DarkGreen
#property indicator_color7 Brown
#property indicator_color8 Gold


#property indicator_width1 1
#property indicator_width2 1
#property indicator_width3 2
#property indicator_width4 2
#property indicator_width7 3
#property indicator_width8 1
#property indicator_level1 0.001
#property indicator_level2 -0.001
#property indicator_levelcolor DarkSlateGray

//---- input parameters
extern int TimeFrame = 60;
extern int TimeFrame1 = 240;
extern int TimeFrame2 = 0;
extern int       periodAMA=9;
extern int       nfast=2;
extern int       nslow=30;
extern double    G=2.0;
extern int       trigger = 2;
extern color     triggerPlus = Maroon;
extern color     triggerMinus = DarkGreen;
//---- buffers
//double kAMAbuffer[];
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[]; 
double ExtMapBuffer5[];
double ExtMapBuffer6[]; 
double ExtMapBuffer7[]; 
double ExtMapBuffer8[]; 
//+------------------------------------------------------------------+
//int    cbars=0, prevbars=0, prevtime=0;
//double slowSC,fastSC;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexLabel(0,"AMA_Sl["+TimeFrame+"]("+periodAMA+")("+nfast+","+nslow+")");
//---- indicators
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,ExtMapBuffer2);
   
   SetIndexStyle(2,DRAW_HISTOGRAM);
   SetIndexBuffer(2,ExtMapBuffer3);
   SetIndexStyle(3,DRAW_HISTOGRAM);
   SetIndexBuffer(3,ExtMapBuffer4);
//  drawLine((trigger*Point),"Trigger+", triggerPlus);
//  drawLine((-trigger*Point),"Trigger-", triggerMinus);
//SetLevelValue(0,(trigger*Point));
//SetLevelValue(1,(-trigger*Point));
//SetLevelStyle(0,0,triggerPlus);
//SetLevelStyle(1,0,triggerMinus);
   SetIndexStyle(4,DRAW_LINE,4,0,triggerMinus);
   SetIndexBuffer(4,ExtMapBuffer5);
   SetIndexStyle(5,DRAW_LINE,4,0,triggerPlus);
   SetIndexBuffer(5,ExtMapBuffer6);
   SetIndexStyle(6,DRAW_LINE);
   SetIndexBuffer(6,ExtMapBuffer7);
   SetIndexLabel(6,"AMA_Sl["+TimeFrame1+"]("+periodAMA+")("+nfast+","+nslow+")");
    SetIndexStyle(7,DRAW_LINE);
   SetIndexBuffer(7,ExtMapBuffer8);
   SetIndexLabel(7,"AMA_Sl["+TimeFrame2+"]("+periodAMA+")("+nfast+","+nslow+")");

 
 //  drawLine(trigger,"BuyTrigger", Red);
 //  drawLine(-trigger,"SellTrigger", Red);
//   IndicatorDigits(4);
//   IndicatorShortName("MTF_AMA_Slope_v2");
//   return(0);
//  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
//---- name for DataWindow and indicator subwindow label
   switch(TimeFrame)
   {
      case 1 : string TimeFrameStr="Period_M1"; break;
      case 5 : TimeFrameStr="Period_M5"; break;
      case 15 : TimeFrameStr="Period_M15"; break;
      case 30 : TimeFrameStr="Period_M30"; break;
      case 60 : TimeFrameStr="Period_H1"; break;
      case 240 : TimeFrameStr="Period_H4"; break;
      case 1440 : TimeFrameStr="Period_D1"; break;
      case 10080 : TimeFrameStr="Period_W1"; break;
      case 43200 : TimeFrameStr="Period_MN1"; break;
      default : TimeFrameStr="Current Timeframe";
   } 
   
IndicatorShortName("MTF_AMA_Slope[["+TimeFrame+"]["+TimeFrame1+"]["+TimeFrame2+"]]("+periodAMA+")("+nfast+","+nslow+")");   

//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Calculations                                                |
//+------------------------------------------------------------------+
int start()
  {
    datetime TimeArray[],TimeArray1[],TimeArray2[];
    int    i,shift,limit,y=0,y1=0,y2=0,counted_bars=IndicatorCounted();
   
// Plot defined timeframe on to current timeframe   
   ArrayCopySeries(TimeArray,MODE_TIME,Symbol(),TimeFrame); 
      ArrayCopySeries(TimeArray1,MODE_TIME,Symbol(),TimeFrame1); 
      ArrayCopySeries(TimeArray2,MODE_TIME,Symbol(),TimeFrame2); 

   limit=Bars-counted_bars+TimeFrame/Period();
    limit=Bars-counted_bars+TimeFrame1/Period();
    limit=Bars-counted_bars+TimeFrame2/Period();

   for(i=0,y=0,y1=0,y2=0;i<limit;i++)
   {
   if (Time[i]<TimeArray[y]) y++;  
   if (Time[i]<TimeArray1[y1]) y1++; 
    if (Time[i]<TimeArray2[y2]) y2++; 
    if (TimeFrame<Period()) TimeFrame=Period();
    if (TimeFrame1<Period())TimeFrame1=Period();
   if (TimeFrame2<Period())TimeFrame2=Period();

//---- main loop
    ExtMapBuffer1[i]=iCustom(NULL,TimeFrame,"AMA_SLOPE_v2",periodAMA,nfast,nslow,G, 0,y);
    ExtMapBuffer2[i]=iCustom(NULL,TimeFrame,"AMA_SLOPE_v2",periodAMA,nfast,nslow,G, 1,y);
    ExtMapBuffer3[i]=iCustom(NULL,TimeFrame,"AMA_SLOPE_v2",periodAMA,nfast,nslow,G, 2,y);
    ExtMapBuffer4[i]=iCustom(NULL,TimeFrame,"AMA_SLOPE_v2",periodAMA,nfast,nslow,G, 3,y);
    ExtMapBuffer7[i]=iCustom(NULL,TimeFrame1,"AMA_SLOPE_v2",periodAMA,nfast,nslow,G, 0,y1);
    ExtMapBuffer8[i]=iCustom(NULL,TimeFrame2,"AMA_SLOPE_v2",periodAMA,nfast,nslow,G, 0,y2);
    ExtMapBuffer5[i]= trigger*Point;
    ExtMapBuffer6[i]= -trigger*Point;

}
  // Refresh buffers
//++++++++++++++++++++++++++++++++++++++   upgrade by Raff 
   if (TimeFrame>Period()) {
     int PerINT=TimeFrame/Period()+1;
     datetime TimeArr[]; ArrayResize(TimeArr,PerINT);
     ArrayCopySeries(TimeArr,MODE_TIME,Symbol(),Period()); 
     for(i=0;i<PerINT+1;i++) {if (TimeArr[i]>=TimeArray[0]) {
//----
 /******************************************************** 
    Refresh buffers:         buffer[i] = buffer[0];
 ********************************************************/  

   ExtMapBuffer1[i]=ExtMapBuffer1[0]; 
   ExtMapBuffer2[i]=ExtMapBuffer2[0]; 
   ExtMapBuffer3[i]=ExtMapBuffer3[0]; 
   ExtMapBuffer4[i]=ExtMapBuffer4[0]; 
   ExtMapBuffer5[i]=ExtMapBuffer5[0]; 
   ExtMapBuffer6[i]=ExtMapBuffer6[0]; 
    ExtMapBuffer7[i]=ExtMapBuffer7[0]; 
    ExtMapBuffer8[i]=ExtMapBuffer8[0]; 

//----
   } } }
//+++++++++++++++++++++++++++++++++++++++++++++++   Raff

//-----

return(0);
  }
//+------------------------------------------------------------------+


/*
void drawLine(double lvl,string name, color Col )
{
            ObjectDelete(name);
            ObjectCreate(name, OBJ_HLINE, WindowFind(name), Time[0], lvl,Time[0], lvl);
            ObjectSet(name, OBJPROP_STYLE, STYLE_DOT);
            ObjectSet(name, OBJPROP_COLOR, Col);        
            ObjectSet(name,OBJPROP_WIDTH,1);
}


