//-------------------------------------------------------------------
// MetaTrader4 Indicator BH-Ergodic.mq4 
// 2007, Bruce Hellstrom          | mod: forexTSD: MTF_BH_Ergodic.mq4
// bhweb@speakeasy.net
// Version:  1.0
// Version Date: 15 Apr 2007
// Last change by: bruceh
// Based on code written by Danny Feng, Ergodic.mq4
//+-------------------------------------------------------------------

#property copyright "2007 Brucehvn, bhweb@speakeasy.net"
#property link      "http: //www.metaquotes.net"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 LightSeaGreen
#property indicator_color2 Goldenrod
#property indicator_style1 0
#property indicator_style2 2
#property indicator_width1 2

//---- input parameters
extern int TimeFrame=0;

extern int BarDiff = 1;     // calculations are taken between current bar and current bar + BarDiff
extern int r = 2;           // First moving average on mean values
extern int s = 10;          // Second moving average applied to first
extern int u = 5;           // Third moving average applied to division
extern int trigger = 3;     // Final moving average or smoothing
extern int PriceType = 0;   // 0=Close, 1=Open, 2=High, 3=Low, 4=Median, 5=Typical, 6=Weighted
extern string note____TF = "1,5,15,30,60H1,240H4,1440D1,10080W1,43200MN1";
extern string _Pprice_Type = "C0,O1,H2,L3,Mdn4,Tpcl5,WghtCl_6"; 

//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];



//double ErgBuffer[];
//double ema_ErgBuffer[];
//double Price_Delta1_Buffer[];
//double Price_Delta2_Buffer[];
//double r_ema1_Buffer[];
//double r_ema2_Buffer[];
//double s_ema1_Buffer[];
//double s_ema2_Buffer[];
string ShortNameBase = "";
string IndVersion = "1.0";

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init() {
    ShortNameBase = "BH-Ergodic v" + IndVersion + " ["+TimeFrame+"](" + r + "," + s + "," + u + ") Trigger(" + trigger + ")";
    //---- additional buffers are used for counting.
    IndicatorBuffers( 8 );
    SetIndexBuffer( 0, ExtMapBuffer1 );
    SetIndexLabel( 0, "Trigger" );
    SetIndexBuffer( 1, ExtMapBuffer2 );
    SetIndexLabel( 1, "Ergodic" );
 //  SetIndexBuffer( 2, Price_Delta1_Buffer );
 //   SetIndexBuffer( 3, Price_Delta2_Buffer );
 //   SetIndexBuffer( 4, r_ema1_Buffer );
 //   SetIndexBuffer( 5, r_ema2_Buffer );
 //   SetIndexBuffer( 6, s_ema1_Buffer );
 //   SetIndexBuffer( 7, s_ema2_Buffer );

    //---- indicator lines
    SetIndexStyle( 0, DRAW_LINE );
    SetIndexStyle( 1, DRAW_LINE );
    //---- name for DataWindow and indicator subwindow label
    IndicatorShortName( ShortNameBase );
    //----
    SetIndexDrawBegin( 0, r + s + u + trigger );
    SetIndexDrawBegin( 1, r + s + u + trigger );
    //----
 //   Print( ShortNameBase );
 //   Print( "2007 - brucehvn, bhweb@speakeasy.net" );
//---- name for DataWindow and indicator subwindow label   
   switch(TimeFrame)
   {
      case 1 : string TimeFrameStr="Period_M1"; break;
      case 5 : TimeFrameStr="Period_M5"; break;
      case 15 : TimeFrameStr="Period_M15"; break;
      case 30 : TimeFrameStr="Period_M30"; break;
      case 60 : TimeFrameStr="Period_H1"; break;
      case 240 : TimeFrameStr="Period_H4"; break;
      case 1440 : TimeFrameStr="Period_D1"; break;
      case 10080 : TimeFrameStr="Period_W1"; break;
      case 43200 : TimeFrameStr="Period_MN1"; break;
      default : TimeFrameStr="Current Timeframe";
   } 
   }
    return( 0 );
//+------------------------------------------------------------------+
int start()
  {
   datetime TimeArray[];
   int    i,shift,limit,y=0,counted_bars=IndicatorCounted();
    
// Plot defined timeframe on to current timeframe   
   ArrayCopySeries(TimeArray,MODE_TIME,Symbol(),TimeFrame); 
   
   limit=Bars-counted_bars+TimeFrame/Period();
   for(i=0,y=0;i<limit;i++)
   {
   if (TimeFrame<Period()) TimeFrame=Period();
   if (Time[i]<TimeArray[y]) y++; 
   
 /***********************************************************   
   Add your main indicator loop below.  You can reference an existing
      indicator with its iName  or iCustom.
   Rule 1:  Add extern inputs above for all neccesary values   
   Rule 2:  Use 'TimeFrame' for the indicator timeframe
   Rule 3:  Use 'y' for the indicator's shift value
 **********************************************************/  
     
   ExtMapBuffer1[i]=iCustom(NULL,TimeFrame,"BH-Ergodic",BarDiff,r,s,u,trigger,PriceType,0, y);
   ExtMapBuffer2[i]=iCustom(NULL,TimeFrame,"BH-Ergodic",BarDiff,r,s,u,trigger,PriceType,1, y);

     string shortname = ShortNameBase;
    
    if ( ExtMapBuffer1[0] > ExtMapBuffer2[0] ) {
        shortname = StringConcatenate( shortname, " SHORT" );
    }
    else if ( ExtMapBuffer1[0] < ExtMapBuffer2[0] ) {
        shortname = StringConcatenate( shortname, " LONG" );
    }
    else {
        shortname = StringConcatenate( shortname, " NEUTRAL" );
    }
    IndicatorShortName( shortname );
   
   }  
//----  Refresh buffers +++++++++++++++++++++++++ upgrade by Raff  
   if (TimeFrame>Period()) {
     int PerINT=TimeFrame/Period()+1;
     datetime TimeArr[]; ArrayResize(TimeArr,PerINT);
     ArrayCopySeries(TimeArr,MODE_TIME,Symbol(),Period()); 
     for(i=0;i<PerINT+1;i++) {if (TimeArr[i]>=TimeArray[0]) {
 /********************************************************     
    Refresh buffers:         buffer[i] = buffer[0];
 ********************************************************/  

   ExtMapBuffer1[i]=ExtMapBuffer1[0];
   ExtMapBuffer2[i]=ExtMapBuffer2[0];

   } } }
//+++++++++++++++++++++++++++++++++++++++++++++   Raff 
//-----

   return(0);
  }

//+------------------------------------------------------------------+
//| True Strength Index                                        
//+------------------------------------------------------------------+


