//+------------------------------------------------------------------+
//|                                        MTF_FractalChannel_v1.mq4 |
//|                                Copyright  2006, TrendLaboratory |
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |
//|                                   E-mail: igorad2003@yahoo.co.uk |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, TrendLaboratory"
#property link      "http://finance.groups.yahoo.com/group/TrendLaboratory"

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 LightBlue
#property indicator_color2 Tomato
#property indicator_color3 Yellow
#property indicator_width1 2
#property indicator_width2 2
//---- input parameters
extern int     TimeFrame   = 0;
extern int     ChannelType = 1;
extern double  Margins     = 0;
extern int     Shift       = 0;
extern int     Mode        = 0;

//---- buffers
double UpBuffer[];
double DnBuffer[];
double MdBuffer[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   string short_name;
//---- indicator line
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexStyle(2,DRAW_LINE,2);
   SetIndexBuffer(0,UpBuffer);
   SetIndexBuffer(1,DnBuffer);
   SetIndexBuffer(2,MdBuffer);
//---- name for DataWindow and indicator subwindow label
   short_name="MTF FractalChannel("+ChannelType+")";
   IndicatorShortName(short_name);
   SetIndexLabel(0,"Up Channel");
   SetIndexLabel(1,"Down Channel");
   SetIndexLabel(2,"Middle Channel");

   SetIndexShift(0,Shift);
   SetIndexShift(1,Shift);
   SetIndexShift(2,Shift);
//----
   SetIndexDrawBegin(0,2*ChannelType);
   SetIndexDrawBegin(1,2*ChannelType);
   SetIndexDrawBegin(2,2*ChannelType);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| FractalChannel_v3.1                                                |
//+------------------------------------------------------------------+
int start()
{
   datetime TimeArray[];
   int      i,limit,y=0,counted_bars=IndicatorCounted();
 
// Plot defined time frame on to current time frame
   ArrayCopySeries(TimeArray,MODE_TIME,Symbol(),TimeFrame); 
   
   limit=Bars-counted_bars+TimeFrame/Period();
   for(i=0,y=0;i<limit;i++)
   {
   if (Time[i]<TimeArray[y]) y++;
  
	UpBuffer[i] = iCustom(NULL,TimeFrame,"FractalChannel_v4",ChannelType,Margins,Shift,Mode,0,y);  
   DnBuffer[i] = iCustom(NULL,TimeFrame,"FractalChannel_v4",ChannelType,Margins,Shift,Mode,1,y);
   MdBuffer[i] = iCustom(NULL,TimeFrame,"FractalChannel_v4",ChannelType,Margins,Shift,Mode,2,y);  
	}
return(0);
}


