//+------------------------------------------------------------------+
//| MTF_ Relative Momentum Index MTF_RMI.mq4 |
//| Copyright ? 2006, DaVinciProject |
//| fxtsd.com http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright ? 2006, DaVinciProject"
#property link "http://www.metaquotes.net"

/************************************************** ********* 
I want to take this opportunity to thank the following for this indicator 
1. DaVinciProject for coming up with the RMI indicator 
2. soul_cactus in the Bagovino thread over at Forex Factory for posting this indicator 
3. Mladen and fxbs over at Forex-TSD for helping me come out with the MTF Version

Below is my Reply to a query why I like to use RMI

You can compare RMI and RSI using the same period 
and you will see that it is much smoother and provides a better trend visual than RSI.

Thank you again to all of you
Yano125

************************************************** ********/ 
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 RoyalBlue
#property indicator_level3 85
#property indicator_level2 50
#property indicator_level1 15
#property indicator_maximum 100
#property indicator_minimum 0
//---- input parameters
extern int TimeFrame=0;
extern int RMIPeriod=5;
extern int Shift=5;
//---- buffers
double RMIBuffer[];
//double PosBuffer[];
//double NegBuffer[];

//---- input parameters
/************************************************** ***********************
PERIOD_M1 1
PERIOD_M5 5
PERIOD_M15 15
PERIOD_M30 30 
PERIOD_H1 60
PERIOD_H4 240
PERIOD_D1 1440
PERIOD_W1 10080
PERIOD_MN1 43200
You must use the numeric value of the timeframe that you want to use
when you set the TimeFrame' value with the indicator inputs.
---------------------------------------
************************************************** ************************/
//+------------------------------------------------------------------+
//| Custom indicator initialization function |
//+------------------------------------------------------------------+
int init()
{
//---- indicators
string short_name;
//---- 2 additional buffers are used for counting.
// IndicatorBuffers(3);
//// SetIndexBuffer(1,PosBuffer);
// SetIndexBuffer(2,NegBuffer);
//---- indicator line
SetIndexStyle(0,DRAW_LINE);
SetIndexBuffer(0,RMIBuffer);
SetIndexDrawBegin(0,RMIPeriod);
//----

//----
switch(TimeFrame)
{
case 1 : string TimeFrameStr="Period_M1"; break;
case 5 : TimeFrameStr="Period_M5"; break;
case 15 : TimeFrameStr="Period_M15"; break;
case 30 : TimeFrameStr="Period_M30"; break;
case 60 : TimeFrameStr="Period_H1"; break;
case 240 : TimeFrameStr="Period_H4"; break;
case 1440 : TimeFrameStr="Period_D1"; break;
case 10080 : TimeFrameStr="Period_W1"; break;
case 43200 : TimeFrameStr="Period_MN1"; break;
default : TimeFrameStr="Current Timeframe";
} 
//---- name for DataWindow and indicator subwindow label
short_name="MTF_RMI["+TimeFrameStr+"]("+RMIPeriod+")";
IndicatorShortName(short_name);
SetIndexLabel(0,short_name);

}
//----
return(0);
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function |
//+------------------------------------------------------------------+
int deinit()
{
//----

//----
return(0);
}
//+------------------------------------------------------------------+
//| MTF RMI - Relative Momentum Index |
//+------------------------------------------------------------------+
int start()
{
datetime TimeArray[];
int i,shift,limit,y=0,counted_bars=IndicatorCounted();

// Plot defined timeframe on to current timeframe 
ArrayCopySeries(TimeArray,MODE_TIME,Symbol(),TimeFrame); 

limit=Bars-counted_bars+TimeFrame/Period();
for(i=0,y=0;i<limit;i++)
{
if (Time[i]<TimeArray[y]) y++; 

/************************************************** ********* 
Add your main indicator loop below. You can reference an existing
indicator with its iName or iCustom.
Rule 1: Add extern inputs above for all neccesary values 
Rule 2: Use 'TimeFrame' for the indicator timeframe
Rule 3: Use 'y' for the indicator's shift value
************************************************** ********/ 

RMIBuffer[i]=iCustom(NULL,TimeFrame,"RMI",RMIPeriod,Shift,0,y) ; 


} 

//---- Refresh buffers +++++++++++++++++++++++++ upgrade by Raff 
if (TimeFrame>Period()) {
int PerINT=TimeFrame/Period()+1;
datetime TimeArr[]; ArrayResize(TimeArr,PerINT);
ArrayCopySeries(TimeArr,MODE_TIME,Symbol(),Period( )); 
for(i=0;i<PerINT+1;i++) {if (TimeArr[i]>=TimeArray[0]) {
/************************************************** ****** 
Refresh buffers: buffer[i] = buffer[0];
************************************************** ******/ 

RMIBuffer[i]= RMIBuffer[0];

} } }
//+++++++++++++++++++++++++++++++++++++++++++++ Raff 

//-----

return(0);
}