//+--------------------------------------------------------------------------------+
//|         MTF_ RSIOMA_v2MA(Lite)             Kalenzo       2007        fxtsd.com |
//|  Rsioma  +  MaRsioma                Copyright  2004, MetaQuotes Software Corp.|
//|  - HistLevel/Sig mod                      web: http://www.fxservice.eu       ik|
//|  Hornet    FXtsd.com                      email: bartlomiej.gorski@gmail.com   |
//+--------------------------------------------------------------------------------+
#property copyright "Copyright  www.metaquotes.net"
#property link      "http://www.forex-tsd.com"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_minimum -20
#property indicator_maximum 120

#property indicator_color1 MediumBlue
#property indicator_color2 Purple
#property indicator_width1 2   
#property indicator_width2 1

//#property indicator_level1 100
#property indicator_level1 80//76.4
#property indicator_level2 70//61.8
#property indicator_level3 50
#property indicator_level4 30//38.2
#property indicator_level5 20 //23.6
//#property indicator_level7 0
#property indicator_levelcolor  SlateGray

//---- input parameters
extern int TimeFrame=0;
extern int RSIOMA          = 14;
extern int RSIOMA_MODE     = MODE_EMA;
extern int RSIOMA_PRICE    = PRICE_CLOSE;

extern int Ma_RSIOMA       = 21,
           Ma_RSIOMA_MODE  = MODE_EMA;

extern string MA_Method  = "ModeMa(SMA0,EMA1,SmmMA2,LWMA3)";
extern string MA_Price   = "O0,C1,H2,L3,Md4Tp5Wg6)";
extern string Timeframes = "60H1,240H4,1440D1,10080W1,43200MN1";

//---- buffers

double ExtMapBuffer1[];
double ExtMapBuffer2[];

/*************************************************************************
PERIOD_M1   1
PERIOD_M5   5
PERIOD_M15  15
PERIOD_M30  30 
PERIOD_H1   60
PERIOD_H4   240
PERIOD_D1   1440
PERIOD_W1   10080
PERIOD_MN1  43200
You must use the numeric value of the timeframe that you want to use
when you set the TimeFrame' value with the indicator inputs.
---------------------------------------
MODE_SMA    0 Simple moving average, 
MODE_EMA    1 Exponential moving average, 
MODE_SMMA   2 Smoothed moving average, 
MODE_LWMA   3 Linear weighted moving average. 
You must use the numeric value of the MA Method that you want to use
when you set the 'ma_method' value with the indicator inputs.

**************************************************************************/


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   
//---- indicator line
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexStyle(0,DRAW_LINE);

   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexStyle(1,DRAW_LINE);
   
//---- name for DataWindow and indicator subwindow label   
   switch(TimeFrame)
   {
      case 1 : string TimeFrameStr="Period_M1"; break;
      case 5 : TimeFrameStr="Period_M5"; break;
      case 15 : TimeFrameStr="Period_M15"; break;
      case 30 : TimeFrameStr="Period_M30"; break;
      case 60 : TimeFrameStr="Period_H1"; break;
      case 240 : TimeFrameStr="Period_H4"; break;
      case 1440 : TimeFrameStr="Period_D1"; break;
      case 10080 : TimeFrameStr="Period_W1"; break;
      case 43200 : TimeFrameStr="Period_MN1"; break;
      default : TimeFrameStr="Current Timeframe";
   } 
   IndicatorShortName("RSIOMAv2("+RSIOMA+")("+Ma_RSIOMA+")["+TimeFrameStr+"]");  
 
   SetIndexLabel(0,"RSIOMA("+RSIOMA+")("+Ma_RSIOMA+")["+TimeFrameStr+"]");
   SetIndexLabel(1,"MaRSIOMA("+RSIOMA+")("+Ma_RSIOMA+")["+TimeFrameStr+"]");


  }
//----
   return(0);
 
//+------------------------------------------------------------------+
//| MTF                                                   |
//+------------------------------------------------------------------+
int start()
  {
   datetime TimeArray[];
   int    i,shift,limit,y=0,counted_bars=IndicatorCounted();
    
// Plot defined timeframe on to current timeframe   
   ArrayCopySeries(TimeArray,MODE_TIME,Symbol(),TimeFrame); 
   
   limit=Bars-counted_bars+TimeFrame/Period();
   for(i=0,y=0;i<limit;i++)
   {
   if (TimeFrame<Period()) TimeFrame=Period();
   if (Time[i]<TimeArray[y]) y++; 
   
 /***********************************************************   
   Add your main indicator loop below.  You can reference an existing
      indicator with its iName  or iCustom.
   Rule 1:  Add extern inputs above for all neccesary values   
   Rule 2:  Use 'TimeFrame' for the indicator timeframe
   Rule 3:  Use 'y' for the indicator's shift value
 **********************************************************/  
     
   ExtMapBuffer1[i]=iCustom(NULL,TimeFrame,"RSIOMA_v2MA",RSIOMA,RSIOMA_MODE,
                               RSIOMA_PRICE, Ma_RSIOMA, Ma_RSIOMA_MODE, 0,y);
   
   ExtMapBuffer2[i]=iCustom(NULL,TimeFrame,"RSIOMA_v2MA",RSIOMA,RSIOMA_MODE,
                               RSIOMA_PRICE, Ma_RSIOMA, Ma_RSIOMA_MODE, 1,y);

    }  
 
//----  Refresh buffers +++++++++++++++++++++++++ upgrade by Raff  
   if (TimeFrame>Period()) {
     int PerINT=TimeFrame/Period()+1;
     datetime TimeArr[]; ArrayResize(TimeArr,PerINT);
     ArrayCopySeries(TimeArr,MODE_TIME,Symbol(),Period()); 
     for(i=0;i<PerINT+1;i++) {if (TimeArr[i]>=TimeArray[0]) {
 /********************************************************     
    Refresh buffers:         buffer[i] = buffer[0];
 ********************************************************/  

   ExtMapBuffer1[i]=ExtMapBuffer1[0];
   ExtMapBuffer2[i]=ExtMapBuffer2[0];

   } } }
//+++++++++++++++++++++++++++++++++++++++++++++   Raff 

//-----
    
   return(0);
  }
//+------------------------------------------------------------------+