//+------------------------------------------------------------------+
//|                         MTF FX Sniper Ergodic CCI Trigger.mq4   |
//|                      Modified by Simba                           |                 
//|                               Louw Coetzer aka FX Sniper         |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//|                                                                  |                                          
//|                                                                  |                                          
//+------------------------------------------------------------------+
#property copyright "Copyright  2007..FX Sniper..MANKIND FREE USE..whatever FX Sniper wants"

#property indicator_separate_window
//---- indicator settings
#property indicator_buffers 2
#property indicator_color1 Blue
#property indicator_color2 Red
#property indicator_level1 0

//---- indicator parameters
extern int  TimeFrame      = 0;
extern int CountBars=5000;
//---- indicator buffers
double      ind_buffer1[];
double      ind_buffer2[];
//---- input parameters
/*************************************************************************
PERIOD_M1   1
PERIOD_M5   5
PERIOD_M15  15
PERIOD_M30  30 
PERIOD_H1   60
PERIOD_H4   240
PERIOD_D1   1440
PERIOD_W1   10080
PERIOD_MN1  43200
You must use the numeric value of the timeframe that you want to use
when you set the TimeFrame' value with the indicator inputs.
**************************************************************************/
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- drawing settings
   IndicatorBuffers(2);
//---- indicator buffers mapping
   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,2);
   SetIndexBuffer(0,ind_buffer1);
   SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID,2);
   SetIndexBuffer(1,ind_buffer2);
   

//---- name for DataWindow and indicator subwindow label   
   switch(TimeFrame)
   {
      case 1 : string TimeFrameStr="M1"; break;
      case 5 : TimeFrameStr="M5"; break;
      case 15 : TimeFrameStr="M15"; break;
      case 30 : TimeFrameStr="M30"; break;
      case 60 : TimeFrameStr="H1"; break;
      case 240 : TimeFrameStr="H4"; break;
      case 1440 : TimeFrameStr="D1"; break;
      case 10080 : TimeFrameStr="W1"; break;
      case 43200 : TimeFrameStr="MN1"; break;
      default : TimeFrameStr="";
   } 
   IndicatorShortName("MTF_FXSniper'sCCI" + TimeFrameStr + "  ");
  }
//----
   return(0);
 
int start()
  {
   datetime TimeArray[];
   int    i,shift,limit,y=0,counted_bars=IndicatorCounted();
    
// Plot defined timeframe on to current timeframe   
   ArrayCopySeries(TimeArray,MODE_TIME,Symbol(),TimeFrame); 
   
   limit=Bars-counted_bars;
   for(i=0,y=0;i<limit;i++)
   {
   if (Time[i]<TimeArray[y]) y++; 
   
 /***********************************************************   
   Add your main indicator loop below.  You can reference an existing
      indicator with its iName  or iCustom.
   Rule 1:  Add extern inputs above for all neccesary values   
   Rule 2:  Use 'TimeFrame' for the indicator timeframe
   Rule 3:  Use 'y' for the indicator's shift value
 **********************************************************/  
   ind_buffer1[i]=iCustom(NULL,TimeFrame,"FX_Sniper's_Ergodic_CCI_Trigger",0,y);
   ind_buffer2[i]=iCustom(NULL,TimeFrame,"FX_Sniper's_Ergodic_CCI_Trigger",1,y);
   }  
     

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   if (TimeFrame>Period()) {
     int PerINT=TimeFrame/Period()+1;
     datetime TimeArr[]; ArrayResize(TimeArr,PerINT);
     ArrayCopySeries(TimeArr,MODE_TIME,Symbol(),Period()); 
     for(i=0;i<PerINT+1;i++) {if (TimeArr[i]>=TimeArray[0]) {
//----
 /************************************************ by BEWATERMYFRIEND   
    Refresh buffers:         buffer[i] = buffer[0];
 ********************************************************/  
   ind_buffer1[i]=ind_buffer1[0];
   ind_buffer2[i]=ind_buffer2[0];

//----
   } } }
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++


   return(0);
  }
//+------------------------------------------------------------------+

