//+------------------------------------------------------------------+
//|                                         MTF_StepMA_3D_v3m.mq4 ik |
//|                                Copyright  2006, TrendLaboratory |
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |
//|                                   E-mail: igorad2003@yahoo.co.uk |
//|            Thanks to Nikolay Kositsin for good reversal tecnique | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, TrendLaboratory"
#property link      "http://finance.groups.yahoo.com/group/TrendLaboratory"

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 LawnGreen
#property indicator_color2 Aquamarine
#property indicator_color3 DeepSkyBlue
#property indicator_width1 2
#property indicator_width2 3
#property indicator_width3 3


//---- input parameters
extern int TimeFrame=0;
extern int     Length      = 10;    // Volty Length
extern double  Kv          =  1;    // Sensivity Factor
extern int     MA_Mode     =  0;    // Volty MA Mode : 0-SMA, 1-LWMA 
extern int     StepSizeMIN =  0;    // Minimum Step Size  (if need)
extern int     StepSizeMAX =  0;    // Maximum Step Size  (if need)
extern int     ShiftMIN    =  0; 
extern int     ShiftMID    =  1;
extern int     ShiftMAX    =  2;
//---- indicator buffers   
double LineFstBuffer[];
double LineSlwBuffer[];
double LineMidBuffer[];

//---- input parameters
/*************************************************************************
PERIOD_M1   1
PERIOD_M5   5
PERIOD_M15  15
PERIOD_M30  30 
PERIOD_H1   60
PERIOD_H4   240
PERIOD_D1   1440
PERIOD_W1   10080
PERIOD_MN1  43200
You must use the numeric value of the timeframe that you want to use
when you set the TimeFrame' value with the indicator inputs.
---------------------------------------
MODE_SMA    0 Simple moving average, 
MODE_EMA    1 Exponential moving average, 
MODE_SMMA   2 Smoothed moving average, 
MODE_LWMA   3 Linear weighted moving average. 
You must use the numeric value of the MA Method that you want to use
when you set the 'ma_method' value with the indicator inputs.

**************************************************************************/

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   
   string short_name;
//---- indicator line
   IndicatorBuffers(3);
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(0,LineFstBuffer);
   SetIndexBuffer(1,LineMidBuffer);
   SetIndexBuffer(2,LineSlwBuffer);
   
//---- name for DataWindow and indicator subwindow label
   SetIndexLabel(0,"mtfStepMA3Dfast("+Length+")tf"+TimeFrame+"");
   SetIndexLabel(1,"mtfStepMA3Dmid("+Length+")tf"+TimeFrame+"");
   SetIndexLabel(2,"mtfStepMA3Dslow("+Length+")tf"+TimeFrame+"");
 
    if(TimeFrame==0) TimeFrame = Period();
   SetIndexShift(0,ShiftMIN*TimeFrame/Period());
   SetIndexShift(1,ShiftMID*TimeFrame/Period());
   SetIndexShift(2,ShiftMAX*TimeFrame/Period());
//----
   SetIndexDrawBegin(0,Length);
   SetIndexDrawBegin(1,Length);
   SetIndexDrawBegin(2,Length);

//----
   IndicatorShortName("MTF_StepMA_3D("+Length+")tf"+TimeFrame+"");
//
   return(0);
 
  
//---- name for DataWindow and indicator subwindow label   
   switch(TimeFrame)
   {
      case 1 : string TimeFrameStr="Period_M1"; break;
      case 5 : TimeFrameStr="Period_M5"; break;
      case 15 : TimeFrameStr="Period_M15"; break;
      case 30 : TimeFrameStr="Period_M30"; break;
      case 60 : TimeFrameStr="Period_H1"; break;
      case 240 : TimeFrameStr="Period_H4"; break;
      case 1440 : TimeFrameStr="Period_D1"; break;
      case 10080 : TimeFrameStr="Period_W1"; break;
      case 43200 : TimeFrameStr="Period_MN1"; break;
      default : TimeFrameStr="Current Timeframe";
   } 
  }
//----
   return(0);
 
//+------------------------------------------------------------------+
//| MTF                                                   |
//+------------------------------------------------------------------+
int start()
  {
   datetime TimeArray[];
   int    i,shift,limit,y=0,counted_bars=IndicatorCounted();
    
// Plot defined timeframe on to current timeframe   
   ArrayCopySeries(TimeArray,MODE_TIME,Symbol(),TimeFrame); 
   
   limit=Bars-counted_bars+TimeFrame/Period();
   for(i=0,y=0;i<limit;i++)
   {
   if (Time[i]<TimeArray[y]) y++; 
   
 /***********************************************************   
   Add your main indicator loop below.  You can reference an existing
      indicator with its iName  or iCustom.
   Rule 1:  Add extern inputs above for all neccesary values   
   Rule 2:  Use 'TimeFrame' for the indicator timeframe
   Rule 3:  Use 'y' for the indicator's shift value
 **********************************************************/  
  
   LineFstBuffer[i] = iCustom(NULL,TimeFrame,"StepMA_3D_v3m",Length,Kv,MA_Mode,StepSizeMIN,StepSizeMAX,0,0,0,  0,y);
   LineMidBuffer[i] = iCustom(NULL,TimeFrame,"StepMA_3D_v3m",Length,Kv,MA_Mode,StepSizeMIN,StepSizeMAX,0,0,0,  1,y);
   LineSlwBuffer[i] = iCustom(NULL,TimeFrame,"StepMA_3D_v3m",Length,Kv,MA_Mode,StepSizeMIN,StepSizeMAX,0,0,0,  2,y);

     
   }  
   
//
    
   return(0);
  }
//+------------------------------------------------------------------+