//+------------------------------------------------------------------+
//|                                                super-signals.mq4 |
//|                Copyright  2006, Nick Bilak, beluck[AT]gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Nick Bilak converted by Suresh"
#property link      "http://www.forex-tsd.com/"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Red
#property indicator_color2 Aqua



//---- input parameters
/*************************************************************************
PERIOD_M1  1
PERIOD_M5  5
PERIOD_M15 15
PERIOD_M30 30
PERIOD_H1  60
PERIOD_H4  240
PERIOD_D1  1440
PERIOD_W1  10080
PERIOD_MN1 43200
***************/
//--You must use the numeric value of the timeframe that you want to use
//--when you set the TimeFrame' value with the indicator inputs.
//-----------------------------------------
extern int TimeFrame=0;

extern int SignalGap = 10;

int dist=24;
double b1[];
double b2[];

int init()  {
   SetIndexStyle(0,DRAW_ARROW,STYLE_SOLID,1);
   SetIndexStyle(1,DRAW_ARROW,STYLE_SOLID,1);
   SetIndexArrow(1,233);
   SetIndexArrow(0,234);
   SetIndexBuffer(0,b1);
   SetIndexBuffer(1,b2);
   
//---- name for DataWindow and indicator subwindow label   
   switch(TimeFrame)
   {
      case 1 : string TimeFrameStr="Period_M1"; break;
      case 5 : TimeFrameStr="Period_M5"; break;
      case 15 : TimeFrameStr="Period_M15"; break;
      case 30 : TimeFrameStr="Period_M30"; break;
      case 60 : TimeFrameStr="Period_H1"; break;
      case 240 : TimeFrameStr="Period_H4"; break;
      case 1440 : TimeFrameStr="Period_D1"; break;
      case 10080 : TimeFrameStr="Period_W1"; break;
      case 43200 : TimeFrameStr="Period_MN1"; break;
      default : TimeFrameStr="Current Timeframe";
   }
   IndicatorShortName("MTF_Super-Signals_v1 ("+TimeFrameStr+")");   
//----  }
//----
   return(0);
}
int start() 
{
   datetime TimeArray[];
   int    i,limit,y=0,counted_bars=IndicatorCounted();

// Plot defined time frame on to current time frame
   ArrayCopySeries(TimeArray,MODE_TIME,Symbol(),TimeFrame); 
   
   limit=Bars-counted_bars;
   limit=Bars-counted_bars;
   for(i=0,y=0;i<limit;i++)
   {
    if (Time[i]<TimeArray[y]) y++;

/***********************************************************   
   Add your main indicator loop below.  You can reference an existing
      indicator with its iName  or iCustom.
   Rule 1:  Add extern inputs above for all neccesary values   
   Rule 2:  Use 'TimeFrame' for the indicator time frame
   Rule 3:  Use 'y' for your indicator's shift value
 **********************************************************/  
   }  
   counted_bars=IndicatorCounted();
   int k,j,hhb,llb;
   
   if (counted_bars<0) return(-1);
   if (counted_bars>0) counted_bars--;
   limit=Bars-1;
   if(counted_bars>=1) limit=Bars-counted_bars-1;
   if (limit<0) limit=0;

   for (i=limit;i>=0;i--)   {
      hhb = Highest(NULL,0,MODE_HIGH,dist,i-dist/2);
      llb = Lowest(NULL,0,MODE_LOW,dist,i-dist/2);

      if (i==hhb)
         b1[i]=High[hhb]+SignalGap*Point;
      if (i==llb)
         b2[i]=Low[llb]-SignalGap*Point;
   }
   return(0);
}


