//+------------------------------------------------------------------+
//|                                                     MULTICUR.mq4 |
//|                                               Edward Samokhvalov |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Edward Samokhvalov"
#property link      ""

#property indicator_separate_window

#property  indicator_buffers 5
#property  indicator_color1  Gray
#property  indicator_color2  Yellow
#property  indicator_color3  Blue
#property  indicator_color4  Lime
#property  indicator_color5  Tomato

extern int period=8;
extern string Curr="EURUSD";

double b0[];
double b1[];
double b2[];
double up[];
double dn[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
      SetIndexStyle(0,DRAW_LINE,0,1);
      SetIndexBuffer(0,b0);
      SetIndexStyle(1,DRAW_LINE,0,1);
      SetIndexBuffer(1,b1);
      SetIndexStyle(2,DRAW_LINE,0,1);
      SetIndexBuffer(2,b2);
      
    SetIndexBuffer(3,up);
    SetIndexBuffer(4,dn);
//---- drawing parameters setting
    SetIndexStyle(3,DRAW_ARROW,0,2,Green);
    SetIndexArrow(3,217);
    SetIndexStyle(4,DRAW_ARROW,0,2,Red);
    SetIndexArrow(4,218);

      
   return(0);
  }

int start()
  {

   IndicatorShortName(Curr);

   int    limit;
   int    counted_bars=IndicatorCounted();

      if(counted_bars<1)
      for(int i=0;i<Bars;i++)
      {
         b0[i]=0.0;
         b1[i]=0.0;
         b2[i]=0.0;
         //up[i]=0.0;
         //dn[i]=0.0;
      }   

//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;



   for(i=limit-1; i>=0; i--)
   {
      b0[i]=iADX(Curr,0,period,PRICE_CLOSE,MODE_MAIN,i);
      
      b1[i]=iADX(Curr,0,period,PRICE_CLOSE,MODE_PLUSDI,i);
      
      b2[i]=iADX(Curr,0,period,PRICE_CLOSE,MODE_MINUSDI,i);
      
      
      if  (b1[i]>b0[i] && b2[i]<b0[i]) //UP
      {
         ColorUP();
         up[i]=b0[i];
      }   
      else if (b1[i]<b0[i] && b2[i]>b0[i] )
      {
         ColorDN();
         dn[i]=b0[i];
      }
      else //no signal
      {
         ColorNONE();         
      }
         

   }
     
//---- done
   return(0);
  }
  
  void ColorUP()
  {
      SetIndexStyle(0,DRAW_LINE,0,2,Gainsboro);
      SetIndexBuffer(0,b0);
      SetIndexStyle(1,DRAW_LINE,0,2,LimeGreen);
      SetIndexBuffer(1,b1);
      SetIndexStyle(2,DRAW_LINE,0,2,Red);
      SetIndexBuffer(2,b2);       
  }
  
  void ColorDN()
  {
      SetIndexStyle(0,DRAW_LINE,0,2,Gainsboro);
      SetIndexBuffer(0,b0);
      SetIndexStyle(1,DRAW_LINE,0,2,LimeGreen);
      SetIndexBuffer(1,b1);
      SetIndexStyle(2,DRAW_LINE,0,2,Red);
      SetIndexBuffer(2,b2);       
    }
  
  void ColorNONE()
  {
      SetIndexStyle(0,DRAW_LINE,0,1,Gray);
      SetIndexBuffer(0,b0);
      SetIndexStyle(1,DRAW_LINE,0,1,DarkGreen);
      SetIndexBuffer(1,b1);
      SetIndexStyle(2,DRAW_LINE,0,1,FireBrick);
      SetIndexBuffer(2,b2); 
  }