//+------------------------------------------------------------------+
//|                                                   Market-Value.mq4 
//|                                                   by ejoi 
//|                                                   
//+------------------------------------------------------------------+
#property copyright "Copyright  2007"
#property link      "www.forex-tsd.com"

#property indicator_chart_window
extern bool ShowMarketValues=True;

//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
double PointCost()
   {
   double result;
   double BasePointCost;
   string BaseString;
   string String1;
   string String2;
//+------------------------------------------------------------------+
   BasePointCost=MarketInfo(Symbol(),MODE_LOTSIZE)*MarketInfo(Symbol(),MODE_POINT);
   BaseString=StringSubstr(Symbol(),3,3);
   String1="USD"+BaseString;
   String2=BaseString+"USD";
//+------------------------------------------------------------------+   
   if(BaseString=="USD")
   result=BasePointCost;
//+------------------------------------------------------------------+   
   else if(MarketInfo(String1,MODE_BID)!=0)
   result=BasePointCost*(1/MarketInfo(String1,MODE_BID));
//+------------------------------------------------------------------+   
   else
   result=BasePointCost*MarketInfo(String2,MODE_ASK);
//+------------------------------------------------------------------+   
   return(result);
   }
//--------------------------------------------------------------------
int start()
  {
   //----
   string Comm;
   int Spread=NormalizeDouble((Ask-Bid)/Point,0);
   double swaplong=NormalizeDouble(MarketInfo(Symbol(),18),2);
   double swapshort=NormalizeDouble(MarketInfo(Symbol(),19),2);
   
   double seco= (Time[4]-Time[5])-MathMod(CurTime(),Time[4]-Time[5]);
   double minu=seco/60;
   seco=(minu-MathFloor(minu))*60;
   minu=MathFloor(minu);   
   


   if(PointCost()!=0){
   Comm=Comm+"\nPip value per One Lot: "+DoubleToStr(NormalizeDouble(PointCost(),2),2)+" USD ";
   }

   Comm=Comm+"\nTime for next bar: "+DoubleToStr(minu,0)+" min "+DoubleToStr(seco,0)+" sec";
   Comm=Comm+"\n"+Symbol()+" Spread:  "+DoubleToStr(Spread,0)+" pips";  
   Comm=Comm+"\nLeverage:  1:"+AccountLeverage();
   Comm=Comm+"\nBuySwap:  "+DoubleToStr(swaplong,2)+"   SellSwap:  "+DoubleToStr(swapshort,2);

   if (ShowMarketValues==1)Comment(Comm);
   else Comment("");

   return(0);
  }
//+------------------------------------------------------------------+