//+------------------------------------------------------------------+
//|                                                  MarketHours.mq4 |
//|                        Copyright (c) 2006, Charles W. Van Dien III |
//|                                    mailto: vandien@bellsouth.net |
//+------------------------------------------------------------------+
#property copyright "Copyright (c) 2006, Charles W. Van Dien III"
#property link      "mailto: vandien@bellsouth.net"

#property indicator_separate_window
#property indicator_buffers 3
#property indicator_minimum 0
#property indicator_maximum 4
#property indicator_color1 Goldenrod
#property indicator_color2 Red
#property indicator_color3 DodgerBlue

extern int     ServerGMT   =2;     // future Daylight Savings value

int EuropeanMarketOpen=6;     //06:00 GMT
int EuropeanMarketClose=15;   //15:00 GMT

int AsianMarketOpen=23;       //23:00 GMT
int AsianMarketClose=7;       //7:00 GMT

int USMarketOpen=12;          //12:00 GMT
int USMarketClose=20;         //20:00 GMT

double USMarket[];
double EuropeanMarket[];
double AsianMarket[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()  {
//---- indicators
SetIndexStyle(0,DRAW_ARROW,STYLE_SOLID,1);
SetIndexShift(0,0);
SetIndexDrawBegin(0,0);
SetIndexEmptyValue(0,0.0);
SetIndexLabel(0,NULL);
SetIndexArrow(0,110);
SetIndexBuffer(0,AsianMarket);

SetIndexStyle(1,DRAW_ARROW,STYLE_SOLID,1);
SetIndexShift(1,0);
SetIndexDrawBegin(1,0);
SetIndexEmptyValue(1,0.0);
SetIndexLabel(1,NULL);
SetIndexArrow(1,110);
SetIndexBuffer(1,EuropeanMarket);

SetIndexStyle(2,DRAW_ARROW,STYLE_SOLID,1);
SetIndexShift(2,0);
SetIndexDrawBegin(2,0);
SetIndexEmptyValue(2,0.0);
SetIndexLabel(2,NULL);
SetIndexArrow(2,110);
SetIndexBuffer(2,USMarket);

//----
   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()   {
//----
   
//----
   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start() {
IndicatorShortName("Market Hours");
int limit;
int counted_bars=IndicatorCounted();
if(counted_bars<0) return(-1);
if(counted_bars>0) counted_bars--;
limit=Bars-counted_bars;
//limit=Bars;
for(int x=0; x<limit; x++) {
   AsianMarket[x]=0.0;
   EuropeanMarket[x]=0.0;
   USMarket[x]=0.0;
   if(TimeHour(Time[x])>=AsianMarketOpen+ServerGMT  || (TimeHour(Time[x])<=AsianMarketClose+ServerGMT-1 )) {
      AsianMarket[x]=1.0;
   }
   if(TimeHour(Time[x])>=EuropeanMarketOpen+ServerGMT && TimeHour(Time[x])<=EuropeanMarketClose+ServerGMT-1) {   
      EuropeanMarket[x]=2.0;
   }
   if(TimeHour(Time[x])>=USMarketOpen+ServerGMT && TimeHour(Time[x])<=USMarketClose+ServerGMT-1) {
      USMarket[x]=3.0;
   }
}
return(0);
}
//+------------------------------------------------------------------+