//+------------------------------------------------------------------+
//|                                                                  |
//|                      2008 Sunwest                                |
//|                                                                  |
//+------------------------------------------------------------------+
#property  copyright                    "2008 Sunwest"
#property  link                         "Forex-tsd.com"

//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 3
#property indicator_color1 Green      
#property indicator_color2 Red
#property indicator_color3 Blue



//---- buffers
double BarUp[];
double BarDown[];
double DaySeparator[];

extern int PipStep = 40;
extern int StartingBrokerHour=23;
extern bool StopDisplay = true;

double PeriodinDay,ShiftDayChange;
double MaxUpDistance,MxDownDistance,Max;
double Diff,Diffmax,Diffmin;
int Direction;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{

   PeriodinDay=(24*60)/Period();
   ShiftDayChange=60/Period()*StartingBrokerHour;
//---- drawing settings
   SetIndexStyle(0,DRAW_HISTOGRAM,0,2);
   SetIndexStyle(1,DRAW_HISTOGRAM,0,2);
   SetIndexStyle(2,DRAW_HISTOGRAM,0,2);
   
   SetIndexBuffer(2,BarUp);
   SetIndexBuffer(1,BarDown);
   SetIndexBuffer(0,DaySeparator);

   SetLevelStyle(STYLE_DASHDOTDOT,0,Brown);
   SetLevelValue(3,PipStep);
   SetLevelValue(4,-PipStep);
  


//---- initialization done
   return(0);
}

int start()
  {

      if (PeriodinDay<1 || ShiftDayChange<1)   return(0);
      int ShiftIntDayChange = ShiftDayChange;
      for(int shift = Bars-PeriodinDay-1; shift >= 0; shift-=PeriodinDay)
      { 

         MaxUpDistance = 0;
         MxDownDistance = 0;
         Max=0;
         Direction=0;
         DaySeparator[shift]=200;
         for(int i =0 ; i < PeriodinDay  ; i++)
         {
            if ( (shift-i)>=0)
            {
               Diffmax = High[shift-i]-Open[shift];
               Diffmin = Low[shift-i]-Open[shift];
            }

            
            if (Diffmax > MaxUpDistance) MaxUpDistance=Diffmax;
            if (Diffmin<  MxDownDistance) MxDownDistance=Diffmin;
            if ( MaxUpDistance> MathAbs(MxDownDistance))   Max=MaxUpDistance; else Max= MxDownDistance;

            if (StopDisplay==true)
            {
               if ( MaxUpDistance/Point >= PipStep) {Max=MaxUpDistance;Direction=1;i=PeriodinDay;}
               if ( MxDownDistance/Point <= -PipStep) {Max= MxDownDistance;Direction=-1;i=PeriodinDay;}
            }   
            
            if (Max>=0)   
            {
               if( (StopDisplay==true) && (Max/Point >=PipStep)) StopDisplay=true; else BarUp[shift-i]= Max/Point; 
            }
            else 
            {
               if( (StopDisplay==true) && (Max/Point <=-PipStep)) StopDisplay=true; else BarDown[shift-i] = Max/Point;
            }
               
            if ( TimeDay(Time[shift-i+ShiftIntDayChange])!= TimeDay(Time[shift-i-1+ShiftIntDayChange]))
            {
               if(StopDisplay==false)   shift=shift+PeriodinDay-i-1;
               i=PeriodinDay;
            }
            
         }
         
         if (StopDisplay==true)
         {
            for(i =0 ; i < PeriodinDay  ; i++)
            {
     
            
               if (Direction==1)   
               {
                  BarUp[shift-i]= Max/Point; 
                  BarDown[shift-i] =0;
               }
               
               if (Direction==-1) 
               {
                  BarDown[shift-i] = Max/Point;
                  BarUp[shift-i]=0;
                  if (shift<PeriodinDay)  Print("Max :",Max);
               }
               
               
               if ( TimeDay(Time[shift-i+ShiftIntDayChange])!= TimeDay(Time[shift-i-1+ShiftIntDayChange])) {shift=shift+PeriodinDay-i-1;i=PeriodinDay;}
            
            }
         }
      }
      
      return(0);
  }
//+------------------------------------------------------------------+