//   mMktOpen.mq4

#property indicator_chart_window

extern bool NY=true;
extern bool London=true;
extern bool Auckland=true;
extern bool Sydney=true;
extern bool Tokyo=true;
extern bool HongKong=true;
extern bool Frankfurt=true;
extern bool USNews=true;
extern bool t30MinAdvanceNotice=false;     //display dashed line 30 minutes before opening?

//Data provider times for openings
extern int NYOpenDataTime=15;
extern int LondonOpenDataTime=10;
extern int AucklandOpenDataTime=23;
extern int SydneyOpenDataTime=1;
extern int TokyoOpenDataTime=2;
extern int HongKongOpenDataTime=3;
extern int FrankfurtOpenDataTime=8;
extern int USNewsOpenDataTime=15;

extern color NYColor=LightPink;
extern color LondonColor=PeachPuff;
extern color AucklandColor=Bisque;
extern color SydneyColor=PaleGreen;
extern color TokyoColor=LightSalmon;
extern color HKColor=Yellow;
extern color FrankfurtColor=DarkTurquoise;
extern color USNewsColor=White;
double val1,val2;

int deinit()
  {
   int bars_count=BarsPerWindow(), i;
   for (i=0;i<bars_count;i++)
      {
      ObjectDelete("VLL"+DoubleToStr(i,0));
      ObjectDelete("VL"+DoubleToStr(i,0));
      
      }
   return(0);
  }
//----------------------------------------------------------------------------------------
int start()
   {
   int counted_bars=IndicatorCounted();
   int bars_count=BarsPerWindow(),h,m;
   bool drawvl;
   if (Period()>PERIOD_H1) 
      {
         return(0);    //If time > 1 hour clutters up screen
      }
   for (int i=0;i<bars_count;i++)
      {
         drawvl=false;
         h=TimeHour(Time[i]);
         m=TimeMinute(Time[i]);
         if (London==true)
            {
               if ((h==LondonOpenDataTime) && (m==0)) {drawvl=true;VerticalLine("LondO",i,STYLE_SOLID,LondonColor);}
               if ((h==TimeAdjust(LondonOpenDataTime,0)) && (m==0)) {drawvl=true;VerticalLine("LC",i,STYLE_DOT,LondonColor);}
               if (t30MinAdvanceNotice==true)
                  {
                     if ((h==TimeAdjust(LondonOpenDataTime,1)) && (m==30)) {drawvl=true;VerticalLine("",i,STYLE_DASH,LondonColor);}
                     if ((h==TimeAdjust(LondonOpenDataTime,2)) && (m==30)) {drawvl=true;VerticalLine("",i,STYLE_DASH,LondonColor);}
                  }
            }
         if (NY==true)
            {
               if ((h==NYOpenDataTime) && (m==0)) {drawvl=true;VerticalLine("NYO",i,STYLE_SOLID,NYColor);}
               if ((h==TimeAdjust(NYOpenDataTime,0)) && (m==0)) {drawvl=true;VerticalLine("NYC",i,STYLE_DOT,NYColor);}
               if (t30MinAdvanceNotice==true)
                  {
                     if ((h==TimeAdjust(NYOpenDataTime,1)) && (m==30)) {drawvl=true;VerticalLine("",i,STYLE_DASH,NYColor);}
                     if ((h==TimeAdjust(NYOpenDataTime,2)) && (m==30)) {drawvl=true;VerticalLine("",i,STYLE_DASH,NYColor);}
                  }

            }
         if (Auckland==true)
            {
               if ((h==AucklandOpenDataTime) && (m==0)) {drawvl=true;VerticalLine("AuckO",i,STYLE_DOT,AucklandColor);}
               //if ((h==TimeAdjust(AucklandOpenDataTime,0)) && (m==0)) {drawvl=true;VerticalLine("AuckC",i,STYLE_SOLID,AucklandColor);}
               if (t30MinAdvanceNotice==true)
                  {
                     if ((h==TimeAdjust(AucklandOpenDataTime,1)) && (m==30)) {drawvl=true;VerticalLine("",i,STYLE_DASH,AucklandColor);}
                     if ((h==TimeAdjust(AucklandOpenDataTime,2)) && (m==30)) {drawvl=true;VerticalLine("",i,STYLE_DASH,AucklandColor);}
                  }
            }
         if (Sydney==true)
            {
               if ((h==SydneyOpenDataTime) && (m==0)) {drawvl=true;VerticalLine("SydO",i,STYLE_DOT,SydneyColor);}
               //if ((h==TimeAdjust(SydneyOpenDataTime,0)) && (m==0)) {drawvl=true;VerticalLine("SydC",i,STYLE_SOLID,SydneyColor);}  //TURNED OFF so London Open shows
               if (t30MinAdvanceNotice==true)
                  {
                     if ((h==TimeAdjust(SydneyOpenDataTime,1)) && (m==30)) {drawvl=true;VerticalLine("",i,STYLE_DASH,SydneyColor);}
                     if ((h==TimeAdjust(SydneyOpenDataTime,2)) && (m==30)) {drawvl=true;VerticalLine("",i,STYLE_DASH,SydneyColor);}
                  }
            }
         if (Tokyo==true)
            {
               if ((h==TokyoOpenDataTime) && (m==0)) {drawvl=true;VerticalLine("TokyoO",i,STYLE_SOLID,TokyoColor);}
               if ((h==TimeAdjust(TokyoOpenDataTime,0)) && (m==0)) {drawvl=true;VerticalLine("TokyoC",i,STYLE_DOT,TokyoColor);}
               if (t30MinAdvanceNotice==true)
                  {
                     if ((h==TimeAdjust(TokyoOpenDataTime,1)) && (m==30)) {drawvl=true;VerticalLine("",i,STYLE_DASH,TokyoColor);}
                     if ((h==TimeAdjust(TokyoOpenDataTime,2)) && (m==30)) {drawvl=true;VerticalLine("",i,STYLE_DASH,TokyoColor);}
                  }
           //Added in Frankfurt       
             }     
          if (Frankfurt==true)
            {
            if ((h==FrankfurtOpenDataTime) && (m==0)) {drawvl=true;VerticalLine("FrankO + AuckC",i,STYLE_DOT,FrankfurtColor);}
            if (t30MinAdvanceNotice==true)                                       
            {
                     if ((h==TimeAdjust(FrankfurtOpenDataTime,1)) && (m==30)) {drawvl=true;VerticalLine("",i,STYLE_DASH,FrankfurtColor);}
                     if ((h==TimeAdjust(FrankfurtOpenDataTime,2)) && (m==30)) {drawvl=true;VerticalLine("",i,STYLE_DASH,FrankfurtColor);}
                  }  
                      
            }
         if (HongKong==true)
            {
               if ((h==HongKongOpenDataTime) && (m==0)) {drawvl=true;VerticalLine("HKO",i,STYLE_DOT,HKColor);}
               if ((h==TimeAdjust(HongKongOpenDataTime,0)) && (m==0)) {drawvl=true;VerticalLine("HKC",i,STYLE_DOT,HKColor);}
               if (t30MinAdvanceNotice==true)
                  {
                     if ((h==TimeAdjust(HongKongOpenDataTime,1)) && (m==30)) {drawvl=true;VerticalLine("",i,STYLE_DASH,HKColor);}
                     if ((h==TimeAdjust(HongKongOpenDataTime,2)) && (m==30)) {drawvl=true;VerticalLine("",i,STYLE_DASH,HKColor);}
                  }
                     }
         if (HongKong==true)
            {
               if ((h==USNewsOpenDataTime) && (m==30)) {drawvl=true;VerticalLine("NEWS",i,STYLE_DASHDOT,USNewsColor);}
               //if ((h==TimeAdjust(USNewsOpenDataTime,0)) && (m==30)) {drawvl=true;VerticalLine("NEWS",i,STYLE_DOT,USNewsColor);}
               if (t30MinAdvanceNotice==true)
                  {
                     if ((h==TimeAdjust(USNewsOpenDataTime,1)) && (m==30)) {drawvl=true;VerticalLine("",i,STYLE_DASH,USNewsColor);}
                     if ((h==TimeAdjust(USNewsOpenDataTime,2)) && (m==30)) {drawvl=true;VerticalLine("",i,STYLE_DASH,USNewsColor);}
                  }
            }
      }
   return(0);
   }
//----------------------------------------------------------------------------------------------
int VerticalLine(string s,int i,int st,int Col)    //s=Text Label, i = bar, st=Line Style, Col = color
   {
   ObjectDelete("VL"+DoubleToStr(i,0));
   ObjectDelete("VLL"+DoubleToStr(i,0));// added to make sure of delete
   val1=Low[Lowest(NULL,0,MODE_LOW,BarsPerWindow(),0)];
   val2=High[Highest(NULL,0,MODE_HIGH,BarsPerWindow(),0)];
   ObjectCreate("VL"+DoubleToStr(i,0),OBJ_TREND,0,Time[i],0,Time[i],900);
   ObjectSet("VL"+DoubleToStr(i,0),OBJPROP_COLOR,Col);
   ObjectSet("VL"+DoubleToStr(i,0),OBJPROP_WIDTH,1);
   ObjectSet("VL"+DoubleToStr(i,0),OBJPROP_STYLE,st);
   ObjectSet("VL"+DoubleToStr(i,0),OBJPROP_RAY,0);
   ObjectDelete("VLL"+DoubleToStr(i,0));
   ObjectCreate("VLL"+DoubleToStr(i,0),OBJ_TEXT,0,Time[i],val2+Point*3);//val2-Point*16 Brings labels down screen 
   ObjectSetText("VLL"+DoubleToStr(i,0),s,7,"Arial",Col);               //val2+Point*3  =  Org code
   ObjectsRedraw();
   return(0);
   }

int TimeAdjust(int TimeIn, int ProcessType)  
   {
      if (ProcessType==0)     //Calculate Closing Hour.  Open Hour + 9 hours
         {
            if ((TimeIn>=0) && (TimeIn<=14)){return(TimeIn+9);}
            return(TimeIn-15);
         }   
      if (ProcessType==1)     //Calculate 30MinAdvanceNotice for Opening Hour
         {
            if (TimeIn==0) {return(23);}
            return(TimeIn-1);
         }
      if (ProcessType==2)     //Calculate 30MinAdvanceNotice for Closing Hour
         {
            if ((TimeIn>=0) && (TimeIn<=15)) {return(TimeIn+8);}
            return(TimeIn-16);
         }
   }