/*
 * Mouteki Stop Expert
 *
 * Intellectual Property of Fukinagashi (fukinagashi@gmx.net)
 *
 * o Based on a Breakout-Technic discussed at ForexFactory ("Mouteki Trading... ")
 *   URL http://www.forexfactory.com/forexforum/showthread.php?t=7883
 *
 * o Description:
 *
 *   A little contribution to this active thread, this great technique and the forexfactory community.
 *  
 *   The following MT4-expert does help us to follow through the rules mentioned in Post 865:
 *   (http://www.forexfactory.com/forexforum/showthread.php?p=102567#post102567.) Please copy it into
 *   your expert/ folder and attach it to the charts, where you want it to do its work.
 *  
 *   How does it work?
 *   You only need to do your buy/sell either with immediate setting of the target (TakeProfit) or with
 *   that setting in a separate step. The target is important, without it the expert will do nothing!
 *   As soon as this experts finds a manually set order in the current account which has a TakeProfit,
 *   it does the following:
 *  
 *   - It checks if an StopLoss is already set. If not, it does set a StopLoss according to the difference
 *     between the Opening Price and the Target under Application of the 90pip/50%/33% rule. (You can change
 *     this StopLoss or initially put another StopLoss. It will be left unchanged until the Order is 40 pips
 *     in Profit.)
 *   - If the expert sees that an SL is set it will do nothing until the Trade is 40 Pips in the positive
 *     at which time it will set the Order to B/E+10 Pips.
 *  
 *   This way we only need to worry about identifying breakouts and their respective targets and the rest
 *   is done automatically.
 *  
 *   In case you have other Trades in that account, which you do not want to be treated by the MoutekiStop:
 *   In the global parameters of this expert is one, which is called Comment. Normally it is empty ("").
 *   If you set it to something, the experts only treats these Orders which have EXACTLY this comment.
 *   So set it to for example "Mouteki" and it will only treat orders with the comment "Mouteki". It will
 *   not treat order with "Bagovino", "", "MOUTEKI", "Muteki", or "Mouteki 22.09.06", etc. you get the
 *   point :-).
 *  
 * o Disclaimer: I tested this expert on my demo account and it seems to work, but until further testing
 *               I do not counsel you on using it on real money. In any case I deny in advance any
 *               responsibilities about the activities or inactivities of this expert.
 *
 * $Log: MoutekiStop,v $
 * Revision 1.0  2006/09/22 08:50:09  fukinagashi
 */

#include <stdlib.mqh>

extern int     Limit           = 90;
extern double  SLRulePreLimit  = 0.5;
extern double  SLRulePostLimit = 0.333;
extern int     BEInit          = 40;
extern int     BEPlus          = 10;

extern int     MagicNumber     = 0;
extern string    EAComment         = "";

int start() {
  double SL;
  double GainLoss;
 
  for (int cnt = 0; cnt < OrdersTotal(); cnt++) {
    int Delta;
    OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);
    if (OrderMagicNumber() == MagicNumber && OrderSymbol() == Symbol() && (OrderType()==OP_SELL || OrderType()==OP_BUY)) {
      if (EAComment != "" && OrderComment()!= EAComment) continue;
      double OOP=OrderOpenPrice();
      double OTP=OrderTakeProfit();
      double OSL=OrderStopLoss();
     
      if(OTP == 0) return(0);
      if(OrderType()==OP_BUY) {
        if (OSL == 0) {
          Delta=(OTP - OOP)/Point;
          if (Delta < Limit) { SL = OOP - Delta * SLRulePreLimit * Point;
          } else {             SL = OOP - Delta * SLRulePostLimit * Point; }
        } else {
          GainLoss=(Bid-OOP)/Point;
          if (GainLoss>BEInit) SL = OOP + BEPlus * Point;
        }
      } else {
        if (OSL == 0) {
          Delta=(OOP - OTP)/Point;
          if (Delta < Limit) { SL = OOP + Delta * SLRulePreLimit * Point;
          } else {             SL = OOP + Delta * SLRulePostLimit * Point; }
        } else {
          GainLoss=(OOP-Ask)/Point;
          if (GainLoss>BEInit) SL = OOP - BEPlus * Point;
        }
      }
      SL=NormalizeDouble(SL, Digits);
      if(OSL!=SL && SL!=0) {
        OrderModify(OrderTicket(), OrderOpenPrice(), SL, OrderTakeProfit(), 0, Blue);
        Print("Attempting to change SL from " + OSL + " to " + SL);
        int err=GetLastError();
        if (err!=0) Print("Oh no! => " + ErrorDescription(err) + " (" + err + "). Damn!");
      }
    }
  }
}