//+------------------------------------------------------------------+
//|                                                      MultiMA.mq4 |
//|                      Copyright  2005, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright " "
#property link      "arzuma@helios.ru"

#property indicator_separate_window
#property indicator_buffers 7
#property indicator_color1 Red
#property indicator_color2 Blue
#property indicator_color3 Orange
#property indicator_color4 White
#property indicator_color5 Yellow
#property indicator_color6 Aqua
#property indicator_color7 Lime

double EUR,GBP,AUD,CHF,JPY,CAD,USD;
//extern string Curency = "EUR";
extern int PerAvr=34,Delta=3;
double Idx[],Idx1[],Idx2[],Idx3[],Idx4[],Idx5[],Idx6[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,1);
   SetIndexBuffer(0,Idx);
   SetIndexStyle(1,DRAW_LINE,STYLE_SOLID,1);
   SetIndexBuffer(1,Idx1);
   SetIndexStyle(2,DRAW_LINE,STYLE_SOLID,1);
   SetIndexBuffer(2,Idx2);
   SetIndexStyle(3,DRAW_LINE,STYLE_SOLID,1);
   SetIndexBuffer(3,Idx3);
   SetIndexStyle(4,DRAW_LINE,STYLE_SOLID,1);
   SetIndexBuffer(4,Idx4);
   SetIndexStyle(5,DRAW_LINE,STYLE_SOLID,1);
   SetIndexBuffer(5,Idx5);
   SetIndexStyle(6,DRAW_LINE,STYLE_SOLID,3);
   SetIndexBuffer(6,Idx6);

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {  
   int counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   int limit=Bars-counted_bars;
   for(int i=limit; i>=0; i--)
   {
      EUR=(iMA("EURUSD",0,PerAvr,0,MODE_LWMA,PRICE_CLOSE,i)-iMA("EURUSD",0,PerAvr,0,MODE_LWMA,PRICE_CLOSE,i+Delta)); 
      GBP=(iMA("GBPUSD",0,PerAvr,0,MODE_LWMA,PRICE_CLOSE,i)-iMA("GBPUSD",0,PerAvr,0,MODE_LWMA,PRICE_CLOSE,i+Delta)); 
      AUD=(iMA("AUDUSD",0,PerAvr,0,MODE_LWMA,PRICE_CLOSE,i)-iMA("AUDUSD",0,PerAvr,0,MODE_LWMA,PRICE_CLOSE,i+Delta)); 
      CHF=(iMA("USDCHF",0,PerAvr,0,MODE_LWMA,PRICE_CLOSE,i+Delta)-iMA("USDCHF",0,PerAvr,0,MODE_LWMA,PRICE_CLOSE,i)); 
      JPY=(iMA("USDJPY",0,PerAvr,0,MODE_LWMA,PRICE_CLOSE,i+Delta)-iMA("USDJPY",0,PerAvr,0,MODE_LWMA,PRICE_CLOSE,i))/100; 
      CAD=(iMA("USDCAD",0,PerAvr,0,MODE_LWMA,PRICE_CLOSE,i+Delta)-iMA("USDCAD",0,PerAvr,0,MODE_LWMA,PRICE_CLOSE,i));
      USD=-(EUR+GBP+AUD+CHF+CAD+JPY)/6; 
      //if (Curency == "EUR") 
      Idx[i] = EUR;
      //if (Curency == "GBP") 
      Idx1[i] = GBP;
      //if (Curency == "AUD") 
      Idx2[i] = AUD;
      //if (Curency == "CHF") 
      Idx3[i] = CHF;
      //if (Curency == "JPY") 
      Idx4[i] = JPY;
      //if (Curency == "CAD") 
      Idx5[i] = CAD;
      Idx6[i] = USD;
         
   }

//---- 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+