//+---------------------------------------------------------------------------+
//|                                                                   NLR.mq4 |
//|                                                   Copyright  2006, REHIL |
//+---------------------------------------------------------------------------+
#property copyright "Copyright  2006, REHIL"

#property indicator_chart_window
#property indicator_buffers 1
#property indicator_color1  Silver

//---- external variables
extern int length    = 14;
extern int fltMethod = 0;
//---- indicator buffers
double ArrayNLR[];
//---- global variables
double gWrkArray[1];
double S = 0, oNLRPrice = 0, oStdDev = 0;
bool   fTimeThrough  = TRUE;

//+---------------------------------------------------------------------------+
//| Custom indicator initialization function                                  |
//+---------------------------------------------------------------------------+
int init()
{
   IndicatorBuffers(1);
   IndicatorDigits( MarketInfo( Symbol(), MODE_DIGITS ));
   SetIndexStyle(0, DRAW_LINE);
   if( !SetIndexBuffer( 0, ArrayNLR ) )
      Print( "cannot set indicator buffers!" );
   SetIndexDrawBegin( 0, 10 );
   if(fltMethod > 1)
      fltMethod = 1;
   IndicatorShortName( "NLR" );

   return(0);
}
//+---------------------------------------------------------------------------+
//| Custom indicator deinitialization function                                |
//+---------------------------------------------------------------------------+
int deinit()
{

   return(0);
}
/*+-------------------------------------------------------------------------+
   NLR Function WAV 11/28/03 

   NonLinear Regression Analysis
   y = A + B*X + C*X*X (2nd order)

   y price
   x bar (time)
   A,B,C coefficients to determine

   Standard deviation (S) of price from
   calculated price for length data is returned 

   price for desired bar (either a past or future one) is returned
  +-------------------------------------------------------------------------+*/
double NLR(double price[], int desiredBar)
{
   int value1, N;
   double AvgX, AvgY, XM, YM, XM2, SXX, SXY;
   double SYY, SXX2, SX2X2, SYX2, ACoeff;
   double BCoeff, CCoeff, MaxLength = 100;
   double TY, TX, RV, ERR, value99;
   double YValue[100], XValue[100];

   N = length;
   if(N > MaxLength)
      N = MaxLength;
   if(N < 2)
      N = 2;

   for(value1 = 1; value1 <= N; value1++)
   {
      XValue[value1] = value1 - 1;
      YValue[value1] = price[value1 - 1];
   }

   AvgX = 0; AvgY = 0;
   for(value1 = 1; value1 <= N; value1++)
   {
      AvgX = AvgX + XValue[value1];
      AvgY = AvgY + YValue[value1];
   }
   if(N != 0)
   {
      AvgX = AvgX / N;
      AvgY = AvgY / N;
   }

   SXX = 0; SXY = 0; SYY = 0; SXX2 = 0; SX2X2 = 0; SYX2 = 0;
   for(value1 = 1; value1 <= N; value1++)
   {
      XM = XValue[value1] - AvgX; 
      YM = YValue[value1] - AvgY;
      XM2 = XValue[value1] * XValue[value1] - AvgX * AvgX;
      SXX = SXX + XM * XM;
      SXY = SXY + XM * YM;
      SYY = SYY + YM * YM;
      SXX2 = SXX2 + XM * XM2;
      SX2X2 = SX2X2 + XM2 * XM2;
      SYX2 = SYX2 + YM * XM2;
   }
   value99 = SXX * SX2X2 - SXX2 * SXX2;
   if(value99 != 0.0)
   {
      BCoeff = ( SXY * SX2X2 - SYX2 * SXX2 ) / value99;
      CCoeff = ( SXX * SYX2 - SXX2 * SXY ) / value99;
   }
   ACoeff = AvgY - BCoeff * AvgX - CCoeff * AvgX * AvgX;

   oNLRPrice = ACoeff + BCoeff * desiredBar + CCoeff * desiredBar * desiredBar;

   S = 0; AvgY = 0;
   for(value1 = 1; value1 < N; value1++)
   {
      TY = YValue[value1];
      TX = XValue[value1];
      RV = ACoeff + BCoeff * XValue[value1] + CCoeff * XValue[value1] * XValue[value1];
      ERR = TY - RV;
      AvgY = AvgY + TY;
      S = S + ERR * ERR;
   }
   if((N - 1) != 0)
      if((S / (N - 1)) > 0)
         S = MathSqrt((S / (N - 1)));

   oStdDev = S;

   return(oNLRPrice);
}
/*+-------------------------------------------------------------------------+
   NLR1 Indicator WAV 11/26/03

   NonLinear Regression Analysis
   y = A + B*X + C*X*X (2nd order)

   y price
   x bar (time)
   A,B,C coefficients to determine
  +-------------------------------------------------------------------------+*/
int start()
{
   int i, j, limit, cntBars = IndicatorCounted();

   if(fTimeThrough)
   {
      ArrayResize(gWrkArray, length);
      fTimeThrough = FALSE;
   }

   limit = Bars - cntBars;
   for( i = 0; i < limit; i++ )
   {
      for(j = 0; j < length; j++)
         gWrkArray[j] = ((Open[i + j]+Close[i + j]+High[i + j]+Low[i + j])/4);

      ArrayNLR[i] = NLR(gWrkArray, 0);
   }

   return(0);
}
//+---------------------------------------------------------------------------+