//+------------------------------------------------------------------+
//|                                                  NonLagMA_v3.mq4 |
//|                                Copyright  2006, TrendLaboratory |
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |
//|                                   E-mail: igorad2003@yahoo.co.uk |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, TrendLaboratory"
#property link      "http://finance.groups.yahoo.com/group/TrendLaboratory"


#property indicator_chart_window
#property indicator_buffers 1
#property indicator_color1 Orange
#property indicator_width1 2

//---- input parameters
extern int Price    =  0;
extern int Length   =  8;
extern int Displace =  0;

double Cycle =  4;

//---- indicator buffers
double MABuffer[];
double price[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
  int init()
  {
   int ft=0;
   string short_name;
//---- indicator line
   IndicatorBuffers(2);
   SetIndexStyle(0,DRAW_LINE);
   
   SetIndexBuffer(0,MABuffer);
   SetIndexBuffer(1,price);
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));
//---- name for DataWindow and indicator subwindow label
   short_name="NonLagMA("+Length+")";
   IndicatorShortName(short_name);
   SetIndexLabel(0,"NLMA");
//----
   SetIndexShift(0,Displace);

   SetIndexDrawBegin(0,Length*Cycle+Length);
//----
   return(0);
  }

//+------------------------------------------------------------------+
//| NonLagMA_v3                                                     |
//+------------------------------------------------------------------+
int start()
{
   int    i,shift, counted_bars=IndicatorCounted(),limit;
   double alfa, beta, t, Sum, Weight, step,g;
   double pi = 3.1415926535;    
   
   double Coeff =  3*pi;
   int Phase = Length-1;
   double Len = Length*Cycle + Phase;  
   
   if ( counted_bars > 0 )  limit=Bars-counted_bars;
   if ( counted_bars < 0 )  return(0);
   if ( counted_bars ==0 )  limit=Bars-Len-1; 
        
   for(shift=limit;shift>=0;shift--) 
   {	
   Weight=0; Sum=0; t=0;
       
      for (i=0;i<=Len-1;i++)
	   { 
      g = 1.0/(Coeff*t+1);   
      if (t <= 0.5 ) g = 1;
      beta = MathCos(pi*t);
      alfa = g * beta;
      price[i] = iMA(NULL,0,1,0,MODE_SMA,Price,shift+i); 
      Sum += alfa*price[i];
      Weight += alfa;
      if ( t < 1 ) t += 1.0/(Phase-1); 
      else if ( t < Len-1 )  t += (2*Cycle-1)/(Cycle*Length-1);
      }

	if (Weight > 0) MABuffer[shift] = Sum/Weight;
   }
	return(0);	
}

