//+------------------------------------------------------------------+
//|                                          Version  July 20, 2006  |
//|   Editing   Nikolay Kositsin  15.06.2006  farria@mail.redcom.ru  |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//|                                                         NRTR.mq4 |
//|                                        Ramdass - Conversion only |
//+------------------------------------------------------------------+
#property copyright "CRamdass - Conversion only" 
#property link "" 
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 2 
//----  
#property indicator_color1 Blue
#property indicator_color2 Red
//----   
#property indicator_width1 1
#property indicator_width2 1
//----   
extern int AveragePeriod = 10;
//----  
double Ind_Buffer1[];
double Ind_Buffer2[];
//+------------------------------------------------------------------+
//| NRTR initialization function                                     |
//+------------------------------------------------------------------+
int init()
  {
//---- 2     
   SetIndexBuffer(0, Ind_Buffer1);
   SetIndexBuffer(1, Ind_Buffer2);
//----     
   SetIndexStyle(0, DRAW_ARROW);
   SetIndexStyle(1, DRAW_ARROW);
   SetIndexArrow(0, 159);
   SetIndexArrow(1, 159);
//----   ,      
   SetIndexEmptyValue(0, 0.0);
   SetIndexEmptyValue(1, 0.0);
//----        
   SetIndexLabel(0, "NRTRUp(" + AveragePeriod + ")");    
   SetIndexLabel(1, "NRTRDown(" + AveragePeriod + ")"); 
//----   ,       
   SetIndexDrawBegin(0,AveragePeriod); 
   SetIndexDrawBegin(1,AveragePeriod); 
//----    (    ) 
//          
   IndicatorDigits(Digits);  
//----  
   return(0);
  }
//+------------------------------------------------------------------+
//| NRTR                                                             |
//+------------------------------------------------------------------+
int start()
  {
   //----       
   if(Bars <= AveragePeriod)
       return(0);
   //----     
   static double PRICE,RESALT; 
   static bool TREND; 
   static int time2;
   //----+     
   double Resalt, close, open, dK, AvgRange, price, NewVel;
   //----    
   bool   trend;
   //----+        
   int bar, MaxBar, limit, counted_bars = IndicatorCounted();
   //----    
   if(counted_bars < 0) 
       return(-1);
   //----       
   if(counted_bars > 0) 
       counted_bars--;
   //----     ,     
   //          
   MaxBar = Bars - 1 - AveragePeriod;
   //----     ,     
   //          
   limit = Bars - 1 - counted_bars;
   //+---   
   int Tnew = Time[limit + 1];
   if(limit < MaxBar)
   if(Tnew == time2)
     {
       price = PRICE;   
       trend = TREND; 
       Resalt = RESALT;
     } 
   else 
     {
       if(Tnew > time2)
           Print("ERROR01");  
       else 
           Print("ERROR02");
       return(-1);  
     }
   //----  
   if(limit >= MaxBar)
     {
       for(int iii = 0; iii < AveragePeriod; iii++) 
         {
           Ind_Buffer1[MaxBar-iii] = 0.0;
           Ind_Buffer2[MaxBar-iii] = 0.0;
           limit = MaxBar - AveragePeriod;
         }
       //----
       AvgRange = 0;
       for(int jjj = AveragePeriod - 1; jjj >= 0; jjj--)
           AvgRange += MathAbs(High[MaxBar+jjj] - Low[MaxBar+jjj]);
       dK = AvgRange / (AveragePeriod*10000*Point );
       close = Close[MaxBar];
       open = Open [MaxBar];
       price = close;
       //----
       if(close > open)
         {
           Resalt = close * (1 - dK);
           trend = true; 
         }
       //----
       if(close < open)  
         {
           Resalt = close * (1 + dK);
           trend = false; 
         }
       if(trend) 
           Ind_Buffer1[MaxBar] = Resalt; 
       if(!trend) 
           Ind_Buffer2[MaxBar] = Resalt; 
     }
   //----+    
   bar = limit;
   while(bar >= 0)
     {   
       //+---   
       if(bar == 1)
         if(((limit == 1) && (time2 == Time[2])) || (limit > 1))
           {
             time2 = Time[2];
             PRICE = price;
             TREND = trend;
             RESALT = Resalt;
           }
       //+---+==========================================+   
       AvgRange = 0; 
       for(int kkk = AveragePeriod-1; kkk >= 0; kkk--)
           AvgRange += MathAbs(High[bar+kkk] - Low[bar+kkk]);
       dK = AvgRange / (AveragePeriod*10000*Point );  
       close = Close[bar];
       Ind_Buffer1[bar] = 0; 
       Ind_Buffer2[bar] = 0;
       //----
       if(trend)
         {
           if(close > price)
             {
               price  = close;
               NewVel = close * (1 - dK);
               if(NewVel > Resalt) 
                   Resalt=NewVel;
             }
           else
               if(close < Resalt)
                 {
                   price  = close;
                   Resalt = close * (1 + dK);
                   trend  = false;
                 }
         } 
       //---- 
       if(!trend)
         {
           if(close < price)
             {  
               price  = close;
               NewVel = close * (1 + dK);
               if(NewVel < Resalt) 
                   Resalt=NewVel;
             } 
           else  
               if(close > Resalt) 
                 {
                   price  = close;
                   Resalt = close * (1 - dK);
                   trend  = true;
                 }
         }
       //----
       if(trend) 
           Ind_Buffer1[bar] = Resalt; 
       if(!trend) 
           Ind_Buffer2[bar] = Resalt; 
       bar--;
     }
    //----+   
    return(0);
  }
//+---------------------------------------------------------------------------------------------------------------------------+