//+------------------------------------------------------------------+
//|                                             OutData_InResult.mq4 |
//|                                      Copyright  2007, dkoloskov |
//|                                             dkoloskov@rambler.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, dkoloskov"
#property link      "dkoloskov@rambler.ru"

#property indicator_chart_window
#property indicator_buffers 1
#property indicator_width1 2
#property indicator_color1 Tomato
double ExtMap[];
extern int       length = 200;

int init()
{
   SetIndexStyle(0, DRAW_LINE);
   SetIndexBuffer(0, ExtMap);
   return(0);
}

int start()
{
   static int rea = 0;
   static int old_bars = 0;   //    
   if (old_bars != Bars)
   {
      delete_result();
      clear_graf();
      write_data(); //     -  
   }
   int handle_read = FileOpen(Symbol()+"_result.txt",FILE_CSV|FILE_READ,';');
   if(handle_read >= 0)
   { 
      Comment(""+TimeCurrent( ) );
      read_n_draw(handle_read);
      delete_result();
      FileClose(handle_read);
      rea=0;
   }
   else 
   {
      rea++;
      Comment(": "+Symbol()+"_result.txt"+"#"+GetLastError()+"#rea"+rea);
      //FileClose(handle_read);
   }
   old_bars = Bars;  //    
   return(0);
}
//+------------------------------------------------------------------+
void read_n_draw(int handle_read)
{
   int i=0;
   while ( !FileIsEnding(handle_read) )
   {
      ExtMap[i] = FileReadNumber(handle_read);
      i++;     
      Comment(ExtMap[0]); 
   }
   ExtMap[i-1] = EMPTY_VALUE;
   
}

void clear_graf()
{
   ArrayInitialize( ExtMap, EMPTY_VALUE);
   return(0);
}

void delete_result()
{
   string filename = Symbol() + "_result.txt";
   FileDelete(filename);
   return(0);
} 
 
void write_data()
{
  int handle;
  string filename = Symbol()  + ".txt"; //   
  handle = FileOpen(filename,FILE_CSV|FILE_WRITE,';');
  if(handle < 1)
  {
    Print("   .  #", GetLastError());
    return(0);
    //FileClose(handle);
  }
  
  FileWrite(handle, "DATE","TIME","HIGH","LOW","CLOSE","OPEN","VOLUME"); // 
  int i;
  for (i=length-1; i>=0; i--)
  {
    FileWrite(handle, TimeToStr(Time[i], TIME_DATE), TimeToStr(Time[i], TIME_SECONDS),
                      High[i], Low[i], Close[i], Open[i], Volume[i]);
  }
  FileClose(handle);
  return(0);
}