//+------------------------------------------------------------------+
//|             Percentage Price Oscillator  --              PPO.mq4 |
//|                                         Developed by Coders Guru |
//|                                            http://www.xpworx.com |
//+------------------------------------------------------------------+

#property link      "http://www.xpworx.com"


#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 Silver

#define MODE_DEMA 4
#define MODE_TEMA 5
#define MODE_T3MA 6

/* Moving average types constants:
------------------------------------
MODE_SMA       0     Simple moving average, 
MODE_EMA       1     Exponential moving average, 
MODE_SMMA      2     Smoothed moving average, 
MODE_LWMA      3     Linear weighted moving average.
MODE_DEMA      4     Double Exponential Moving Average. 
MODE_TEMA      5     Triple Exponential Moving Average.
MODE_T3MA      6     T3 Moving Average. 
------------------------------------*/

/* Applied price constants:
-------------------------------
PRICE_CLOSE    0     Close price. 
PRICE_OPEN     1     Open price. 
PRICE_HIGH     2     High price. 
PRICE_LOW      3     Low price. 
PRICE_MEDIAN   4     Median price, (high+low)/2. 
PRICE_TYPICAL  5     Typical price, (high+low+close)/3. 
PRICE_WEIGHTED 6     Weighted close price, (high+low+close+close)/4.
--------------------------------- */

 
extern   int      FastMA_Period           = 10;             //Fast moving average period
extern   int      SlowMA_Period           = 30;             //Slow moving average period
extern   int      FastMA_Type             = MODE_T3MA;      //Fast moving average type
extern   int      SlowMA_Type             = MODE_T3MA;      //Slow moving average type
extern   int      FastMA_Applied          = PRICE_CLOSE;    //Fast moving average applied price
extern   int      SlowMA_Applied          = PRICE_CLOSE;    //Slow moving average applied price
extern   double   FastT3MA_VolumeFactor   = 0.8;            //Fast moving average applied price
extern   double   SlowT3MA_VolumeFactor   = 0.8;            //Fast moving average applied price

double buffer[];
double FastMABuffer[];
double SlowMABuffer[];
double FastMAFinal[];
double SlowMAFinal[];
double FastMATriple[];
double SlowMATriple[];


int init()
{
   IndicatorBuffers(7); 
   IndicatorShortName("Percentage Price Oscillator");
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,buffer);
   SetIndexBuffer(1,FastMABuffer);
   SetIndexBuffer(2,SlowMABuffer);
   SetIndexBuffer(3,FastMAFinal);
   SetIndexBuffer(4,SlowMAFinal);
   SetIndexBuffer(5,FastMATriple);
   SetIndexBuffer(6,SlowMATriple);
   return(0);
}

int deinit()
{
   return(0);
}



void start()
{
   
   int counted_bars=IndicatorCounted();
   int i = 0;

   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   int limit=Bars-counted_bars;
   
   switch (FastMA_Type)
   {
      case 0:
      case 1:
      case 2:
      case 3:
            {
                  for(i=0; i<limit; i++)
                  {
                     FastMAFinal[i] = iMA(NULL,0,FastMA_Period,0,FastMA_Type,FastMA_Applied,i);
                  }
            }
            break;
      
      case 4:
            {
                  for(i=0; i<limit; i++)
                  {
                     FastMABuffer[i] = iMA(NULL,0,FastMA_Period,0,MODE_EMA,FastMA_Applied,i);
                  }
                  for(i=0; i<limit; i++)
                  {
                     FastMATriple[i] = iMAOnArray(FastMABuffer,0,FastMA_Period,0,MODE_EMA,i);
                  }
                  for(i=0; i<limit; i++)
                  {
                     FastMAFinal[i] = iMAOnArray(FastMATriple,0,FastMA_Period,0,MODE_EMA,i);
                  }
            }
            break;
      
      case 5:
            {
                  for(i=0; i<limit; i++)
                  {
                     FastMABuffer[i] = iMA(NULL,0,FastMA_Period,0,MODE_EMA,FastMA_Applied,i);
                  }
                  for(i=0; i<limit; i++)
                  {
                     FastMAFinal[i] = iMAOnArray(FastMABuffer,0,FastMA_Period,0,MODE_EMA,i);
                  }
            }
            break;
      
      case 6:
            {
                  for(i=0; i<limit; i++)
                  {
                     FastMAFinal[i] = iCustom(NULL,0,"T3MA",FastMA_Period,FastT3MA_VolumeFactor,0,i);
                  }
            }
            break;
   }

   switch (SlowMA_Type)
   {
      case 0:
      case 1:
      case 2:
      case 3:
            {
                  for(i=0; i<limit; i++)
                  {
                     SlowMAFinal[i] = iMA(NULL,0,SlowMA_Period,0,SlowMA_Type,SlowMA_Applied,i);
                  }
            }
            break;
      
      case 4:
            {
                  for(i=0; i<limit; i++)
                  {
                     SlowMABuffer[i] = iMA(NULL,0,SlowMA_Period,0,MODE_EMA,SlowMA_Applied,i);
                  }
                  for(i=0; i<limit; i++)
                  {
                     SlowMAFinal[i] = iMAOnArray(SlowMABuffer,0,SlowMA_Period,0,MODE_EMA,i);
                  }
            }
            break;

      case 5:
            {
                  for(i=0; i<limit; i++)
                  {
                     SlowMABuffer[i] = iMA(NULL,0,SlowMA_Period,0,MODE_EMA,SlowMA_Applied,i);
                  }
                  for(i=0; i<limit; i++)
                  {
                     SlowMATriple[i] = iMAOnArray(SlowMABuffer,0,SlowMA_Period,0,MODE_EMA,i);
                  }
                  for(i=0; i<limit; i++)
                  {
                     SlowMAFinal[i] = iMAOnArray(SlowMATriple,0,SlowMA_Period,0,MODE_EMA,i);
                  }
            }
            break;
      
      case 6:
            {
                  for(i=0; i<limit; i++)
                  {
                     SlowMAFinal[i] = iCustom(NULL,0,"T3MA",SlowMA_Period,FastT3MA_VolumeFactor,0,i);
                  }
            }
            break;
   }
   
   for(i=0; i<limit; i++)
   {
       buffer[i] = (FastMAFinal[i] - SlowMAFinal[i])/FastMAFinal[i];
       //Print (FastMAFinal[i],":",SlowMAFinal[i],":",(FastMAFinal[i] - SlowMAFinal[i])/FastMAFinal[i]);
   }


   
   return(0);
}



